/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import java.io.Serializable;
import org.apache.commons.math3.exception.DimensionMismatchException;

public class EquationsMapper
implements Serializable {
    private static final long serialVersionUID = 20110925L;
    private final int firstIndex;
    private final int dimension;

    public EquationsMapper(int n, int n2) {
        this.firstIndex = n;
        this.dimension = n2;
    }

    public int getFirstIndex() {
        return this.firstIndex;
    }

    public int getDimension() {
        return this.dimension;
    }

    public void extractEquationData(double[] dArray, double[] dArray2) {
        if (dArray2.length != this.dimension) {
            throw new DimensionMismatchException(dArray2.length, this.dimension);
        }
        System.arraycopy(dArray, this.firstIndex, dArray2, 0, this.dimension);
    }

    public void insertEquationData(double[] dArray, double[] dArray2) {
        if (dArray.length != this.dimension) {
            throw new DimensionMismatchException(dArray.length, this.dimension);
        }
        System.arraycopy(dArray, 0, dArray2, this.firstIndex, this.dimension);
    }
}

