/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.ode.EquationsMapper;
import org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math3.ode.SecondaryEquations;

public class ExpandableStatefulODE {
    private final FirstOrderDifferentialEquations primary;
    private final EquationsMapper primaryMapper;
    private double time;
    private final double[] primaryState;
    private final double[] primaryStateDot;
    private List<SecondaryComponent> components;

    public ExpandableStatefulODE(FirstOrderDifferentialEquations firstOrderDifferentialEquations) {
        int n = firstOrderDifferentialEquations.getDimension();
        this.primary = firstOrderDifferentialEquations;
        this.primaryMapper = new EquationsMapper(0, n);
        this.time = Double.NaN;
        this.primaryState = new double[n];
        this.primaryStateDot = new double[n];
        this.components = new ArrayList<SecondaryComponent>();
    }

    public FirstOrderDifferentialEquations getPrimary() {
        return this.primary;
    }

    public int getTotalDimension() {
        if (this.components.isEmpty()) {
            return this.primaryMapper.getDimension();
        }
        EquationsMapper equationsMapper = this.components.get(this.components.size() - 1).mapper;
        return equationsMapper.getFirstIndex() + equationsMapper.getDimension();
    }

    public void computeDerivatives(double d, double[] dArray, double[] dArray2) {
        this.primaryMapper.extractEquationData(dArray, this.primaryState);
        this.primary.computeDerivatives(d, this.primaryState, this.primaryStateDot);
        for (SecondaryComponent secondaryComponent : this.components) {
            secondaryComponent.mapper.extractEquationData(dArray, secondaryComponent.state);
            secondaryComponent.equation.computeDerivatives(d, this.primaryState, this.primaryStateDot, secondaryComponent.state, secondaryComponent.stateDot);
            secondaryComponent.mapper.insertEquationData(secondaryComponent.stateDot, dArray2);
        }
        this.primaryMapper.insertEquationData(this.primaryStateDot, dArray2);
    }

    public int addSecondaryEquations(SecondaryEquations secondaryEquations) {
        int n;
        if (this.components.isEmpty()) {
            this.components = new ArrayList<SecondaryComponent>();
            n = this.primary.getDimension();
        } else {
            SecondaryComponent secondaryComponent = this.components.get(this.components.size() - 1);
            n = secondaryComponent.mapper.getFirstIndex() + secondaryComponent.mapper.getDimension();
        }
        this.components.add(new SecondaryComponent(secondaryEquations, n));
        return this.components.size() - 1;
    }

    public EquationsMapper getPrimaryMapper() {
        return this.primaryMapper;
    }

    public EquationsMapper[] getSecondaryMappers() {
        EquationsMapper[] equationsMapperArray = new EquationsMapper[this.components.size()];
        for (int i = 0; i < equationsMapperArray.length; ++i) {
            equationsMapperArray[i] = this.components.get(i).mapper;
        }
        return equationsMapperArray;
    }

    public void setTime(double d) {
        this.time = d;
    }

    public double getTime() {
        return this.time;
    }

    public void setPrimaryState(double[] dArray) {
        if (dArray.length != this.primaryState.length) {
            throw new DimensionMismatchException(dArray.length, this.primaryState.length);
        }
        System.arraycopy(dArray, 0, this.primaryState, 0, dArray.length);
    }

    public double[] getPrimaryState() {
        return (double[])this.primaryState.clone();
    }

    public double[] getPrimaryStateDot() {
        return (double[])this.primaryStateDot.clone();
    }

    public void setSecondaryState(int n, double[] dArray) {
        double[] dArray2 = this.components.get(n).state;
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
    }

    public double[] getSecondaryState(int n) {
        return (double[])this.components.get(n).state.clone();
    }

    public double[] getSecondaryStateDot(int n) {
        return (double[])this.components.get(n).stateDot.clone();
    }

    public void setCompleteState(double[] dArray) {
        if (dArray.length != this.getTotalDimension()) {
            throw new DimensionMismatchException(dArray.length, this.getTotalDimension());
        }
        this.primaryMapper.extractEquationData(dArray, this.primaryState);
        for (SecondaryComponent secondaryComponent : this.components) {
            secondaryComponent.mapper.extractEquationData(dArray, secondaryComponent.state);
        }
    }

    public double[] getCompleteState() {
        double[] dArray = new double[this.getTotalDimension()];
        this.primaryMapper.insertEquationData(this.primaryState, dArray);
        for (SecondaryComponent secondaryComponent : this.components) {
            secondaryComponent.mapper.insertEquationData(secondaryComponent.state, dArray);
        }
        return dArray;
    }

    private static class SecondaryComponent {
        private final SecondaryEquations equation;
        private final EquationsMapper mapper;
        private final double[] state;
        private final double[] stateDot;

        SecondaryComponent(SecondaryEquations secondaryEquations, int n) {
            int n2 = secondaryEquations.getDimension();
            this.equation = secondaryEquations;
            this.mapper = new EquationsMapper(n, n2);
            this.state = new double[n2];
            this.stateDot = new double[n2];
        }
    }
}

