/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import java.io.Serializable;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.ode.FieldODEState;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldEquationsMapper<T extends RealFieldElement<T>>
implements Serializable {
    private static final long serialVersionUID = 20151114L;
    private final int[] start;

    FieldEquationsMapper(FieldEquationsMapper<T> fieldEquationsMapper, int n) {
        int n2 = fieldEquationsMapper == null ? 0 : fieldEquationsMapper.getNumberOfEquations();
        this.start = new int[n2 + 2];
        if (fieldEquationsMapper == null) {
            this.start[0] = 0;
        } else {
            System.arraycopy(fieldEquationsMapper.start, 0, this.start, 0, n2 + 1);
        }
        this.start[n2 + 1] = this.start[n2] + n;
    }

    public int getNumberOfEquations() {
        return this.start.length - 1;
    }

    public int getTotalDimension() {
        return this.start[this.start.length - 1];
    }

    public T[] mapState(FieldODEState<T> fieldODEState) {
        RealFieldElement[] realFieldElementArray = (RealFieldElement[])MathArrays.buildArray(fieldODEState.getTime().getField(), this.getTotalDimension());
        int n = 0;
        this.insertEquationData(n, fieldODEState.getState(), realFieldElementArray);
        while (++n < this.getNumberOfEquations()) {
            this.insertEquationData(n, fieldODEState.getSecondaryState(n), realFieldElementArray);
        }
        return realFieldElementArray;
    }

    public T[] mapDerivative(FieldODEStateAndDerivative<T> fieldODEStateAndDerivative) {
        RealFieldElement[] realFieldElementArray = (RealFieldElement[])MathArrays.buildArray(fieldODEStateAndDerivative.getTime().getField(), this.getTotalDimension());
        int n = 0;
        this.insertEquationData(n, fieldODEStateAndDerivative.getDerivative(), realFieldElementArray);
        while (++n < this.getNumberOfEquations()) {
            this.insertEquationData(n, fieldODEStateAndDerivative.getSecondaryDerivative(n), realFieldElementArray);
        }
        return realFieldElementArray;
    }

    public FieldODEStateAndDerivative<T> mapStateAndDerivative(T t, T[] TArray, T[] TArray2) {
        if (TArray.length != this.getTotalDimension()) {
            throw new DimensionMismatchException(TArray.length, this.getTotalDimension());
        }
        if (TArray2.length != this.getTotalDimension()) {
            throw new DimensionMismatchException(TArray2.length, this.getTotalDimension());
        }
        int n = this.getNumberOfEquations();
        int n2 = 0;
        RealFieldElement[] realFieldElementArray = this.extractEquationData(n2, (RealFieldElement[])TArray);
        RealFieldElement[] realFieldElementArray2 = this.extractEquationData(n2, (RealFieldElement[])TArray2);
        if (n < 2) {
            return new FieldODEStateAndDerivative(t, realFieldElementArray, realFieldElementArray2);
        }
        RealFieldElement[][] realFieldElementArray3 = (RealFieldElement[][])MathArrays.buildArray(t.getField(), n - 1, -1);
        RealFieldElement[][] realFieldElementArray4 = (RealFieldElement[][])MathArrays.buildArray(t.getField(), n - 1, -1);
        while (++n2 < this.getNumberOfEquations()) {
            realFieldElementArray3[n2 - 1] = this.extractEquationData(n2, (RealFieldElement[])TArray);
            realFieldElementArray4[n2 - 1] = this.extractEquationData(n2, (RealFieldElement[])TArray2);
        }
        return new FieldODEStateAndDerivative(t, realFieldElementArray, realFieldElementArray2, realFieldElementArray3, realFieldElementArray4);
    }

    public T[] extractEquationData(int n, T[] TArray) {
        this.checkIndex(n);
        int n2 = this.start[n];
        int n3 = this.start[n + 1];
        if (TArray.length < n3) {
            throw new DimensionMismatchException(TArray.length, n3);
        }
        int n4 = n3 - n2;
        RealFieldElement[] realFieldElementArray = (RealFieldElement[])MathArrays.buildArray(TArray[0].getField(), n4);
        System.arraycopy(TArray, n2, realFieldElementArray, 0, n4);
        return realFieldElementArray;
    }

    public void insertEquationData(int n, T[] TArray, T[] TArray2) {
        this.checkIndex(n);
        int n2 = this.start[n];
        int n3 = this.start[n + 1];
        int n4 = n3 - n2;
        if (TArray2.length < n3) {
            throw new DimensionMismatchException(TArray2.length, n3);
        }
        if (TArray.length != n4) {
            throw new DimensionMismatchException(TArray.length, n4);
        }
        System.arraycopy(TArray, 0, TArray2, n2, n4);
    }

    private void checkIndex(int n) {
        if (n < 0 || n > this.start.length - 2) {
            throw new MathIllegalArgumentException(LocalizedFormats.ARGUMENT_OUTSIDE_DOMAIN, n, 0, this.start.length - 2);
        }
    }
}

