/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math3.ode.SecondOrderDifferentialEquations;

public class FirstOrderConverter
implements FirstOrderDifferentialEquations {
    private final SecondOrderDifferentialEquations equations;
    private final int dimension;
    private final double[] z;
    private final double[] zDot;
    private final double[] zDDot;

    public FirstOrderConverter(SecondOrderDifferentialEquations secondOrderDifferentialEquations) {
        this.equations = secondOrderDifferentialEquations;
        this.dimension = secondOrderDifferentialEquations.getDimension();
        this.z = new double[this.dimension];
        this.zDot = new double[this.dimension];
        this.zDDot = new double[this.dimension];
    }

    public int getDimension() {
        return 2 * this.dimension;
    }

    public void computeDerivatives(double d, double[] dArray, double[] dArray2) {
        System.arraycopy(dArray, 0, this.z, 0, this.dimension);
        System.arraycopy(dArray, this.dimension, this.zDot, 0, this.dimension);
        this.equations.computeSecondDerivatives(d, this.z, this.zDot, this.zDDot);
        System.arraycopy(this.zDot, 0, dArray2, 0, this.dimension);
        System.arraycopy(this.zDDot, 0, dArray2, this.dimension, this.dimension);
    }
}

