/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.ode.AbstractIntegrator;
import org.apache.commons.math3.ode.EquationsMapper;
import org.apache.commons.math3.ode.ExpandableStatefulODE;
import org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math3.ode.FirstOrderIntegrator;
import org.apache.commons.math3.ode.ODEIntegrator;
import org.apache.commons.math3.ode.nonstiff.AdaptiveStepsizeIntegrator;
import org.apache.commons.math3.ode.nonstiff.DormandPrince853Integrator;
import org.apache.commons.math3.ode.sampling.StepHandler;
import org.apache.commons.math3.ode.sampling.StepInterpolator;
import org.apache.commons.math3.util.FastMath;

public abstract class MultistepIntegrator
extends AdaptiveStepsizeIntegrator {
    protected double[] scaled;
    protected Array2DRowRealMatrix nordsieck;
    private FirstOrderIntegrator starter;
    private final int nSteps;
    private double exp;
    private double safety;
    private double minReduction;
    private double maxGrowth;

    protected MultistepIntegrator(String string, int n, int n2, double d, double d2, double d3, double d4) {
        super(string, d, d2, d3, d4);
        if (n < 2) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INTEGRATION_METHOD_NEEDS_AT_LEAST_TWO_PREVIOUS_POINTS, (Number)n, 2, true);
        }
        this.starter = new DormandPrince853Integrator(d, d2, d3, d4);
        this.nSteps = n;
        this.exp = -1.0 / (double)n2;
        this.setSafety(0.9);
        this.setMinReduction(0.2);
        this.setMaxGrowth(FastMath.pow(2.0, -this.exp));
    }

    protected MultistepIntegrator(String string, int n, int n2, double d, double d2, double[] dArray, double[] dArray2) {
        super(string, d, d2, dArray, dArray2);
        this.starter = new DormandPrince853Integrator(d, d2, dArray, dArray2);
        this.nSteps = n;
        this.exp = -1.0 / (double)n2;
        this.setSafety(0.9);
        this.setMinReduction(0.2);
        this.setMaxGrowth(FastMath.pow(2.0, -this.exp));
    }

    public ODEIntegrator getStarterIntegrator() {
        return this.starter;
    }

    public void setStarterIntegrator(FirstOrderIntegrator firstOrderIntegrator) {
        this.starter = firstOrderIntegrator;
    }

    protected void start(double d, double[] dArray, double d2) {
        this.starter.clearEventHandlers();
        this.starter.clearStepHandlers();
        this.starter.addStepHandler(new NordsieckInitializer((this.nSteps + 3) / 2, dArray.length));
        try {
            if (this.starter instanceof AbstractIntegrator) {
                ((AbstractIntegrator)this.starter).integrate(this.getExpandable(), d2);
            } else {
                this.starter.integrate(new FirstOrderDifferentialEquations(){

                    public int getDimension() {
                        return MultistepIntegrator.this.getExpandable().getTotalDimension();
                    }

                    public void computeDerivatives(double d, double[] dArray, double[] dArray2) {
                        MultistepIntegrator.this.getExpandable().computeDerivatives(d, dArray, dArray2);
                    }
                }, d, dArray, d2, new double[dArray.length]);
            }
            throw new MathIllegalStateException(LocalizedFormats.MULTISTEP_STARTER_STOPPED_EARLY, new Object[0]);
        }
        catch (InitializationCompletedMarkerException initializationCompletedMarkerException) {
            this.getCounter().increment(this.starter.getEvaluations());
            this.starter.clearStepHandlers();
            return;
        }
    }

    protected abstract Array2DRowRealMatrix initializeHighOrderDerivatives(double var1, double[] var3, double[][] var4, double[][] var5);

    public double getMinReduction() {
        return this.minReduction;
    }

    public void setMinReduction(double d) {
        this.minReduction = d;
    }

    public double getMaxGrowth() {
        return this.maxGrowth;
    }

    public void setMaxGrowth(double d) {
        this.maxGrowth = d;
    }

    public double getSafety() {
        return this.safety;
    }

    public void setSafety(double d) {
        this.safety = d;
    }

    public int getNSteps() {
        return this.nSteps;
    }

    protected double computeStepGrowShrinkFactor(double d) {
        return FastMath.min(this.maxGrowth, FastMath.max(this.minReduction, this.safety * FastMath.pow(d, this.exp)));
    }

    private static class InitializationCompletedMarkerException
    extends RuntimeException {
        private static final long serialVersionUID = -1914085471038046418L;

        InitializationCompletedMarkerException() {
            super((Throwable)null);
        }
    }

    private class NordsieckInitializer
    implements StepHandler {
        private int count = 0;
        private final double[] t;
        private final double[][] y;
        private final double[][] yDot;

        NordsieckInitializer(int n, int n2) {
            this.t = new double[n];
            this.y = new double[n][n2];
            this.yDot = new double[n][n2];
        }

        public void handleStep(StepInterpolator stepInterpolator, boolean bl) {
            int n;
            EquationsMapper equationsMapper;
            ExpandableStatefulODE expandableStatefulODE;
            double d = stepInterpolator.getPreviousTime();
            double d2 = stepInterpolator.getCurrentTime();
            if (this.count == 0) {
                stepInterpolator.setInterpolatedTime(d);
                this.t[0] = d;
                expandableStatefulODE = MultistepIntegrator.this.getExpandable();
                equationsMapper = expandableStatefulODE.getPrimaryMapper();
                equationsMapper.insertEquationData(stepInterpolator.getInterpolatedState(), this.y[this.count]);
                equationsMapper.insertEquationData(stepInterpolator.getInterpolatedDerivatives(), this.yDot[this.count]);
                n = 0;
                for (EquationsMapper equationsMapper2 : expandableStatefulODE.getSecondaryMappers()) {
                    equationsMapper2.insertEquationData(stepInterpolator.getInterpolatedSecondaryState(n), this.y[this.count]);
                    equationsMapper2.insertEquationData(stepInterpolator.getInterpolatedSecondaryDerivatives(n), this.yDot[this.count]);
                    ++n;
                }
            }
            ++this.count;
            stepInterpolator.setInterpolatedTime(d2);
            this.t[this.count] = d2;
            expandableStatefulODE = MultistepIntegrator.this.getExpandable();
            equationsMapper = expandableStatefulODE.getPrimaryMapper();
            equationsMapper.insertEquationData(stepInterpolator.getInterpolatedState(), this.y[this.count]);
            equationsMapper.insertEquationData(stepInterpolator.getInterpolatedDerivatives(), this.yDot[this.count]);
            n = 0;
            for (EquationsMapper equationsMapper2 : expandableStatefulODE.getSecondaryMappers()) {
                equationsMapper2.insertEquationData(stepInterpolator.getInterpolatedSecondaryState(n), this.y[this.count]);
                equationsMapper2.insertEquationData(stepInterpolator.getInterpolatedSecondaryDerivatives(n), this.yDot[this.count]);
                ++n;
            }
            if (this.count == this.t.length - 1) {
                MultistepIntegrator.this.stepStart = this.t[0];
                MultistepIntegrator.this.stepSize = (this.t[this.t.length - 1] - this.t[0]) / (double)(this.t.length - 1);
                MultistepIntegrator.this.scaled = (double[])this.yDot[0].clone();
                int n2 = 0;
                while (n2 < MultistepIntegrator.this.scaled.length) {
                    int n3 = n2++;
                    MultistepIntegrator.this.scaled[n3] = MultistepIntegrator.this.scaled[n3] * MultistepIntegrator.this.stepSize;
                }
                MultistepIntegrator.this.nordsieck = MultistepIntegrator.this.initializeHighOrderDerivatives(MultistepIntegrator.this.stepSize, this.t, this.y, this.yDot);
                throw new InitializationCompletedMarkerException();
            }
        }

        public void init(double d, double[] dArray, double d2) {
        }
    }

    @Deprecated
    public static interface NordsieckTransformer {
        public Array2DRowRealMatrix initializeHighOrderDerivatives(double var1, double[] var3, double[][] var4, double[][] var5);
    }
}

