/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math3.ode.ParameterConfiguration;
import org.apache.commons.math3.ode.ParameterJacobianProvider;
import org.apache.commons.math3.ode.ParameterizedODE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParameterJacobianWrapper
implements ParameterJacobianProvider {
    private final FirstOrderDifferentialEquations fode;
    private final ParameterizedODE pode;
    private final Map<String, Double> hParam;

    ParameterJacobianWrapper(FirstOrderDifferentialEquations firstOrderDifferentialEquations, ParameterizedODE parameterizedODE, ParameterConfiguration[] parameterConfigurationArray) {
        this.fode = firstOrderDifferentialEquations;
        this.pode = parameterizedODE;
        this.hParam = new HashMap<String, Double>();
        for (ParameterConfiguration parameterConfiguration : parameterConfigurationArray) {
            String string = parameterConfiguration.getParameterName();
            if (!parameterizedODE.isSupported(string)) continue;
            this.hParam.put(string, parameterConfiguration.getHP());
        }
    }

    @Override
    public Collection<String> getParametersNames() {
        return this.pode.getParametersNames();
    }

    @Override
    public boolean isSupported(String string) {
        return this.pode.isSupported(string);
    }

    @Override
    public void computeParameterJacobian(double d, double[] dArray, double[] dArray2, String string, double[] dArray3) {
        int n = this.fode.getDimension();
        if (this.pode.isSupported(string)) {
            double[] dArray4 = new double[n];
            double d2 = this.pode.getParameter(string);
            double d3 = this.hParam.get(string);
            this.pode.setParameter(string, d2 + d3);
            this.fode.computeDerivatives(d, dArray, dArray4);
            for (int i = 0; i < n; ++i) {
                dArray3[i] = (dArray4[i] - dArray2[i]) / d3;
            }
            this.pode.setParameter(string, d2);
        } else {
            Arrays.fill(dArray3, 0, n, 0.0);
        }
    }
}

