/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.events;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.solvers.AllowedSolution;
import org.apache.commons.math3.analysis.solvers.BracketedUnivariateSolver;
import org.apache.commons.math3.analysis.solvers.PegasusSolver;
import org.apache.commons.math3.analysis.solvers.UnivariateSolver;
import org.apache.commons.math3.analysis.solvers.UnivariateSolverUtils;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.ode.EquationsMapper;
import org.apache.commons.math3.ode.ExpandableStatefulODE;
import org.apache.commons.math3.ode.events.EventHandler;
import org.apache.commons.math3.ode.sampling.StepInterpolator;
import org.apache.commons.math3.util.FastMath;

public class EventState {
    private final EventHandler handler;
    private final double maxCheckInterval;
    private final double convergence;
    private final int maxIterationCount;
    private ExpandableStatefulODE expandable;
    private double t0;
    private double g0;
    private boolean g0Positive;
    private boolean pendingEvent;
    private double pendingEventTime;
    private double previousEventTime;
    private boolean forward;
    private boolean increasing;
    private EventHandler.Action nextAction;
    private final UnivariateSolver solver;

    public EventState(EventHandler eventHandler, double d, double d2, int n, UnivariateSolver univariateSolver) {
        this.handler = eventHandler;
        this.maxCheckInterval = d;
        this.convergence = FastMath.abs(d2);
        this.maxIterationCount = n;
        this.solver = univariateSolver;
        this.expandable = null;
        this.t0 = Double.NaN;
        this.g0 = Double.NaN;
        this.g0Positive = true;
        this.pendingEvent = false;
        this.pendingEventTime = Double.NaN;
        this.previousEventTime = Double.NaN;
        this.increasing = true;
        this.nextAction = EventHandler.Action.CONTINUE;
    }

    public EventHandler getEventHandler() {
        return this.handler;
    }

    public void setExpandable(ExpandableStatefulODE expandableStatefulODE) {
        this.expandable = expandableStatefulODE;
    }

    public double getMaxCheckInterval() {
        return this.maxCheckInterval;
    }

    public double getConvergence() {
        return this.convergence;
    }

    public int getMaxIterationCount() {
        return this.maxIterationCount;
    }

    public void reinitializeBegin(StepInterpolator stepInterpolator) {
        this.t0 = stepInterpolator.getPreviousTime();
        stepInterpolator.setInterpolatedTime(this.t0);
        this.g0 = this.handler.g(this.t0, this.getCompleteState(stepInterpolator));
        if (this.g0 == 0.0) {
            double d = FastMath.max(this.solver.getAbsoluteAccuracy(), FastMath.abs(this.solver.getRelativeAccuracy() * this.t0));
            double d2 = this.t0 + 0.5 * d;
            stepInterpolator.setInterpolatedTime(d2);
            this.g0 = this.handler.g(d2, this.getCompleteState(stepInterpolator));
        }
        this.g0Positive = this.g0 >= 0.0;
    }

    private double[] getCompleteState(StepInterpolator stepInterpolator) {
        double[] dArray = new double[this.expandable.getTotalDimension()];
        this.expandable.getPrimaryMapper().insertEquationData(stepInterpolator.getInterpolatedState(), dArray);
        int n = 0;
        for (EquationsMapper equationsMapper : this.expandable.getSecondaryMappers()) {
            equationsMapper.insertEquationData(stepInterpolator.getInterpolatedSecondaryState(n++), dArray);
        }
        return dArray;
    }

    public boolean evaluateStep(final StepInterpolator stepInterpolator) {
        try {
            this.forward = stepInterpolator.isForward();
            double d = stepInterpolator.getCurrentTime();
            double d2 = d - this.t0;
            if (FastMath.abs(d2) < this.convergence) {
                return false;
            }
            int n = FastMath.max(1, (int)FastMath.ceil(FastMath.abs(d2) / this.maxCheckInterval));
            double d3 = d2 / (double)n;
            UnivariateFunction univariateFunction = new UnivariateFunction(){

                public double value(double d) {
                    try {
                        stepInterpolator.setInterpolatedTime(d);
                        return EventState.this.handler.g(d, EventState.this.getCompleteState(stepInterpolator));
                    }
                    catch (MaxCountExceededException maxCountExceededException) {
                        throw new LocalMaxCountExceededException(maxCountExceededException);
                    }
                }
            };
            double d4 = this.t0;
            double d5 = this.g0;
            for (int i = 0; i < n; ++i) {
                double d6 = i == n - 1 ? d : this.t0 + (double)(i + 1) * d3;
                stepInterpolator.setInterpolatedTime(d6);
                double d7 = this.handler.g(d6, this.getCompleteState(stepInterpolator));
                if (this.g0Positive ^ d7 >= 0.0) {
                    double d8;
                    boolean bl = this.increasing = d7 >= d5;
                    if (this.solver instanceof BracketedUnivariateSolver) {
                        BracketedUnivariateSolver bracketedUnivariateSolver = (BracketedUnivariateSolver)((Object)this.solver);
                        d8 = this.forward ? bracketedUnivariateSolver.solve(this.maxIterationCount, univariateFunction, d4, d6, AllowedSolution.RIGHT_SIDE) : bracketedUnivariateSolver.solve(this.maxIterationCount, univariateFunction, d6, d4, AllowedSolution.LEFT_SIDE);
                    } else {
                        double d9 = this.forward ? this.solver.solve(this.maxIterationCount, univariateFunction, d4, d6) : this.solver.solve(this.maxIterationCount, univariateFunction, d6, d4);
                        int n2 = this.maxIterationCount - this.solver.getEvaluations();
                        PegasusSolver pegasusSolver = new PegasusSolver(this.solver.getRelativeAccuracy(), this.solver.getAbsoluteAccuracy());
                        double d10 = d8 = this.forward ? UnivariateSolverUtils.forceSide(n2, univariateFunction, pegasusSolver, d9, d4, d6, AllowedSolution.RIGHT_SIDE) : UnivariateSolverUtils.forceSide(n2, univariateFunction, pegasusSolver, d9, d6, d4, AllowedSolution.LEFT_SIDE);
                    }
                    if (!Double.isNaN(this.previousEventTime) && FastMath.abs(d8 - d4) <= this.convergence && FastMath.abs(d8 - this.previousEventTime) <= this.convergence) {
                        while (this.g0Positive ^ (d5 = univariateFunction.value(d4 = this.forward ? d4 + this.convergence : d4 - this.convergence)) >= 0.0 && this.forward ^ d4 >= d6) {
                        }
                        if (this.forward ^ d4 >= d6) {
                            --i;
                            continue;
                        }
                        this.pendingEventTime = d8;
                        this.pendingEvent = true;
                        return true;
                    }
                    if (Double.isNaN(this.previousEventTime) || FastMath.abs(this.previousEventTime - d8) > this.convergence) {
                        this.pendingEventTime = d8;
                        this.pendingEvent = true;
                        return true;
                    }
                    d4 = d6;
                    d5 = d7;
                    continue;
                }
                d4 = d6;
                d5 = d7;
            }
            this.pendingEvent = false;
            this.pendingEventTime = Double.NaN;
            return false;
        }
        catch (LocalMaxCountExceededException localMaxCountExceededException) {
            throw localMaxCountExceededException.getException();
        }
    }

    public double getEventTime() {
        return this.pendingEvent ? this.pendingEventTime : (this.forward ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY);
    }

    public void stepAccepted(double d, double[] dArray) {
        this.t0 = d;
        this.g0 = this.handler.g(d, dArray);
        if (this.pendingEvent && FastMath.abs(this.pendingEventTime - d) <= this.convergence) {
            this.previousEventTime = d;
            this.g0Positive = this.increasing;
            this.nextAction = this.handler.eventOccurred(d, dArray, !(this.increasing ^ this.forward));
        } else {
            this.g0Positive = this.g0 >= 0.0;
            this.nextAction = EventHandler.Action.CONTINUE;
        }
    }

    public boolean stop() {
        return this.nextAction == EventHandler.Action.STOP;
    }

    public boolean reset(double d, double[] dArray) {
        if (!this.pendingEvent || !(FastMath.abs(this.pendingEventTime - d) <= this.convergence)) {
            return false;
        }
        if (this.nextAction == EventHandler.Action.RESET_STATE) {
            this.handler.resetState(d, dArray);
        }
        this.pendingEvent = false;
        this.pendingEventTime = Double.NaN;
        return this.nextAction == EventHandler.Action.RESET_STATE || this.nextAction == EventHandler.Action.RESET_DERIVATIVES;
    }

    private static class LocalMaxCountExceededException
    extends RuntimeException {
        private static final long serialVersionUID = 20120901L;
        private final MaxCountExceededException wrapped;

        LocalMaxCountExceededException(MaxCountExceededException maxCountExceededException) {
            this.wrapped = maxCountExceededException;
        }

        public MaxCountExceededException getException() {
            return this.wrapped;
        }
    }
}

