/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.events;

import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.analysis.RealFieldUnivariateFunction;
import org.apache.commons.math3.analysis.solvers.AllowedSolution;
import org.apache.commons.math3.analysis.solvers.BracketedRealFieldUnivariateSolver;
import org.apache.commons.math3.ode.FieldODEState;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.ode.events.Action;
import org.apache.commons.math3.ode.events.FieldEventHandler;
import org.apache.commons.math3.ode.sampling.FieldStepInterpolator;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldEventState<T extends RealFieldElement<T>> {
    private final FieldEventHandler<T> handler;
    private final double maxCheckInterval;
    private final T convergence;
    private final int maxIterationCount;
    private T t0;
    private T g0;
    private boolean g0Positive;
    private boolean pendingEvent;
    private T pendingEventTime;
    private T previousEventTime;
    private boolean forward;
    private boolean increasing;
    private Action nextAction;
    private final BracketedRealFieldUnivariateSolver<T> solver;

    public FieldEventState(FieldEventHandler<T> fieldEventHandler, double d, T t, int n, BracketedRealFieldUnivariateSolver<T> bracketedRealFieldUnivariateSolver) {
        this.handler = fieldEventHandler;
        this.maxCheckInterval = d;
        this.convergence = (RealFieldElement)t.abs();
        this.maxIterationCount = n;
        this.solver = bracketedRealFieldUnivariateSolver;
        this.t0 = null;
        this.g0 = null;
        this.g0Positive = true;
        this.pendingEvent = false;
        this.pendingEventTime = null;
        this.previousEventTime = null;
        this.increasing = true;
        this.nextAction = Action.CONTINUE;
    }

    public FieldEventHandler<T> getEventHandler() {
        return this.handler;
    }

    public double getMaxCheckInterval() {
        return this.maxCheckInterval;
    }

    public T getConvergence() {
        return this.convergence;
    }

    public int getMaxIterationCount() {
        return this.maxIterationCount;
    }

    public void reinitializeBegin(FieldStepInterpolator<T> fieldStepInterpolator) {
        FieldODEStateAndDerivative<T> fieldODEStateAndDerivative = fieldStepInterpolator.getPreviousState();
        this.t0 = fieldODEStateAndDerivative.getTime();
        this.g0 = this.handler.g(fieldODEStateAndDerivative);
        if (this.g0.getReal() == 0.0) {
            double d = FastMath.max(this.solver.getAbsoluteAccuracy().getReal(), FastMath.abs(((RealFieldElement)this.solver.getRelativeAccuracy().multiply(this.t0)).getReal()));
            RealFieldElement realFieldElement = (RealFieldElement)this.t0.add(0.5 * d);
            this.g0 = this.handler.g(fieldStepInterpolator.getInterpolatedState(realFieldElement));
        }
        this.g0Positive = this.g0.getReal() >= 0.0;
    }

    public boolean evaluateStep(final FieldStepInterpolator<T> fieldStepInterpolator) {
        this.forward = fieldStepInterpolator.isForward();
        FieldODEStateAndDerivative<T> fieldODEStateAndDerivative = fieldStepInterpolator.getCurrentState();
        T t = fieldODEStateAndDerivative.getTime();
        RealFieldElement realFieldElement = (RealFieldElement)t.subtract(this.t0);
        if (((RealFieldElement)((RealFieldElement)realFieldElement.abs()).subtract(this.convergence)).getReal() < 0.0) {
            return false;
        }
        int n = FastMath.max(1, (int)FastMath.ceil(FastMath.abs(realFieldElement.getReal()) / this.maxCheckInterval));
        RealFieldElement realFieldElement2 = (RealFieldElement)realFieldElement.divide(n);
        RealFieldUnivariateFunction realFieldUnivariateFunction = new RealFieldUnivariateFunction<T>(){

            @Override
            public T value(T t) {
                return FieldEventState.this.handler.g(fieldStepInterpolator.getInterpolatedState(t));
            }
        };
        Object object = this.t0;
        T t2 = this.g0;
        for (int i = 0; i < n; ++i) {
            Object object2 = i == n - 1 ? t : (RealFieldElement)this.t0.add(realFieldElement2.multiply(i + 1));
            T t3 = this.handler.g(fieldStepInterpolator.getInterpolatedState(object2));
            if (this.g0Positive ^ t3.getReal() >= 0.0) {
                T t4;
                this.increasing = ((RealFieldElement)t3.subtract(t2)).getReal() >= 0.0;
                T t5 = t4 = this.forward ? this.solver.solve(this.maxIterationCount, realFieldUnivariateFunction, object, object2, AllowedSolution.RIGHT_SIDE) : this.solver.solve(this.maxIterationCount, realFieldUnivariateFunction, object2, object, AllowedSolution.LEFT_SIDE);
                if (this.previousEventTime != null && ((RealFieldElement)((RealFieldElement)((RealFieldElement)t4.subtract(object)).abs()).subtract(this.convergence)).getReal() <= 0.0 && ((RealFieldElement)((RealFieldElement)((RealFieldElement)t4.subtract(this.previousEventTime)).abs()).subtract(this.convergence)).getReal() <= 0.0) {
                    while (this.g0Positive ^ (t2 = realFieldUnivariateFunction.value(object = this.forward ? (RealFieldElement)object.add(this.convergence) : (RealFieldElement)object.subtract(this.convergence))).getReal() >= 0.0 && this.forward ^ ((RealFieldElement)object.subtract(object2)).getReal() >= 0.0) {
                    }
                    if (this.forward ^ ((RealFieldElement)object.subtract(object2)).getReal() >= 0.0) {
                        --i;
                        continue;
                    }
                    this.pendingEventTime = t4;
                    this.pendingEvent = true;
                    return true;
                }
                if (this.previousEventTime == null || ((RealFieldElement)((RealFieldElement)((RealFieldElement)this.previousEventTime.subtract(t4)).abs()).subtract(this.convergence)).getReal() > 0.0) {
                    this.pendingEventTime = t4;
                    this.pendingEvent = true;
                    return true;
                }
                object = object2;
                t2 = t3;
                continue;
            }
            object = object2;
            t2 = t3;
        }
        this.pendingEvent = false;
        this.pendingEventTime = null;
        return false;
    }

    public T getEventTime() {
        return (T)(this.pendingEvent ? this.pendingEventTime : (RealFieldElement)((RealFieldElement)this.t0.getField().getZero()).add(this.forward ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY));
    }

    public void stepAccepted(FieldODEStateAndDerivative<T> fieldODEStateAndDerivative) {
        this.t0 = fieldODEStateAndDerivative.getTime();
        this.g0 = this.handler.g(fieldODEStateAndDerivative);
        if (this.pendingEvent && ((RealFieldElement)((RealFieldElement)((RealFieldElement)this.pendingEventTime.subtract(fieldODEStateAndDerivative.getTime())).abs()).subtract(this.convergence)).getReal() <= 0.0) {
            this.previousEventTime = fieldODEStateAndDerivative.getTime();
            this.g0Positive = this.increasing;
            this.nextAction = this.handler.eventOccurred(fieldODEStateAndDerivative, !(this.increasing ^ this.forward));
        } else {
            this.g0Positive = this.g0.getReal() >= 0.0;
            this.nextAction = Action.CONTINUE;
        }
    }

    public boolean stop() {
        return this.nextAction == Action.STOP;
    }

    public FieldODEState<T> reset(FieldODEStateAndDerivative<T> fieldODEStateAndDerivative) {
        if (!this.pendingEvent || !(((RealFieldElement)((RealFieldElement)((RealFieldElement)this.pendingEventTime.subtract(fieldODEStateAndDerivative.getTime())).abs()).subtract(this.convergence)).getReal() <= 0.0)) {
            return null;
        }
        FieldODEState<T> fieldODEState = this.nextAction == Action.RESET_STATE ? this.handler.resetState(fieldODEStateAndDerivative) : (this.nextAction == Action.RESET_DERIVATIVES ? fieldODEStateAndDerivative : null);
        this.pendingEvent = false;
        this.pendingEventTime = null;
        return fieldODEState;
    }
}

