/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.events;

import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum Transformer {
    UNINITIALIZED{

        protected double transformed(double d) {
            return 0.0;
        }
    }
    ,
    PLUS{

        protected double transformed(double d) {
            return d;
        }
    }
    ,
    MINUS{

        protected double transformed(double d) {
            return -d;
        }
    }
    ,
    MIN{

        protected double transformed(double d) {
            return FastMath.min(-Precision.SAFE_MIN, FastMath.min(-d, d));
        }
    }
    ,
    MAX{

        protected double transformed(double d) {
            return FastMath.max(Precision.SAFE_MIN, FastMath.max(-d, d));
        }
    };


    protected abstract double transformed(double var1);
}

