/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.linear.Array2DRowFieldMatrix;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.ode.FieldExpandableODE;
import org.apache.commons.math3.ode.FieldODEState;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.ode.nonstiff.AdamsFieldIntegrator;
import org.apache.commons.math3.ode.nonstiff.AdamsFieldStepInterpolator;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdamsBashforthFieldIntegrator<T extends RealFieldElement<T>>
extends AdamsFieldIntegrator<T> {
    private static final String METHOD_NAME = "Adams-Bashforth";

    public AdamsBashforthFieldIntegrator(Field<T> field, int n, double d, double d2, double d3, double d4) {
        super(field, METHOD_NAME, n, n, d, d2, d3, d4);
    }

    public AdamsBashforthFieldIntegrator(Field<T> field, int n, double d, double d2, double[] dArray, double[] dArray2) {
        super(field, METHOD_NAME, n, n, d, d2, dArray, dArray2);
    }

    private T errorEstimation(T[] TArray, T[] TArray2, T[] TArray3, FieldMatrix<T> fieldMatrix) {
        RealFieldElement realFieldElement = (RealFieldElement)this.getField().getZero();
        for (int i = 0; i < this.mainSetDimension; ++i) {
            RealFieldElement realFieldElement2 = (RealFieldElement)TArray2[i].abs();
            RealFieldElement realFieldElement3 = this.vecAbsoluteTolerance == null ? (RealFieldElement)((RealFieldElement)realFieldElement2.multiply(this.scalRelativeTolerance)).add(this.scalAbsoluteTolerance) : (RealFieldElement)((RealFieldElement)realFieldElement2.multiply(this.vecRelativeTolerance[i])).add(this.vecAbsoluteTolerance[i]);
            RealFieldElement realFieldElement4 = (RealFieldElement)this.getField().getZero();
            int n = fieldMatrix.getRowDimension() % 2 == 0 ? -1 : 1;
            for (int j = fieldMatrix.getRowDimension() - 1; j >= 0; --j) {
                realFieldElement4 = (RealFieldElement)realFieldElement4.add(((RealFieldElement)fieldMatrix.getEntry(j, i)).multiply(n));
                n = -n;
            }
            realFieldElement4 = (RealFieldElement)realFieldElement4.subtract(TArray3[i]);
            RealFieldElement realFieldElement5 = ((RealFieldElement)TArray2[i].subtract(TArray[i])).add(realFieldElement4).divide(realFieldElement3);
            realFieldElement = realFieldElement.add(realFieldElement5.multiply(realFieldElement5));
        }
        return (T)((RealFieldElement)((RealFieldElement)realFieldElement.divide(this.mainSetDimension)).sqrt());
    }

    @Override
    public FieldODEStateAndDerivative<T> integrate(FieldExpandableODE<T> fieldExpandableODE, FieldODEState<T> fieldODEState, T t) {
        Object object;
        this.sanityChecks(fieldODEState, t);
        T t2 = fieldODEState.getTime();
        RealFieldElement[] realFieldElementArray = fieldExpandableODE.getMapper().mapState(fieldODEState);
        this.setStepStart(this.initIntegration(fieldExpandableODE, (RealFieldElement)t2, realFieldElementArray, (RealFieldElement)t));
        boolean bl = ((RealFieldElement)t.subtract(fieldODEState.getTime())).getReal() > 0.0;
        this.start(fieldExpandableODE, this.getStepStart(), t);
        FieldODEStateAndDerivative fieldODEStateAndDerivative = this.getStepStart();
        FieldODEStateAndDerivative fieldODEStateAndDerivative2 = AdamsFieldStepInterpolator.taylor(fieldODEStateAndDerivative, (RealFieldElement)((RealFieldElement)fieldODEStateAndDerivative.getTime().add(this.getStepSize())), this.getStepSize(), (RealFieldElement[])this.scaled, (Array2DRowFieldMatrix)this.nordsieck);
        this.setIsLastStep(false);
        do {
            boolean bl2;
            Object object2;
            object = null;
            RealFieldElement[] realFieldElementArray2 = (RealFieldElement[])MathArrays.buildArray(this.getField(), realFieldElementArray.length);
            Array2DRowFieldMatrix array2DRowFieldMatrix = null;
            RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)this.getField().getZero()).add(10.0);
            while (((RealFieldElement)realFieldElement.subtract(1.0)).getReal() >= 0.0) {
                object = fieldODEStateAndDerivative2.getState();
                object2 = this.computeDerivatives((RealFieldElement)fieldODEStateAndDerivative2.getTime(), (RealFieldElement[])object);
                for (int i = 0; i < realFieldElementArray2.length; ++i) {
                    realFieldElementArray2[i] = this.getStepSize().multiply((RealFieldElement)object2[i]);
                }
                array2DRowFieldMatrix = this.updateHighOrderDerivativesPhase1(this.nordsieck);
                this.updateHighOrderDerivativesPhase2(this.scaled, realFieldElementArray2, array2DRowFieldMatrix);
                realFieldElement = this.errorEstimation(realFieldElementArray, (RealFieldElement[])object, realFieldElementArray2, array2DRowFieldMatrix);
                if (!(((RealFieldElement)realFieldElement.subtract(1.0)).getReal() >= 0.0)) continue;
                RealFieldElement realFieldElement2 = this.computeStepGrowShrinkFactor(realFieldElement);
                this.rescale(this.filterStep(this.getStepSize().multiply((RealFieldElement)realFieldElement2), bl, false));
                fieldODEStateAndDerivative2 = AdamsFieldStepInterpolator.taylor(this.getStepStart(), (RealFieldElement)((RealFieldElement)this.getStepStart().getTime().add(this.getStepSize())), this.getStepSize(), (RealFieldElement[])this.scaled, (Array2DRowFieldMatrix)this.nordsieck);
            }
            this.setStepStart(this.acceptStep(new AdamsFieldStepInterpolator(this.getStepSize(), fieldODEStateAndDerivative2, realFieldElementArray2, array2DRowFieldMatrix, bl, this.getStepStart(), fieldODEStateAndDerivative2, fieldExpandableODE.getMapper()), t));
            this.scaled = realFieldElementArray2;
            this.nordsieck = array2DRowFieldMatrix;
            if (this.isLastStep()) continue;
            System.arraycopy(object, 0, realFieldElementArray, 0, realFieldElementArray.length);
            if (this.resetOccurred()) {
                this.start(fieldExpandableODE, this.getStepStart(), t);
            }
            object2 = this.computeStepGrowShrinkFactor(realFieldElement);
            RealFieldElement realFieldElement3 = (RealFieldElement)this.getStepSize().multiply((RealFieldElement[])object2);
            RealFieldElement realFieldElement4 = this.getStepStart().getTime().add((RealFieldElement)realFieldElement3);
            boolean bl3 = bl ? ((RealFieldElement)realFieldElement4.subtract(t)).getReal() >= 0.0 : ((RealFieldElement)realFieldElement4.subtract(t)).getReal() <= 0.0;
            RealFieldElement realFieldElement5 = this.filterStep(realFieldElement3, bl, bl3);
            RealFieldElement realFieldElement6 = this.getStepStart().getTime().add((RealFieldElement)realFieldElement5);
            boolean bl4 = bl ? ((RealFieldElement)realFieldElement6.subtract(t)).getReal() >= 0.0 : (bl2 = ((RealFieldElement)realFieldElement6.subtract(t)).getReal() <= 0.0);
            if (bl2) {
                realFieldElement5 = (RealFieldElement)t.subtract(this.getStepStart().getTime());
            }
            this.rescale(realFieldElement5);
            fieldODEStateAndDerivative2 = AdamsFieldStepInterpolator.taylor(this.getStepStart(), (RealFieldElement)((RealFieldElement)this.getStepStart().getTime().add(this.getStepSize())), this.getStepSize(), (RealFieldElement[])this.scaled, (Array2DRowFieldMatrix)this.nordsieck);
        } while (!this.isLastStep());
        object = this.getStepStart();
        this.setStepStart(null);
        this.setStepSize(null);
        return object;
    }
}

