/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.linear.Array2DRowFieldMatrix;
import org.apache.commons.math3.linear.ArrayFieldVector;
import org.apache.commons.math3.linear.FieldDecompositionSolver;
import org.apache.commons.math3.linear.FieldLUDecomposition;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdamsNordsieckFieldTransformer<T extends RealFieldElement<T>> {
    private static final Map<Integer, Map<Field<? extends RealFieldElement<?>>, AdamsNordsieckFieldTransformer<? extends RealFieldElement<?>>>> CACHE = new HashMap();
    private final Field<T> field;
    private final Array2DRowFieldMatrix<T> update;
    private final T[] c1;

    private AdamsNordsieckFieldTransformer(Field<T> field, int n) {
        this.field = field;
        int n2 = n - 1;
        FieldMatrix<T> fieldMatrix = this.buildP(n2);
        FieldDecompositionSolver<T> fieldDecompositionSolver = new FieldLUDecomposition<T>(fieldMatrix).getSolver();
        Object[] objectArray = (RealFieldElement[])MathArrays.buildArray(field, n2);
        Arrays.fill(objectArray, field.getOne());
        this.c1 = (RealFieldElement[])fieldDecompositionSolver.solve(new ArrayFieldVector((FieldElement[])objectArray, false)).toArray();
        FieldElement[][] fieldElementArray = (RealFieldElement[][])fieldMatrix.getData();
        for (int i = fieldElementArray.length - 1; i > 0; --i) {
            fieldElementArray[i] = fieldElementArray[i - 1];
        }
        fieldElementArray[0] = (RealFieldElement[])MathArrays.buildArray(field, n2);
        Arrays.fill(fieldElementArray[0], field.getZero());
        this.update = new Array2DRowFieldMatrix(fieldDecompositionSolver.solve(new Array2DRowFieldMatrix(fieldElementArray, false)).getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends RealFieldElement<T>> AdamsNordsieckFieldTransformer<T> getInstance(Field<T> field, int n) {
        Map<Integer, Map<Field<? extends RealFieldElement<?>>, AdamsNordsieckFieldTransformer<? extends RealFieldElement<?>>>> map = CACHE;
        synchronized (map) {
            AdamsNordsieckFieldTransformer<RealFieldElement<Object>> adamsNordsieckFieldTransformer;
            Map<Field<RealFieldElement<?>>, AdamsNordsieckFieldTransformer<RealFieldElement<?>>> map2 = CACHE.get(n);
            if (map2 == null) {
                map2 = new HashMap();
                CACHE.put(n, map2);
            }
            if ((adamsNordsieckFieldTransformer = map2.get(field)) == null) {
                adamsNordsieckFieldTransformer = new AdamsNordsieckFieldTransformer<T>(field, n);
                map2.put(field, adamsNordsieckFieldTransformer);
            }
            return adamsNordsieckFieldTransformer;
        }
    }

    private FieldMatrix<T> buildP(int n) {
        FieldElement[][] fieldElementArray = (RealFieldElement[][])MathArrays.buildArray(this.field, n, n);
        for (int i = 1; i <= fieldElementArray.length; ++i) {
            RealFieldElement[] realFieldElementArray = fieldElementArray[i - 1];
            int n2 = -i;
            RealFieldElement realFieldElement = (RealFieldElement)((RealFieldElement)this.field.getZero()).add(n2);
            for (int j = 1; j <= realFieldElementArray.length; ++j) {
                realFieldElementArray[j - 1] = (RealFieldElement)realFieldElement.multiply(j + 1);
                realFieldElement = (RealFieldElement)realFieldElement.multiply(n2);
            }
        }
        return new Array2DRowFieldMatrix(fieldElementArray, false);
    }

    public Array2DRowFieldMatrix<T> initializeHighOrderDerivatives(T t, T[] TArray, T[][] TArray2, T[][] TArray3) {
        Object object;
        Object object2;
        FieldElement[][] fieldElementArray = (RealFieldElement[][])MathArrays.buildArray(this.field, this.c1.length + 1, this.c1.length + 1);
        FieldElement[][] fieldElementArray2 = (RealFieldElement[][])MathArrays.buildArray(this.field, this.c1.length + 1, TArray2[0].length);
        T[] TArray4 = TArray2[0];
        T[] TArray5 = TArray3[0];
        for (int i = 1; i < TArray2.length; ++i) {
            object2 = (RealFieldElement)TArray[i].subtract(TArray[0]);
            object = (RealFieldElement)object2.divide(t);
            RealFieldElement realFieldElement = (RealFieldElement)t.reciprocal();
            FieldElement[] fieldElementArray3 = fieldElementArray[2 * i - 2];
            FieldElement[] fieldElementArray4 = 2 * i - 1 < fieldElementArray.length ? fieldElementArray[2 * i - 1] : null;
            for (int j = 0; j < fieldElementArray3.length; ++j) {
                realFieldElement = (RealFieldElement)realFieldElement.multiply(object);
                fieldElementArray3[j] = object2.multiply(realFieldElement);
                if (fieldElementArray4 == null) continue;
                fieldElementArray4[j] = (RealFieldElement)realFieldElement.multiply(j + 2);
            }
            T[] TArray6 = TArray2[i];
            T[] TArray7 = TArray3[i];
            FieldElement[] fieldElementArray5 = fieldElementArray2[2 * i - 2];
            FieldElement[] fieldElementArray6 = 2 * i - 1 < fieldElementArray2.length ? fieldElementArray2[2 * i - 1] : null;
            for (int j = 0; j < TArray6.length; ++j) {
                fieldElementArray5[j] = (RealFieldElement)((RealFieldElement)TArray6[j].subtract(TArray4[j])).subtract(object2.multiply(TArray5[j]));
                if (fieldElementArray6 == null) continue;
                fieldElementArray6[j] = (RealFieldElement)TArray7[j].subtract(TArray5[j]);
            }
        }
        FieldLUDecomposition fieldLUDecomposition = new FieldLUDecomposition(new Array2DRowFieldMatrix(fieldElementArray, false));
        object2 = fieldLUDecomposition.getSolver().solve(new Array2DRowFieldMatrix(fieldElementArray2, false));
        object = new Array2DRowFieldMatrix<T>(this.field, object2.getRowDimension() - 1, object2.getColumnDimension());
        for (int i = 0; i < ((Array2DRowFieldMatrix)object).getRowDimension(); ++i) {
            for (int j = 0; j < ((Array2DRowFieldMatrix)object).getColumnDimension(); ++j) {
                ((Array2DRowFieldMatrix)object).setEntry(i, j, object2.getEntry(i, j));
            }
        }
        return object;
    }

    public Array2DRowFieldMatrix<T> updateHighOrderDerivativesPhase1(Array2DRowFieldMatrix<T> array2DRowFieldMatrix) {
        return this.update.multiply(array2DRowFieldMatrix);
    }

    public void updateHighOrderDerivativesPhase2(T[] TArray, T[] TArray2, Array2DRowFieldMatrix<T> array2DRowFieldMatrix) {
        RealFieldElement[][] realFieldElementArray = (RealFieldElement[][])array2DRowFieldMatrix.getDataRef();
        for (int i = 0; i < realFieldElementArray.length; ++i) {
            RealFieldElement[] realFieldElementArray2 = realFieldElementArray[i];
            T t = this.c1[i];
            for (int j = 0; j < realFieldElementArray2.length; ++j) {
                realFieldElementArray2[j] = (RealFieldElement)realFieldElementArray2[j].add(t.multiply(TArray[j].subtract(TArray2[j])));
            }
        }
    }
}

