/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.fraction.BigFraction;
import org.apache.commons.math3.linear.Array2DRowFieldMatrix;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayFieldVector;
import org.apache.commons.math3.linear.FieldDecompositionSolver;
import org.apache.commons.math3.linear.FieldLUDecomposition;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdamsNordsieckTransformer {
    private static final Map<Integer, AdamsNordsieckTransformer> CACHE = new HashMap<Integer, AdamsNordsieckTransformer>();
    private final Array2DRowRealMatrix update;
    private final double[] c1;

    private AdamsNordsieckTransformer(int n) {
        int n2 = n - 1;
        FieldMatrix<BigFraction> fieldMatrix = this.buildP(n2);
        FieldDecompositionSolver<BigFraction> fieldDecompositionSolver = new FieldLUDecomposition<BigFraction>(fieldMatrix).getSolver();
        Object[] objectArray = new BigFraction[n2];
        Arrays.fill(objectArray, BigFraction.ONE);
        BigFraction[] bigFractionArray = (BigFraction[])fieldDecompositionSolver.solve(new ArrayFieldVector((FieldElement[])objectArray, false)).toArray();
        FieldElement[][] fieldElementArray = (BigFraction[][])fieldMatrix.getData();
        for (int i = fieldElementArray.length - 1; i > 0; --i) {
            fieldElementArray[i] = fieldElementArray[i - 1];
        }
        fieldElementArray[0] = new BigFraction[n2];
        Arrays.fill(fieldElementArray[0], BigFraction.ZERO);
        FieldMatrix<BigFraction> fieldMatrix2 = fieldDecompositionSolver.solve(new Array2DRowFieldMatrix(fieldElementArray, false));
        this.update = MatrixUtils.bigFractionMatrixToRealMatrix(fieldMatrix2);
        this.c1 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            this.c1[i] = bigFractionArray[i].doubleValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdamsNordsieckTransformer getInstance(int n) {
        Map<Integer, AdamsNordsieckTransformer> map = CACHE;
        synchronized (map) {
            AdamsNordsieckTransformer adamsNordsieckTransformer = CACHE.get(n);
            if (adamsNordsieckTransformer == null) {
                adamsNordsieckTransformer = new AdamsNordsieckTransformer(n);
                CACHE.put(n, adamsNordsieckTransformer);
            }
            return adamsNordsieckTransformer;
        }
    }

    @Deprecated
    public int getNSteps() {
        return this.c1.length;
    }

    private FieldMatrix<BigFraction> buildP(int n) {
        FieldElement[][] fieldElementArray = new BigFraction[n][n];
        for (int i = 1; i <= fieldElementArray.length; ++i) {
            int n2;
            BigFraction[] bigFractionArray = fieldElementArray[i - 1];
            int n3 = n2 = -i;
            for (int j = 1; j <= bigFractionArray.length; ++j) {
                bigFractionArray[j - 1] = new BigFraction(n3 * (j + 1));
                n3 *= n2;
            }
        }
        return new Array2DRowFieldMatrix(fieldElementArray, false);
    }

    public Array2DRowRealMatrix initializeHighOrderDerivatives(double d, double[] dArray, double[][] dArray2, double[][] dArray3) {
        double[][] dArray4 = new double[this.c1.length + 1][this.c1.length + 1];
        double[][] dArray5 = new double[this.c1.length + 1][dArray2[0].length];
        double[] dArray6 = dArray2[0];
        double[] dArray7 = dArray3[0];
        for (int i = 1; i < dArray2.length; ++i) {
            double d2 = dArray[i] - dArray[0];
            double d3 = d2 / d;
            double d4 = 1.0 / d;
            double[] dArray8 = dArray4[2 * i - 2];
            double[] dArray9 = 2 * i - 1 < dArray4.length ? dArray4[2 * i - 1] : null;
            for (int j = 0; j < dArray8.length; ++j) {
                dArray8[j] = d2 * (d4 *= d3);
                if (dArray9 == null) continue;
                dArray9[j] = (double)(j + 2) * d4;
            }
            double[] dArray10 = dArray2[i];
            double[] dArray11 = dArray3[i];
            double[] dArray12 = dArray5[2 * i - 2];
            double[] dArray13 = 2 * i - 1 < dArray5.length ? dArray5[2 * i - 1] : null;
            for (int j = 0; j < dArray10.length; ++j) {
                dArray12[j] = dArray10[j] - dArray6[j] - d2 * dArray7[j];
                if (dArray13 == null) continue;
                dArray13[j] = dArray11[j] - dArray7[j];
            }
        }
        QRDecomposition qRDecomposition = new QRDecomposition(new Array2DRowRealMatrix(dArray4, false));
        RealMatrix realMatrix = qRDecomposition.getSolver().solve(new Array2DRowRealMatrix(dArray5, false));
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(realMatrix.getRowDimension() - 1, realMatrix.getColumnDimension());
        for (int i = 0; i < array2DRowRealMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < array2DRowRealMatrix.getColumnDimension(); ++j) {
                array2DRowRealMatrix.setEntry(i, j, realMatrix.getEntry(i, j));
            }
        }
        return array2DRowRealMatrix;
    }

    public Array2DRowRealMatrix updateHighOrderDerivativesPhase1(Array2DRowRealMatrix array2DRowRealMatrix) {
        return this.update.multiply(array2DRowRealMatrix);
    }

    public void updateHighOrderDerivativesPhase2(double[] dArray, double[] dArray2, Array2DRowRealMatrix array2DRowRealMatrix) {
        double[][] dArray3 = array2DRowRealMatrix.getDataRef();
        for (int i = 0; i < dArray3.length; ++i) {
            double[] dArray4 = dArray3[i];
            double d = this.c1[i];
            for (int j = 0; j < dArray4.length; ++j) {
                int n = j;
                dArray4[n] = dArray4[n] + d * (dArray[j] - dArray2[j]);
            }
        }
    }
}

