/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.ode.AbstractFieldIntegrator;
import org.apache.commons.math3.ode.FieldEquationsMapper;
import org.apache.commons.math3.ode.FieldODEState;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AdaptiveStepsizeFieldIntegrator<T extends RealFieldElement<T>>
extends AbstractFieldIntegrator<T> {
    protected double scalAbsoluteTolerance;
    protected double scalRelativeTolerance;
    protected double[] vecAbsoluteTolerance;
    protected double[] vecRelativeTolerance;
    protected int mainSetDimension;
    private T initialStep;
    private T minStep;
    private T maxStep;

    public AdaptiveStepsizeFieldIntegrator(Field<T> field, String string, double d, double d2, double d3, double d4) {
        super(field, string);
        this.setStepSizeControl(d, d2, d3, d4);
        this.resetInternalState();
    }

    public AdaptiveStepsizeFieldIntegrator(Field<T> field, String string, double d, double d2, double[] dArray, double[] dArray2) {
        super(field, string);
        this.setStepSizeControl(d, d2, dArray, dArray2);
        this.resetInternalState();
    }

    public void setStepSizeControl(double d, double d2, double d3, double d4) {
        this.minStep = (RealFieldElement)((RealFieldElement)this.getField().getZero()).add(FastMath.abs(d));
        this.maxStep = (RealFieldElement)((RealFieldElement)this.getField().getZero()).add(FastMath.abs(d2));
        this.initialStep = (RealFieldElement)((RealFieldElement)this.getField().getOne()).negate();
        this.scalAbsoluteTolerance = d3;
        this.scalRelativeTolerance = d4;
        this.vecAbsoluteTolerance = null;
        this.vecRelativeTolerance = null;
    }

    public void setStepSizeControl(double d, double d2, double[] dArray, double[] dArray2) {
        this.minStep = (RealFieldElement)((RealFieldElement)this.getField().getZero()).add(FastMath.abs(d));
        this.maxStep = (RealFieldElement)((RealFieldElement)this.getField().getZero()).add(FastMath.abs(d2));
        this.initialStep = (RealFieldElement)((RealFieldElement)this.getField().getOne()).negate();
        this.scalAbsoluteTolerance = 0.0;
        this.scalRelativeTolerance = 0.0;
        this.vecAbsoluteTolerance = (double[])dArray.clone();
        this.vecRelativeTolerance = (double[])dArray2.clone();
    }

    public void setInitialStepSize(T t) {
        this.initialStep = ((RealFieldElement)t.subtract(this.minStep)).getReal() < 0.0 || ((RealFieldElement)t.subtract(this.maxStep)).getReal() > 0.0 ? (RealFieldElement)((RealFieldElement)this.getField().getOne()).negate() : t;
    }

    @Override
    protected void sanityChecks(FieldODEState<T> fieldODEState, T t) {
        super.sanityChecks(fieldODEState, t);
        this.mainSetDimension = fieldODEState.getStateDimension();
        if (this.vecAbsoluteTolerance != null && this.vecAbsoluteTolerance.length != this.mainSetDimension) {
            throw new DimensionMismatchException(this.mainSetDimension, this.vecAbsoluteTolerance.length);
        }
        if (this.vecRelativeTolerance != null && this.vecRelativeTolerance.length != this.mainSetDimension) {
            throw new DimensionMismatchException(this.mainSetDimension, this.vecRelativeTolerance.length);
        }
    }

    public T initializeStep(boolean bl, int n, T[] TArray, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative, FieldEquationsMapper<T> fieldEquationsMapper) {
        RealFieldElement realFieldElement;
        RealFieldElement realFieldElement2;
        RealFieldElement[] realFieldElementArray;
        if (this.initialStep.getReal() > 0.0) {
            return (T)(bl ? this.initialStep : (RealFieldElement)this.initialStep.negate());
        }
        RealFieldElement[] realFieldElementArray2 = fieldEquationsMapper.mapState(fieldODEStateAndDerivative);
        RealFieldElement[] realFieldElementArray3 = fieldEquationsMapper.mapDerivative(fieldODEStateAndDerivative);
        RealFieldElement realFieldElement3 = (RealFieldElement)this.getField().getZero();
        RealFieldElement realFieldElement4 = (RealFieldElement)this.getField().getZero();
        for (int i = 0; i < TArray.length; ++i) {
            realFieldElementArray = (RealFieldElement[])realFieldElementArray2[i].divide(TArray[i]);
            realFieldElement3 = realFieldElement3.add(realFieldElementArray.multiply(realFieldElementArray));
            RealFieldElement realFieldElement5 = (RealFieldElement)realFieldElementArray3[i].divide(TArray[i]);
            realFieldElement4 = realFieldElement4.add(realFieldElement5.multiply(realFieldElement5));
        }
        RealFieldElement realFieldElement6 = realFieldElement2 = realFieldElement3.getReal() < 1.0E-10 || realFieldElement4.getReal() < 1.0E-10 ? (RealFieldElement)((RealFieldElement)this.getField().getZero()).add(1.0E-6) : (RealFieldElement)((RealFieldElement)realFieldElement3.divide(realFieldElement4).sqrt()).multiply(0.01);
        if (!bl) {
            realFieldElement2 = (RealFieldElement)realFieldElement2.negate();
        }
        realFieldElementArray = (RealFieldElement[])MathArrays.buildArray(this.getField(), realFieldElementArray2.length);
        for (int i = 0; i < realFieldElementArray2.length; ++i) {
            realFieldElementArray[i] = realFieldElementArray2[i].add(realFieldElementArray3[i].multiply(realFieldElement2));
        }
        RealFieldElement[] realFieldElementArray4 = this.computeDerivatives(fieldODEStateAndDerivative.getTime().add((RealFieldElement)realFieldElement2), realFieldElementArray);
        RealFieldElement realFieldElement7 = (RealFieldElement)this.getField().getZero();
        for (int i = 0; i < TArray.length; ++i) {
            realFieldElement = (RealFieldElement)realFieldElementArray4[i].subtract(realFieldElementArray3[i]).divide(TArray[i]);
            realFieldElement7 = realFieldElement7.add(realFieldElement.multiply(realFieldElement));
        }
        realFieldElement7 = ((RealFieldElement)realFieldElement7.sqrt()).divide(realFieldElement2);
        RealFieldElement realFieldElement8 = MathUtils.max((RealFieldElement)realFieldElement4.sqrt(), realFieldElement7);
        realFieldElement = realFieldElement8.getReal() < 1.0E-15 ? MathUtils.max((RealFieldElement)((RealFieldElement)this.getField().getZero()).add(1.0E-6), (RealFieldElement)((RealFieldElement)realFieldElement2.abs()).multiply(0.001)) : (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElement8.multiply(100)).reciprocal()).pow(1.0 / (double)n);
        realFieldElement2 = MathUtils.min((RealFieldElement)((RealFieldElement)realFieldElement2.abs()).multiply(100), realFieldElement);
        realFieldElement2 = MathUtils.max(realFieldElement2, (RealFieldElement)((RealFieldElement)fieldODEStateAndDerivative.getTime().abs()).multiply(1.0E-12));
        realFieldElement2 = MathUtils.max(this.minStep, MathUtils.min(this.maxStep, realFieldElement2));
        if (!bl) {
            realFieldElement2 = (RealFieldElement)realFieldElement2.negate();
        }
        return (T)realFieldElement2;
    }

    protected T filterStep(T t, boolean bl, boolean bl2) {
        Object object = t;
        if (((RealFieldElement)((RealFieldElement)t.abs()).subtract(this.minStep)).getReal() < 0.0) {
            if (bl2) {
                object = bl ? this.minStep : (RealFieldElement)this.minStep.negate();
            } else {
                throw new NumberIsTooSmallException((Localizable)LocalizedFormats.MINIMAL_STEPSIZE_REACHED_DURING_INTEGRATION, (Number)((RealFieldElement)t.abs()).getReal(), this.minStep.getReal(), true);
            }
        }
        if (((RealFieldElement)object.subtract(this.maxStep)).getReal() > 0.0) {
            object = this.maxStep;
        } else if (((RealFieldElement)object.add(this.maxStep)).getReal() < 0.0) {
            object = (RealFieldElement)this.maxStep.negate();
        }
        return object;
    }

    protected void resetInternalState() {
        this.setStepStart(null);
        this.setStepSize((RealFieldElement)((RealFieldElement)this.minStep.multiply(this.maxStep)).sqrt());
    }

    public T getMinStep() {
        return this.minStep;
    }

    public T getMaxStep() {
        return this.maxStep;
    }
}

