/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.ode.FieldEquationsMapper;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.ode.nonstiff.DormandPrince54FieldStepInterpolator;
import org.apache.commons.math3.ode.nonstiff.EmbeddedRungeKuttaFieldIntegrator;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DormandPrince54FieldIntegrator<T extends RealFieldElement<T>>
extends EmbeddedRungeKuttaFieldIntegrator<T> {
    private static final String METHOD_NAME = "Dormand-Prince 5(4)";
    private final T e1 = this.fraction(71, 57600);
    private final T e3 = this.fraction(-71, 16695);
    private final T e4 = this.fraction(71, 1920);
    private final T e5 = this.fraction(-17253, 339200);
    private final T e6 = this.fraction(22, 525);
    private final T e7 = this.fraction(-1, 40);

    public DormandPrince54FieldIntegrator(Field<T> field, double d, double d2, double d3, double d4) {
        super(field, METHOD_NAME, 6, d, d2, d3, d4);
    }

    public DormandPrince54FieldIntegrator(Field<T> field, double d, double d2, double[] dArray, double[] dArray2) {
        super(field, METHOD_NAME, 6, d, d2, dArray, dArray2);
    }

    @Override
    public T[] getC() {
        RealFieldElement[] realFieldElementArray = (RealFieldElement[])MathArrays.buildArray(this.getField(), 6);
        realFieldElementArray[0] = this.fraction(1, 5);
        realFieldElementArray[1] = this.fraction(3, 10);
        realFieldElementArray[2] = this.fraction(4, 5);
        realFieldElementArray[3] = this.fraction(8, 9);
        realFieldElementArray[4] = (RealFieldElement)this.getField().getOne();
        realFieldElementArray[5] = (RealFieldElement)this.getField().getOne();
        return realFieldElementArray;
    }

    @Override
    public T[][] getA() {
        RealFieldElement[][] realFieldElementArray = (RealFieldElement[][])MathArrays.buildArray(this.getField(), 6, -1);
        for (int i = 0; i < realFieldElementArray.length; ++i) {
            realFieldElementArray[i] = (RealFieldElement[])MathArrays.buildArray(this.getField(), i + 1);
        }
        realFieldElementArray[0][0] = this.fraction(1, 5);
        realFieldElementArray[1][0] = this.fraction(3, 40);
        realFieldElementArray[1][1] = this.fraction(9, 40);
        realFieldElementArray[2][0] = this.fraction(44, 45);
        realFieldElementArray[2][1] = this.fraction(-56, 15);
        realFieldElementArray[2][2] = this.fraction(32, 9);
        realFieldElementArray[3][0] = this.fraction(19372, 6561);
        realFieldElementArray[3][1] = this.fraction(-25360, 2187);
        realFieldElementArray[3][2] = this.fraction(64448, 6561);
        realFieldElementArray[3][3] = this.fraction(-212, 729);
        realFieldElementArray[4][0] = this.fraction(9017, 3168);
        realFieldElementArray[4][1] = this.fraction(-355, 33);
        realFieldElementArray[4][2] = this.fraction(46732, 5247);
        realFieldElementArray[4][3] = this.fraction(49, 176);
        realFieldElementArray[4][4] = this.fraction(-5103, 18656);
        realFieldElementArray[5][0] = this.fraction(35, 384);
        realFieldElementArray[5][1] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[5][2] = this.fraction(500, 1113);
        realFieldElementArray[5][3] = this.fraction(125, 192);
        realFieldElementArray[5][4] = this.fraction(-2187, 6784);
        realFieldElementArray[5][5] = this.fraction(11, 84);
        return realFieldElementArray;
    }

    @Override
    public T[] getB() {
        RealFieldElement[] realFieldElementArray = (RealFieldElement[])MathArrays.buildArray(this.getField(), 7);
        realFieldElementArray[0] = this.fraction(35, 384);
        realFieldElementArray[1] = (RealFieldElement)this.getField().getZero();
        realFieldElementArray[2] = this.fraction(500, 1113);
        realFieldElementArray[3] = this.fraction(125, 192);
        realFieldElementArray[4] = this.fraction(-2187, 6784);
        realFieldElementArray[5] = this.fraction(11, 84);
        realFieldElementArray[6] = (RealFieldElement)this.getField().getZero();
        return realFieldElementArray;
    }

    @Override
    protected DormandPrince54FieldStepInterpolator<T> createInterpolator(boolean bl, T[][] TArray, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative2, FieldEquationsMapper<T> fieldEquationsMapper) {
        return new DormandPrince54FieldStepInterpolator(this.getField(), bl, TArray, fieldODEStateAndDerivative, fieldODEStateAndDerivative2, fieldODEStateAndDerivative, fieldODEStateAndDerivative2, fieldEquationsMapper);
    }

    @Override
    public int getOrder() {
        return 5;
    }

    @Override
    protected T estimateError(T[][] TArray, T[] TArray2, T[] TArray3, T realFieldElement) {
        RealFieldElement realFieldElement2 = (RealFieldElement)this.getField().getZero();
        for (int i = 0; i < this.mainSetDimension; ++i) {
            RealFieldElement realFieldElement3 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)TArray[0][i].multiply(this.e1)).add(TArray[2][i].multiply(this.e3))).add(TArray[3][i].multiply(this.e4))).add(TArray[4][i].multiply(this.e5))).add(TArray[5][i].multiply(this.e6))).add(TArray[6][i].multiply(this.e7));
            RealFieldElement realFieldElement4 = MathUtils.max((RealFieldElement)TArray2[i].abs(), (RealFieldElement)TArray3[i].abs());
            RealFieldElement realFieldElement5 = this.vecAbsoluteTolerance == null ? (RealFieldElement)((RealFieldElement)realFieldElement4.multiply(this.scalRelativeTolerance)).add(this.scalAbsoluteTolerance) : (RealFieldElement)((RealFieldElement)realFieldElement4.multiply(this.vecRelativeTolerance[i])).add(this.vecAbsoluteTolerance[i]);
            RealFieldElement realFieldElement6 = realFieldElement.multiply((RealFieldElement)realFieldElement3).divide(realFieldElement5);
            realFieldElement2 = realFieldElement2.add(realFieldElement6.multiply(realFieldElement6));
        }
        return (T)((RealFieldElement)((RealFieldElement)realFieldElement2.divide(this.mainSetDimension)).sqrt());
    }
}

