/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.ode.AbstractIntegrator;
import org.apache.commons.math3.ode.EquationsMapper;
import org.apache.commons.math3.ode.nonstiff.RungeKuttaStepInterpolator;
import org.apache.commons.math3.ode.sampling.StepInterpolator;

class DormandPrince54StepInterpolator
extends RungeKuttaStepInterpolator {
    private static final double A70 = 0.09114583333333333;
    private static final double A72 = 0.44923629829290207;
    private static final double A73 = 0.6510416666666666;
    private static final double A74 = -0.322376179245283;
    private static final double A75 = 0.13095238095238096;
    private static final double D0 = -1.1270175653862835;
    private static final double D2 = 2.675424484351598;
    private static final double D3 = -5.685526961588504;
    private static final double D4 = 3.5219323679207912;
    private static final double D5 = -1.7672812570757455;
    private static final double D6 = 2.382468931778144;
    private static final long serialVersionUID = 20111120L;
    private double[] v1;
    private double[] v2;
    private double[] v3;
    private double[] v4;
    private boolean vectorsInitialized;

    public DormandPrince54StepInterpolator() {
        this.v1 = null;
        this.v2 = null;
        this.v3 = null;
        this.v4 = null;
        this.vectorsInitialized = false;
    }

    DormandPrince54StepInterpolator(DormandPrince54StepInterpolator dormandPrince54StepInterpolator) {
        super(dormandPrince54StepInterpolator);
        if (dormandPrince54StepInterpolator.v1 == null) {
            this.v1 = null;
            this.v2 = null;
            this.v3 = null;
            this.v4 = null;
            this.vectorsInitialized = false;
        } else {
            this.v1 = (double[])dormandPrince54StepInterpolator.v1.clone();
            this.v2 = (double[])dormandPrince54StepInterpolator.v2.clone();
            this.v3 = (double[])dormandPrince54StepInterpolator.v3.clone();
            this.v4 = (double[])dormandPrince54StepInterpolator.v4.clone();
            this.vectorsInitialized = dormandPrince54StepInterpolator.vectorsInitialized;
        }
    }

    protected StepInterpolator doCopy() {
        return new DormandPrince54StepInterpolator(this);
    }

    public void reinitialize(AbstractIntegrator abstractIntegrator, double[] dArray, double[][] dArray2, boolean bl, EquationsMapper equationsMapper, EquationsMapper[] equationsMapperArray) {
        super.reinitialize(abstractIntegrator, dArray, dArray2, bl, equationsMapper, equationsMapperArray);
        this.v1 = null;
        this.v2 = null;
        this.v3 = null;
        this.v4 = null;
        this.vectorsInitialized = false;
    }

    public void storeTime(double d) {
        super.storeTime(d);
        this.vectorsInitialized = false;
    }

    protected void computeInterpolatedStateAndDerivatives(double d, double d2) {
        if (!this.vectorsInitialized) {
            if (this.v1 == null) {
                this.v1 = new double[this.interpolatedState.length];
                this.v2 = new double[this.interpolatedState.length];
                this.v3 = new double[this.interpolatedState.length];
                this.v4 = new double[this.interpolatedState.length];
            }
            for (int i = 0; i < this.interpolatedState.length; ++i) {
                double d3 = this.yDotK[0][i];
                double d4 = this.yDotK[2][i];
                double d5 = this.yDotK[3][i];
                double d6 = this.yDotK[4][i];
                double d7 = this.yDotK[5][i];
                double d8 = this.yDotK[6][i];
                this.v1[i] = 0.09114583333333333 * d3 + 0.44923629829290207 * d4 + 0.6510416666666666 * d5 + -0.322376179245283 * d6 + 0.13095238095238096 * d7;
                this.v2[i] = d3 - this.v1[i];
                this.v3[i] = this.v1[i] - this.v2[i] - d8;
                this.v4[i] = -1.1270175653862835 * d3 + 2.675424484351598 * d4 + -5.685526961588504 * d5 + 3.5219323679207912 * d6 + -1.7672812570757455 * d7 + 2.382468931778144 * d8;
            }
            this.vectorsInitialized = true;
        }
        double d9 = 1.0 - d;
        double d10 = 2.0 * d;
        double d11 = 1.0 - d10;
        double d12 = d * (2.0 - 3.0 * d);
        double d13 = d10 * (1.0 + d * (d10 - 3.0));
        if (this.previousState != null && d <= 0.5) {
            for (int i = 0; i < this.interpolatedState.length; ++i) {
                this.interpolatedState[i] = this.previousState[i] + d * this.h * (this.v1[i] + d9 * (this.v2[i] + d * (this.v3[i] + d9 * this.v4[i])));
                this.interpolatedDerivatives[i] = this.v1[i] + d11 * this.v2[i] + d12 * this.v3[i] + d13 * this.v4[i];
            }
        } else {
            for (int i = 0; i < this.interpolatedState.length; ++i) {
                this.interpolatedState[i] = this.currentState[i] - d2 * (this.v1[i] - d * (this.v2[i] + d * (this.v3[i] + d9 * this.v4[i])));
                this.interpolatedDerivatives[i] = this.v1[i] + d11 * this.v2[i] + d12 * this.v3[i] + d13 * this.v4[i];
            }
        }
    }
}

