/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.ode.AbstractIntegrator;
import org.apache.commons.math3.ode.EquationsMapper;
import org.apache.commons.math3.ode.nonstiff.RungeKuttaStepInterpolator;
import org.apache.commons.math3.ode.sampling.StepInterpolator;

class DormandPrince853StepInterpolator
extends RungeKuttaStepInterpolator {
    private static final long serialVersionUID = 20111120L;
    private static final double B_01 = 0.054293734116568765;
    private static final double B_06 = 4.450312892752409;
    private static final double B_07 = 1.8915178993145003;
    private static final double B_08 = -5.801203960010585;
    private static final double B_09 = 0.3111643669578199;
    private static final double B_10 = -0.1521609496625161;
    private static final double B_11 = 0.20136540080403034;
    private static final double B_12 = 0.04471061572777259;
    private static final double C14 = 0.1;
    private static final double K14_01 = 0.0018737681664791894;
    private static final double K14_06 = -4.450312892752409;
    private static final double K14_07 = -1.6380176890978755;
    private static final double K14_08 = 5.554964922539782;
    private static final double K14_09 = -0.4353557902216363;
    private static final double K14_10 = 0.30545274794128174;
    private static final double K14_11 = -0.19316434850839564;
    private static final double K14_12 = -0.03714271806722689;
    private static final double K14_13 = -0.008298;
    private static final double C15 = 0.2;
    private static final double K15_01 = -0.022459085953066622;
    private static final double K15_06 = -4.422011983080043;
    private static final double K15_07 = -1.8379759110070617;
    private static final double K15_08 = 5.746280211439194;
    private static final double K15_09 = -0.3111643669578199;
    private static final double K15_10 = 0.1521609496625161;
    private static final double K15_11 = -0.2014737481327276;
    private static final double K15_12 = -0.04432804463693693;
    private static final double K15_13 = -3.4046500868740456E-4;
    private static final double K15_14 = 0.1413124436746325;
    private static final double C16 = 0.7777777777777778;
    private static final double K16_01 = -0.4831900357003607;
    private static final double K16_06 = -9.147934308113573;
    private static final double K16_07 = 5.791903296748099;
    private static final double K16_08 = 9.870193778407696;
    private static final double K16_09 = 0.04556282049746119;
    private static final double K16_10 = 0.1521609496625161;
    private static final double K16_11 = -0.20136540080403034;
    private static final double K16_12 = -0.04471061572777259;
    private static final double K16_13 = -0.0013990241651590145;
    private static final double K16_14 = 2.9475147891527724;
    private static final double K16_15 = -9.15095847217987;
    private static final double[][] D = new double[][]{{-8.428938276109013, 0.5667149535193777, -3.0689499459498917, 2.38466765651207, 2.1170345824450285, -0.871391583777973, 2.2404374302607883, 0.6315787787694688, -0.08899033645133331, 18.148505520854727, -9.194632392478356, -4.436036387594894}, {10.427508642579134, 242.28349177525817, 165.20045171727028, -374.5467547226902, -22.113666853125302, 7.733432668472264, -30.674084731089398, -9.332130526430229, 15.697238121770845, -31.139403219565178, -9.35292435884448, 35.81684148639408}, {19.985053242002433, -387.0373087493518, -189.17813819516758, 527.8081592054236, -11.573902539959631, 6.8812326946963, -1.0006050966910838, 0.7777137798053443, -2.778205752353508, -60.19669523126412, 84.32040550667716, 11.99229113618279}, {-25.69393346270375, -154.18974869023643, -231.5293791760455, 357.6391179106141, 93.4053241836243, -37.45832313645163, 104.0996495089623, 29.8402934266605, -43.53345659001114, 96.32455395918828, -39.17726167561544, -149.72683625798564}};
    private double[][] yDotKLast;
    private double[][] v;
    private boolean vectorsInitialized;

    public DormandPrince853StepInterpolator() {
        this.yDotKLast = null;
        this.v = null;
        this.vectorsInitialized = false;
    }

    DormandPrince853StepInterpolator(DormandPrince853StepInterpolator dormandPrince853StepInterpolator) {
        super(dormandPrince853StepInterpolator);
        if (dormandPrince853StepInterpolator.currentState == null) {
            this.yDotKLast = null;
            this.v = null;
            this.vectorsInitialized = false;
        } else {
            int n;
            int n2 = dormandPrince853StepInterpolator.currentState.length;
            this.yDotKLast = new double[3][];
            for (n = 0; n < this.yDotKLast.length; ++n) {
                this.yDotKLast[n] = new double[n2];
                System.arraycopy(dormandPrince853StepInterpolator.yDotKLast[n], 0, this.yDotKLast[n], 0, n2);
            }
            this.v = new double[7][];
            for (n = 0; n < this.v.length; ++n) {
                this.v[n] = new double[n2];
                System.arraycopy(dormandPrince853StepInterpolator.v[n], 0, this.v[n], 0, n2);
            }
            this.vectorsInitialized = dormandPrince853StepInterpolator.vectorsInitialized;
        }
    }

    protected StepInterpolator doCopy() {
        return new DormandPrince853StepInterpolator(this);
    }

    public void reinitialize(AbstractIntegrator abstractIntegrator, double[] dArray, double[][] dArray2, boolean bl, EquationsMapper equationsMapper, EquationsMapper[] equationsMapperArray) {
        int n;
        super.reinitialize(abstractIntegrator, dArray, dArray2, bl, equationsMapper, equationsMapperArray);
        int n2 = this.currentState.length;
        this.yDotKLast = new double[3][];
        for (n = 0; n < this.yDotKLast.length; ++n) {
            this.yDotKLast[n] = new double[n2];
        }
        this.v = new double[7][];
        for (n = 0; n < this.v.length; ++n) {
            this.v[n] = new double[n2];
        }
        this.vectorsInitialized = false;
    }

    public void storeTime(double d) {
        super.storeTime(d);
        this.vectorsInitialized = false;
    }

    protected void computeInterpolatedStateAndDerivatives(double d, double d2) {
        if (!this.vectorsInitialized) {
            int n;
            if (this.v == null) {
                this.v = new double[7][];
                for (n = 0; n < 7; ++n) {
                    this.v[n] = new double[this.interpolatedState.length];
                }
            }
            this.finalizeStep();
            for (n = 0; n < this.interpolatedState.length; ++n) {
                double d3 = this.yDotK[0][n];
                double d4 = this.yDotK[5][n];
                double d5 = this.yDotK[6][n];
                double d6 = this.yDotK[7][n];
                double d7 = this.yDotK[8][n];
                double d8 = this.yDotK[9][n];
                double d9 = this.yDotK[10][n];
                double d10 = this.yDotK[11][n];
                double d11 = this.yDotK[12][n];
                double d12 = this.yDotKLast[0][n];
                double d13 = this.yDotKLast[1][n];
                double d14 = this.yDotKLast[2][n];
                this.v[0][n] = 0.054293734116568765 * d3 + 4.450312892752409 * d4 + 1.8915178993145003 * d5 + -5.801203960010585 * d6 + 0.3111643669578199 * d7 + -0.1521609496625161 * d8 + 0.20136540080403034 * d9 + 0.04471061572777259 * d10;
                this.v[1][n] = d3 - this.v[0][n];
                this.v[2][n] = this.v[0][n] - this.v[1][n] - this.yDotK[12][n];
                for (int i = 0; i < D.length; ++i) {
                    this.v[i + 3][n] = D[i][0] * d3 + D[i][1] * d4 + D[i][2] * d5 + D[i][3] * d6 + D[i][4] * d7 + D[i][5] * d8 + D[i][6] * d9 + D[i][7] * d10 + D[i][8] * d11 + D[i][9] * d12 + D[i][10] * d13 + D[i][11] * d14;
                }
            }
            this.vectorsInitialized = true;
        }
        double d15 = 1.0 - d;
        double d16 = 2.0 * d;
        double d17 = d * d;
        double d18 = 1.0 - d16;
        double d19 = d * (2.0 - 3.0 * d);
        double d20 = d16 * (1.0 + d * (d16 - 3.0));
        double d21 = d17 * (3.0 + d * (5.0 * d - 8.0));
        double d22 = d17 * (3.0 + d * (-12.0 + d * (15.0 - 6.0 * d)));
        double d23 = d17 * d * (4.0 + d * (-15.0 + d * (18.0 - 7.0 * d)));
        if (this.previousState != null && d <= 0.5) {
            for (int i = 0; i < this.interpolatedState.length; ++i) {
                this.interpolatedState[i] = this.previousState[i] + d * this.h * (this.v[0][i] + d15 * (this.v[1][i] + d * (this.v[2][i] + d15 * (this.v[3][i] + d * (this.v[4][i] + d15 * (this.v[5][i] + d * this.v[6][i]))))));
                this.interpolatedDerivatives[i] = this.v[0][i] + d18 * this.v[1][i] + d19 * this.v[2][i] + d20 * this.v[3][i] + d21 * this.v[4][i] + d22 * this.v[5][i] + d23 * this.v[6][i];
            }
        } else {
            for (int i = 0; i < this.interpolatedState.length; ++i) {
                this.interpolatedState[i] = this.currentState[i] - d2 * (this.v[0][i] - d * (this.v[1][i] + d * (this.v[2][i] + d15 * (this.v[3][i] + d * (this.v[4][i] + d15 * (this.v[5][i] + d * this.v[6][i]))))));
                this.interpolatedDerivatives[i] = this.v[0][i] + d18 * this.v[1][i] + d19 * this.v[2][i] + d20 * this.v[3][i] + d21 * this.v[4][i] + d22 * this.v[5][i] + d23 * this.v[6][i];
            }
        }
    }

    protected void doFinalize() {
        double d;
        int n;
        if (this.currentState == null) {
            return;
        }
        double[] dArray = new double[this.currentState.length];
        double d2 = this.getGlobalPreviousTime();
        for (n = 0; n < this.currentState.length; ++n) {
            d = 0.0018737681664791894 * this.yDotK[0][n] + -4.450312892752409 * this.yDotK[5][n] + -1.6380176890978755 * this.yDotK[6][n] + 5.554964922539782 * this.yDotK[7][n] + -0.4353557902216363 * this.yDotK[8][n] + 0.30545274794128174 * this.yDotK[9][n] + -0.19316434850839564 * this.yDotK[10][n] + -0.03714271806722689 * this.yDotK[11][n] + -0.008298 * this.yDotK[12][n];
            dArray[n] = this.currentState[n] + this.h * d;
        }
        this.integrator.computeDerivatives(d2 + 0.1 * this.h, dArray, this.yDotKLast[0]);
        for (n = 0; n < this.currentState.length; ++n) {
            d = -0.022459085953066622 * this.yDotK[0][n] + -4.422011983080043 * this.yDotK[5][n] + -1.8379759110070617 * this.yDotK[6][n] + 5.746280211439194 * this.yDotK[7][n] + -0.3111643669578199 * this.yDotK[8][n] + 0.1521609496625161 * this.yDotK[9][n] + -0.2014737481327276 * this.yDotK[10][n] + -0.04432804463693693 * this.yDotK[11][n] + -3.4046500868740456E-4 * this.yDotK[12][n] + 0.1413124436746325 * this.yDotKLast[0][n];
            dArray[n] = this.currentState[n] + this.h * d;
        }
        this.integrator.computeDerivatives(d2 + 0.2 * this.h, dArray, this.yDotKLast[1]);
        for (n = 0; n < this.currentState.length; ++n) {
            d = -0.4831900357003607 * this.yDotK[0][n] + -9.147934308113573 * this.yDotK[5][n] + 5.791903296748099 * this.yDotK[6][n] + 9.870193778407696 * this.yDotK[7][n] + 0.04556282049746119 * this.yDotK[8][n] + 0.1521609496625161 * this.yDotK[9][n] + -0.20136540080403034 * this.yDotK[10][n] + -0.04471061572777259 * this.yDotK[11][n] + -0.0013990241651590145 * this.yDotK[12][n] + 2.9475147891527724 * this.yDotKLast[0][n] + -9.15095847217987 * this.yDotKLast[1][n];
            dArray[n] = this.currentState[n] + this.h * d;
        }
        this.integrator.computeDerivatives(d2 + 0.7777777777777778 * this.h, dArray, this.yDotKLast[2]);
    }

    public void writeExternal(ObjectOutput objectOutput) {
        try {
            this.finalizeStep();
        }
        catch (MaxCountExceededException maxCountExceededException) {
            IOException iOException = new IOException(maxCountExceededException.getLocalizedMessage());
            iOException.initCause(maxCountExceededException);
            throw iOException;
        }
        int n = this.currentState == null ? -1 : this.currentState.length;
        objectOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutput.writeDouble(this.yDotKLast[0][i]);
            objectOutput.writeDouble(this.yDotKLast[1][i]);
            objectOutput.writeDouble(this.yDotKLast[2][i]);
        }
        super.writeExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) {
        this.yDotKLast = new double[3][];
        int n = objectInput.readInt();
        this.yDotKLast[0] = n < 0 ? null : new double[n];
        this.yDotKLast[1] = n < 0 ? null : new double[n];
        this.yDotKLast[2] = n < 0 ? null : new double[n];
        for (int i = 0; i < n; ++i) {
            this.yDotKLast[0][i] = objectInput.readDouble();
            this.yDotKLast[1][i] = objectInput.readDouble();
            this.yDotKLast[2][i] = objectInput.readDouble();
        }
        super.readExternal(objectInput);
    }
}

