/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.ode.FieldEquationsMapper;
import org.apache.commons.math3.ode.FieldExpandableODE;
import org.apache.commons.math3.ode.FieldODEState;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.ode.nonstiff.AdaptiveStepsizeFieldIntegrator;
import org.apache.commons.math3.ode.nonstiff.FieldButcherArrayProvider;
import org.apache.commons.math3.ode.nonstiff.RungeKuttaFieldStepInterpolator;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EmbeddedRungeKuttaFieldIntegrator<T extends RealFieldElement<T>>
extends AdaptiveStepsizeFieldIntegrator<T>
implements FieldButcherArrayProvider<T> {
    private final int fsal;
    private final T[] c;
    private final T[][] a;
    private final T[] b;
    private final T exp;
    private T safety;
    private T minReduction;
    private T maxGrowth;

    protected EmbeddedRungeKuttaFieldIntegrator(Field<T> field, String string, int n, double d, double d2, double d3, double d4) {
        super(field, string, d, d2, d3, d4);
        this.fsal = n;
        this.c = this.getC();
        this.a = this.getA();
        this.b = this.getB();
        this.exp = (RealFieldElement)((RealFieldElement)field.getOne()).divide(-this.getOrder());
        this.setSafety((RealFieldElement)((RealFieldElement)field.getZero()).add(0.9));
        this.setMinReduction((RealFieldElement)((RealFieldElement)field.getZero()).add(0.2));
        this.setMaxGrowth((RealFieldElement)((RealFieldElement)field.getZero()).add(10.0));
    }

    protected EmbeddedRungeKuttaFieldIntegrator(Field<T> field, String string, int n, double d, double d2, double[] dArray, double[] dArray2) {
        super(field, string, d, d2, dArray, dArray2);
        this.fsal = n;
        this.c = this.getC();
        this.a = this.getA();
        this.b = this.getB();
        this.exp = (RealFieldElement)((RealFieldElement)field.getOne()).divide(-this.getOrder());
        this.setSafety((RealFieldElement)((RealFieldElement)field.getZero()).add(0.9));
        this.setMinReduction((RealFieldElement)((RealFieldElement)field.getZero()).add(0.2));
        this.setMaxGrowth((RealFieldElement)((RealFieldElement)field.getZero()).add(10.0));
    }

    protected T fraction(int n, int n2) {
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.getField().getOne()).multiply(n)).divide(n2));
    }

    protected T fraction(double d, double d2) {
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.getField().getOne()).multiply(d)).divide(d2));
    }

    protected abstract RungeKuttaFieldStepInterpolator<T> createInterpolator(boolean var1, T[][] var2, FieldODEStateAndDerivative<T> var3, FieldODEStateAndDerivative<T> var4, FieldEquationsMapper<T> var5);

    public abstract int getOrder();

    public T getSafety() {
        return this.safety;
    }

    public void setSafety(T t) {
        this.safety = t;
    }

    @Override
    public FieldODEStateAndDerivative<T> integrate(FieldExpandableODE<T> fieldExpandableODE, FieldODEState<T> fieldODEState, T t) {
        Object object;
        this.sanityChecks(fieldODEState, t);
        T t2 = fieldODEState.getTime();
        RealFieldElement[] realFieldElementArray = fieldExpandableODE.getMapper().mapState(fieldODEState);
        this.setStepStart(this.initIntegration(fieldExpandableODE, (RealFieldElement)t2, realFieldElementArray, (RealFieldElement)t));
        boolean bl = ((RealFieldElement)t.subtract(fieldODEState.getTime())).getReal() > 0.0;
        int n = this.c.length + 1;
        RealFieldElement[] realFieldElementArray2 = realFieldElementArray;
        RealFieldElement[][] realFieldElementArray3 = (RealFieldElement[][])MathArrays.buildArray(this.getField(), n, -1);
        RealFieldElement[] realFieldElementArray4 = (RealFieldElement[])MathArrays.buildArray(this.getField(), realFieldElementArray.length);
        RealFieldElement realFieldElement = (RealFieldElement)this.getField().getZero();
        boolean bl2 = true;
        this.setIsLastStep(false);
        do {
            boolean bl3;
            object = (RealFieldElement)((RealFieldElement)this.getField().getZero()).add(10.0);
            while (((RealFieldElement)object.subtract(1.0)).getReal() >= 0.0) {
                int n2;
                int n3;
                realFieldElementArray2 = fieldExpandableODE.getMapper().mapState(this.getStepStart());
                realFieldElementArray3[0] = fieldExpandableODE.getMapper().mapDerivative(this.getStepStart());
                if (bl2) {
                    RealFieldElement[] realFieldElementArray5 = (RealFieldElement[])MathArrays.buildArray(this.getField(), this.mainSetDimension);
                    if (this.vecAbsoluteTolerance == null) {
                        for (n3 = 0; n3 < realFieldElementArray5.length; ++n3) {
                            realFieldElementArray5[n3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElementArray2[n3].abs()).multiply(this.scalRelativeTolerance)).add(this.scalAbsoluteTolerance);
                        }
                    } else {
                        for (n3 = 0; n3 < realFieldElementArray5.length; ++n3) {
                            realFieldElementArray5[n3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)realFieldElementArray2[n3].abs()).multiply(this.vecRelativeTolerance[n3])).add(this.vecAbsoluteTolerance[n3]);
                        }
                    }
                    realFieldElement = this.initializeStep(bl, this.getOrder(), realFieldElementArray5, this.getStepStart(), fieldExpandableODE.getMapper());
                    bl2 = false;
                }
                this.setStepSize(realFieldElement);
                if (bl) {
                    if (((RealFieldElement)((RealFieldElement)this.getStepStart().getTime().add(this.getStepSize())).subtract(t)).getReal() >= 0.0) {
                        this.setStepSize((RealFieldElement)t.subtract(this.getStepStart().getTime()));
                    }
                } else if (((RealFieldElement)((RealFieldElement)this.getStepStart().getTime().add(this.getStepSize())).subtract(t)).getReal() <= 0.0) {
                    this.setStepSize((RealFieldElement)t.subtract(this.getStepStart().getTime()));
                }
                for (n2 = 1; n2 < n; ++n2) {
                    for (n3 = 0; n3 < realFieldElementArray.length; ++n3) {
                        RealFieldElement realFieldElement2 = (RealFieldElement)realFieldElementArray3[0][n3].multiply(this.a[n2 - 1][0]);
                        for (int i = 1; i < n2; ++i) {
                            realFieldElement2 = (RealFieldElement)realFieldElement2.add(realFieldElementArray3[i][n3].multiply(this.a[n2 - 1][i]));
                        }
                        realFieldElementArray4[n3] = realFieldElementArray2[n3].add(this.getStepSize().multiply((RealFieldElement)realFieldElement2));
                    }
                    realFieldElementArray3[n2] = this.computeDerivatives((RealFieldElement)this.getStepStart().getTime().add(this.getStepSize().multiply(this.c[n2 - 1])), realFieldElementArray4);
                }
                for (n2 = 0; n2 < realFieldElementArray.length; ++n2) {
                    RealFieldElement realFieldElement3 = (RealFieldElement)realFieldElementArray3[0][n2].multiply(this.b[0]);
                    for (int i = 1; i < n; ++i) {
                        realFieldElement3 = (RealFieldElement)realFieldElement3.add(realFieldElementArray3[i][n2].multiply(this.b[i]));
                    }
                    realFieldElementArray4[n2] = realFieldElementArray2[n2].add(this.getStepSize().multiply((RealFieldElement)realFieldElement3));
                }
                object = this.estimateError(realFieldElementArray3, realFieldElementArray2, realFieldElementArray4, (RealFieldElement)this.getStepSize());
                if (!(((RealFieldElement)object.subtract(1.0)).getReal() >= 0.0)) continue;
                RealFieldElement realFieldElement4 = MathUtils.min(this.maxGrowth, MathUtils.max(this.minReduction, (RealFieldElement)this.safety.multiply(object.pow(this.exp))));
                realFieldElement = this.filterStep(this.getStepSize().multiply((RealFieldElement)realFieldElement4), bl, false);
            }
            RealFieldElement realFieldElement5 = (RealFieldElement)this.getStepStart().getTime().add(this.getStepSize());
            RealFieldElement[] realFieldElementArray6 = this.fsal >= 0 ? realFieldElementArray3[this.fsal] : this.computeDerivatives(realFieldElement5, realFieldElementArray4);
            FieldODEStateAndDerivative fieldODEStateAndDerivative = new FieldODEStateAndDerivative(realFieldElement5, realFieldElementArray4, realFieldElementArray6);
            System.arraycopy(realFieldElementArray4, 0, realFieldElementArray2, 0, realFieldElementArray.length);
            this.setStepStart(this.acceptStep(this.createInterpolator(bl, realFieldElementArray3, this.getStepStart(), fieldODEStateAndDerivative, fieldExpandableODE.getMapper()), t));
            if (this.isLastStep()) continue;
            RealFieldElement realFieldElement6 = MathUtils.min(this.maxGrowth, MathUtils.max(this.minReduction, (RealFieldElement)this.safety.multiply(object.pow(this.exp))));
            RealFieldElement realFieldElement7 = this.getStepSize().multiply((RealFieldElement)realFieldElement6);
            RealFieldElement realFieldElement8 = this.getStepStart().getTime().add((RealFieldElement)realFieldElement7);
            boolean bl4 = bl ? ((RealFieldElement)realFieldElement8.subtract(t)).getReal() >= 0.0 : ((RealFieldElement)realFieldElement8.subtract(t)).getReal() <= 0.0;
            realFieldElement = this.filterStep(realFieldElement7, bl, bl4);
            RealFieldElement realFieldElement9 = this.getStepStart().getTime().add((RealFieldElement)realFieldElement);
            boolean bl5 = bl ? ((RealFieldElement)realFieldElement9.subtract(t)).getReal() >= 0.0 : (bl3 = ((RealFieldElement)realFieldElement9.subtract(t)).getReal() <= 0.0);
            if (!bl3) continue;
            realFieldElement = (RealFieldElement)t.subtract(this.getStepStart().getTime());
        } while (!this.isLastStep());
        object = this.getStepStart();
        this.resetInternalState();
        return object;
    }

    public T getMinReduction() {
        return this.minReduction;
    }

    public void setMinReduction(T t) {
        this.minReduction = t;
    }

    public T getMaxGrowth() {
        return this.maxGrowth;
    }

    public void setMaxGrowth(T t) {
        this.maxGrowth = t;
    }

    protected abstract T estimateError(T[][] var1, T[] var2, T[] var3, T var4);
}

