/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.ode.ExpandableStatefulODE;
import org.apache.commons.math3.ode.nonstiff.AdaptiveStepsizeIntegrator;
import org.apache.commons.math3.ode.nonstiff.RungeKuttaStepInterpolator;
import org.apache.commons.math3.util.FastMath;

public abstract class EmbeddedRungeKuttaIntegrator
extends AdaptiveStepsizeIntegrator {
    private final boolean fsal;
    private final double[] c;
    private final double[][] a;
    private final double[] b;
    private final RungeKuttaStepInterpolator prototype;
    private final double exp;
    private double safety;
    private double minReduction;
    private double maxGrowth;

    protected EmbeddedRungeKuttaIntegrator(String string, boolean bl, double[] dArray, double[][] dArray2, double[] dArray3, RungeKuttaStepInterpolator rungeKuttaStepInterpolator, double d, double d2, double d3, double d4) {
        super(string, d, d2, d3, d4);
        this.fsal = bl;
        this.c = dArray;
        this.a = dArray2;
        this.b = dArray3;
        this.prototype = rungeKuttaStepInterpolator;
        this.exp = -1.0 / (double)this.getOrder();
        this.setSafety(0.9);
        this.setMinReduction(0.2);
        this.setMaxGrowth(10.0);
    }

    protected EmbeddedRungeKuttaIntegrator(String string, boolean bl, double[] dArray, double[][] dArray2, double[] dArray3, RungeKuttaStepInterpolator rungeKuttaStepInterpolator, double d, double d2, double[] dArray4, double[] dArray5) {
        super(string, d, d2, dArray4, dArray5);
        this.fsal = bl;
        this.c = dArray;
        this.a = dArray2;
        this.b = dArray3;
        this.prototype = rungeKuttaStepInterpolator;
        this.exp = -1.0 / (double)this.getOrder();
        this.setSafety(0.9);
        this.setMinReduction(0.2);
        this.setMaxGrowth(10.0);
    }

    public abstract int getOrder();

    public double getSafety() {
        return this.safety;
    }

    public void setSafety(double d) {
        this.safety = d;
    }

    public void integrate(ExpandableStatefulODE expandableStatefulODE, double d) {
        this.sanityChecks(expandableStatefulODE, d);
        this.setEquations(expandableStatefulODE);
        boolean bl = d > expandableStatefulODE.getTime();
        double[] dArray = expandableStatefulODE.getCompleteState();
        double[] dArray2 = (double[])dArray.clone();
        int n = this.c.length + 1;
        double[][] dArray3 = new double[n][dArray2.length];
        double[] dArray4 = (double[])dArray.clone();
        double[] dArray5 = new double[dArray2.length];
        RungeKuttaStepInterpolator rungeKuttaStepInterpolator = (RungeKuttaStepInterpolator)this.prototype.copy();
        rungeKuttaStepInterpolator.reinitialize(this, dArray4, dArray3, bl, expandableStatefulODE.getPrimaryMapper(), expandableStatefulODE.getSecondaryMappers());
        rungeKuttaStepInterpolator.storeTime(expandableStatefulODE.getTime());
        this.stepStart = expandableStatefulODE.getTime();
        double d2 = 0.0;
        boolean bl2 = true;
        this.initIntegration(expandableStatefulODE.getTime(), dArray, d);
        this.isLastStep = false;
        do {
            boolean bl3;
            double d3;
            rungeKuttaStepInterpolator.shift();
            double d4 = 10.0;
            while (d4 >= 1.0) {
                int n2;
                int n3;
                if (bl2 || !this.fsal) {
                    this.computeDerivatives(this.stepStart, dArray2, dArray3[0]);
                }
                if (bl2) {
                    double[] dArray6 = new double[this.mainSetDimension];
                    if (this.vecAbsoluteTolerance == null) {
                        for (n3 = 0; n3 < dArray6.length; ++n3) {
                            dArray6[n3] = this.scalAbsoluteTolerance + this.scalRelativeTolerance * FastMath.abs(dArray2[n3]);
                        }
                    } else {
                        for (n3 = 0; n3 < dArray6.length; ++n3) {
                            dArray6[n3] = this.vecAbsoluteTolerance[n3] + this.vecRelativeTolerance[n3] * FastMath.abs(dArray2[n3]);
                        }
                    }
                    d2 = this.initializeStep(bl, this.getOrder(), dArray6, this.stepStart, dArray2, dArray3[0], dArray4, dArray3[1]);
                    bl2 = false;
                }
                this.stepSize = d2;
                if (bl) {
                    if (this.stepStart + this.stepSize >= d) {
                        this.stepSize = d - this.stepStart;
                    }
                } else if (this.stepStart + this.stepSize <= d) {
                    this.stepSize = d - this.stepStart;
                }
                for (n2 = 1; n2 < n; ++n2) {
                    for (n3 = 0; n3 < dArray.length; ++n3) {
                        d3 = this.a[n2 - 1][0] * dArray3[0][n3];
                        for (int i = 1; i < n2; ++i) {
                            d3 += this.a[n2 - 1][i] * dArray3[i][n3];
                        }
                        dArray4[n3] = dArray2[n3] + this.stepSize * d3;
                    }
                    this.computeDerivatives(this.stepStart + this.c[n2 - 1] * this.stepSize, dArray4, dArray3[n2]);
                }
                for (n2 = 0; n2 < dArray.length; ++n2) {
                    double d5 = this.b[0] * dArray3[0][n2];
                    for (int i = 1; i < n; ++i) {
                        d5 += this.b[i] * dArray3[i][n2];
                    }
                    dArray4[n2] = dArray2[n2] + this.stepSize * d5;
                }
                d4 = this.estimateError(dArray3, dArray2, dArray4, this.stepSize);
                if (!(d4 >= 1.0)) continue;
                double d6 = FastMath.min(this.maxGrowth, FastMath.max(this.minReduction, this.safety * FastMath.pow(d4, this.exp)));
                d2 = this.filterStep(this.stepSize * d6, bl, false);
            }
            rungeKuttaStepInterpolator.storeTime(this.stepStart + this.stepSize);
            System.arraycopy(dArray4, 0, dArray2, 0, dArray.length);
            System.arraycopy(dArray3[n - 1], 0, dArray5, 0, dArray.length);
            this.stepStart = this.acceptStep(rungeKuttaStepInterpolator, dArray2, dArray5, d);
            System.arraycopy(dArray2, 0, dArray4, 0, dArray2.length);
            if (this.isLastStep) continue;
            rungeKuttaStepInterpolator.storeTime(this.stepStart);
            if (this.fsal) {
                System.arraycopy(dArray5, 0, dArray3[0], 0, dArray.length);
            }
            double d7 = FastMath.min(this.maxGrowth, FastMath.max(this.minReduction, this.safety * FastMath.pow(d4, this.exp)));
            d3 = this.stepSize * d7;
            double d8 = this.stepStart + d3;
            boolean bl4 = bl ? d8 >= d : d8 <= d;
            d2 = this.filterStep(d3, bl, bl4);
            double d9 = this.stepStart + d2;
            boolean bl5 = bl ? d9 >= d : (bl3 = d9 <= d);
            if (!bl3) continue;
            d2 = d - this.stepStart;
        } while (!this.isLastStep);
        expandableStatefulODE.setTime(this.stepStart);
        expandableStatefulODE.setCompleteState(dArray2);
        this.resetInternalState();
    }

    public double getMinReduction() {
        return this.minReduction;
    }

    public void setMinReduction(double d) {
        this.minReduction = d;
    }

    public double getMaxGrowth() {
        return this.maxGrowth;
    }

    public void setMaxGrowth(double d) {
        this.maxGrowth = d;
    }

    protected abstract double estimateError(double[][] var1, double[] var2, double[] var3, double var4);
}

