/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.commons.math3.ode.EquationsMapper;
import org.apache.commons.math3.ode.sampling.AbstractStepInterpolator;
import org.apache.commons.math3.ode.sampling.StepInterpolator;
import org.apache.commons.math3.util.FastMath;

class GraggBulirschStoerStepInterpolator
extends AbstractStepInterpolator {
    private static final long serialVersionUID = 20110928L;
    private double[] y0Dot;
    private double[] y1;
    private double[] y1Dot;
    private double[][] yMidDots;
    private double[][] polynomials;
    private double[] errfac;
    private int currentDegree;

    public GraggBulirschStoerStepInterpolator() {
        this.y0Dot = null;
        this.y1 = null;
        this.y1Dot = null;
        this.yMidDots = null;
        this.resetTables(-1);
    }

    GraggBulirschStoerStepInterpolator(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[][] dArray5, boolean bl, EquationsMapper equationsMapper, EquationsMapper[] equationsMapperArray) {
        super(dArray, bl, equationsMapper, equationsMapperArray);
        this.y0Dot = dArray2;
        this.y1 = dArray3;
        this.y1Dot = dArray4;
        this.yMidDots = dArray5;
        this.resetTables(dArray5.length + 4);
    }

    GraggBulirschStoerStepInterpolator(GraggBulirschStoerStepInterpolator graggBulirschStoerStepInterpolator) {
        super(graggBulirschStoerStepInterpolator);
        int n = this.currentState.length;
        this.y0Dot = null;
        this.y1 = null;
        this.y1Dot = null;
        this.yMidDots = null;
        if (graggBulirschStoerStepInterpolator.polynomials == null) {
            this.polynomials = null;
            this.currentDegree = -1;
        } else {
            this.resetTables(graggBulirschStoerStepInterpolator.currentDegree);
            for (int i = 0; i < this.polynomials.length; ++i) {
                this.polynomials[i] = new double[n];
                System.arraycopy(graggBulirschStoerStepInterpolator.polynomials[i], 0, this.polynomials[i], 0, n);
            }
            this.currentDegree = graggBulirschStoerStepInterpolator.currentDegree;
        }
    }

    private void resetTables(int n) {
        if (n < 0) {
            this.polynomials = null;
            this.errfac = null;
            this.currentDegree = -1;
        } else {
            int n2;
            double[][] dArrayArray = new double[n + 1][];
            if (this.polynomials != null) {
                System.arraycopy(this.polynomials, 0, dArrayArray, 0, this.polynomials.length);
                for (n2 = this.polynomials.length; n2 < dArrayArray.length; ++n2) {
                    dArrayArray[n2] = new double[this.currentState.length];
                }
            } else {
                for (n2 = 0; n2 < dArrayArray.length; ++n2) {
                    dArrayArray[n2] = new double[this.currentState.length];
                }
            }
            this.polynomials = dArrayArray;
            if (n <= 4) {
                this.errfac = null;
            } else {
                this.errfac = new double[n - 4];
                for (n2 = 0; n2 < this.errfac.length; ++n2) {
                    int n3 = n2 + 5;
                    this.errfac[n2] = 1.0 / (double)(n3 * n3);
                    double d = 0.5 * FastMath.sqrt((double)(n2 + 1) / (double)n3);
                    for (int i = 0; i <= n2; ++i) {
                        int n4 = n2;
                        this.errfac[n4] = this.errfac[n4] * (d / (double)(i + 1));
                    }
                }
            }
            this.currentDegree = 0;
        }
    }

    protected StepInterpolator doCopy() {
        return new GraggBulirschStoerStepInterpolator(this);
    }

    public void computeCoefficients(int n, double d) {
        if (this.polynomials == null || this.polynomials.length <= n + 4) {
            this.resetTables(n + 4);
        }
        this.currentDegree = n + 4;
        for (int i = 0; i < this.currentState.length; ++i) {
            double d2 = d * this.y0Dot[i];
            double d3 = d * this.y1Dot[i];
            double d4 = this.y1[i] - this.currentState[i];
            double d5 = d4 - d3;
            double d6 = d2 - d4;
            this.polynomials[0][i] = this.currentState[i];
            this.polynomials[1][i] = d4;
            this.polynomials[2][i] = d5;
            this.polynomials[3][i] = d6;
            if (n < 0) {
                return;
            }
            double d7 = 0.5 * (this.currentState[i] + this.y1[i]) + 0.125 * (d5 + d6);
            this.polynomials[4][i] = 16.0 * (this.yMidDots[0][i] - d7);
            if (n <= 0) continue;
            double d8 = d4 + 0.25 * (d5 - d6);
            this.polynomials[5][i] = 16.0 * (this.yMidDots[1][i] - d8);
            if (n <= 1) continue;
            double d9 = d3 - d2;
            this.polynomials[6][i] = 16.0 * (this.yMidDots[2][i] - d9 + this.polynomials[4][i]);
            if (n <= 2) continue;
            double d10 = 6.0 * (d6 - d5);
            this.polynomials[7][i] = 16.0 * (this.yMidDots[3][i] - d10 + 3.0 * this.polynomials[5][i]);
            for (int j = 4; j <= n; ++j) {
                double d11 = 0.5 * (double)j * (double)(j - 1);
                double d12 = 2.0 * d11 * (double)(j - 2) * (double)(j - 3);
                this.polynomials[j + 4][i] = 16.0 * (this.yMidDots[j][i] + d11 * this.polynomials[j + 2][i] - d12 * this.polynomials[j][i]);
            }
        }
    }

    public double estimateError(double[] dArray) {
        double d = 0.0;
        if (this.currentDegree >= 5) {
            for (int i = 0; i < dArray.length; ++i) {
                double d2 = this.polynomials[this.currentDegree][i] / dArray[i];
                d += d2 * d2;
            }
            d = FastMath.sqrt(d / (double)dArray.length) * this.errfac[this.currentDegree - 5];
        }
        return d;
    }

    protected void computeInterpolatedStateAndDerivatives(double d, double d2) {
        int n = this.currentState.length;
        double d3 = 1.0 - d;
        double d4 = d - 0.5;
        double d5 = d * d3;
        double d6 = d5 * d5;
        double d7 = 2.0 * d5 * (1.0 - 2.0 * d);
        double d8 = 1.0 / this.h;
        double d9 = d * (2.0 - 3.0 * d) / this.h;
        double d10 = ((3.0 * d - 4.0) * d + 1.0) / this.h;
        for (int i = 0; i < n; ++i) {
            double d11 = this.polynomials[0][i];
            double d12 = this.polynomials[1][i];
            double d13 = this.polynomials[2][i];
            double d14 = this.polynomials[3][i];
            this.interpolatedState[i] = d11 + d * (d12 + d3 * (d13 * d + d14 * d3));
            this.interpolatedDerivatives[i] = d8 * d12 + d9 * d13 + d10 * d14;
            if (this.currentDegree <= 3) continue;
            double d15 = 0.0;
            double d16 = this.polynomials[this.currentDegree][i];
            for (int j = this.currentDegree - 1; j > 3; --j) {
                double d17 = 1.0 / (double)(j - 3);
                d15 = d17 * (d4 * d15 + d16);
                d16 = this.polynomials[j][i] + d16 * d17 * d4;
            }
            int n2 = i;
            this.interpolatedState[n2] = this.interpolatedState[n2] + d6 * d16;
            int n3 = i;
            this.interpolatedDerivatives[n3] = this.interpolatedDerivatives[n3] + (d6 * d15 + d7 * d16) / this.h;
        }
        if (this.h == 0.0) {
            System.arraycopy(this.yMidDots[1], 0, this.interpolatedDerivatives, 0, n);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) {
        int n = this.currentState == null ? -1 : this.currentState.length;
        this.writeBaseExternal(objectOutput);
        objectOutput.writeInt(this.currentDegree);
        for (int i = 0; i <= this.currentDegree; ++i) {
            for (int j = 0; j < n; ++j) {
                objectOutput.writeDouble(this.polynomials[i][j]);
            }
        }
    }

    public void readExternal(ObjectInput objectInput) {
        double d = this.readBaseExternal(objectInput);
        int n = this.currentState == null ? -1 : this.currentState.length;
        int n2 = objectInput.readInt();
        this.resetTables(n2);
        this.currentDegree = n2;
        for (int i = 0; i <= this.currentDegree; ++i) {
            for (int j = 0; j < n; ++j) {
                this.polynomials[i][j] = objectInput.readDouble();
            }
        }
        this.setInterpolatedTime(d);
    }
}

