/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.ode.nonstiff.EmbeddedRungeKuttaIntegrator;
import org.apache.commons.math3.ode.nonstiff.HighamHall54StepInterpolator;
import org.apache.commons.math3.ode.nonstiff.RungeKuttaStepInterpolator;
import org.apache.commons.math3.util.FastMath;

public class HighamHall54Integrator
extends EmbeddedRungeKuttaIntegrator {
    private static final String METHOD_NAME = "Higham-Hall 5(4)";
    private static final double[] STATIC_C = new double[]{0.2222222222222222, 0.3333333333333333, 0.5, 0.6, 1.0, 1.0};
    private static final double[][] STATIC_A = new double[][]{{0.2222222222222222}, {0.08333333333333333, 0.25}, {0.125, 0.0, 0.375}, {0.182, -0.27, 0.624, 0.064}, {-0.55, 1.35, 2.4, -7.2, 5.0}, {0.08333333333333333, 0.0, 0.84375, -1.3333333333333333, 1.3020833333333333, 0.10416666666666667}};
    private static final double[] STATIC_B = new double[]{0.08333333333333333, 0.0, 0.84375, -1.3333333333333333, 1.3020833333333333, 0.10416666666666667, 0.0};
    private static final double[] STATIC_E = new double[]{-0.05, 0.0, 0.50625, -1.2, 0.78125, 0.0625, -0.1};

    public HighamHall54Integrator(double d, double d2, double d3, double d4) {
        super(METHOD_NAME, false, STATIC_C, STATIC_A, STATIC_B, (RungeKuttaStepInterpolator)new HighamHall54StepInterpolator(), d, d2, d3, d4);
    }

    public HighamHall54Integrator(double d, double d2, double[] dArray, double[] dArray2) {
        super(METHOD_NAME, false, STATIC_C, STATIC_A, STATIC_B, (RungeKuttaStepInterpolator)new HighamHall54StepInterpolator(), d, d2, dArray, dArray2);
    }

    public int getOrder() {
        return 5;
    }

    protected double estimateError(double[][] dArray, double[] dArray2, double[] dArray3, double d) {
        double d2 = 0.0;
        for (int i = 0; i < this.mainSetDimension; ++i) {
            double d3 = STATIC_E[0] * dArray[0][i];
            for (int j = 1; j < STATIC_E.length; ++j) {
                d3 += STATIC_E[j] * dArray[j][i];
            }
            double d4 = FastMath.max(FastMath.abs(dArray2[i]), FastMath.abs(dArray3[i]));
            double d5 = this.vecAbsoluteTolerance == null ? this.scalAbsoluteTolerance + this.scalRelativeTolerance * d4 : this.vecAbsoluteTolerance[i] + this.vecRelativeTolerance[i] * d4;
            double d6 = d * d3 / d5;
            d2 += d6 * d6;
        }
        return FastMath.sqrt(d2 / (double)this.mainSetDimension);
    }
}

