/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.ode.nonstiff.RungeKuttaStepInterpolator;
import org.apache.commons.math3.ode.sampling.StepInterpolator;

class HighamHall54StepInterpolator
extends RungeKuttaStepInterpolator {
    private static final long serialVersionUID = 20111120L;

    public HighamHall54StepInterpolator() {
    }

    HighamHall54StepInterpolator(HighamHall54StepInterpolator highamHall54StepInterpolator) {
        super(highamHall54StepInterpolator);
    }

    protected StepInterpolator doCopy() {
        return new HighamHall54StepInterpolator(this);
    }

    protected void computeInterpolatedStateAndDerivatives(double d, double d2) {
        double d3 = 1.0 + d * (-7.5 + d * (16.0 - 10.0 * d));
        double d4 = d * (28.6875 + d * (-91.125 + 67.5 * d));
        double d5 = d * (-44.0 + d * (152.0 - 120.0 * d));
        double d6 = d * (23.4375 + d * (-78.125 + 62.5 * d));
        double d7 = d * 5.0 / 8.0 * (2.0 * d - 1.0);
        if (this.previousState != null && d <= 0.5) {
            double d8 = this.h * d;
            double d9 = d8 * (1.0 + d * (-3.75 + d * (5.333333333333333 - 2.5 * d)));
            double d10 = d8 * (d * (14.34375 + d * (-30.375 + d * 135.0 / 8.0)));
            double d11 = d8 * (d * (-22.0 + d * (50.666666666666664 + d * -30.0)));
            double d12 = d8 * (d * (11.71875 + d * (-26.041666666666668 + d * 125.0 / 8.0)));
            double d13 = d8 * (d * (-0.3125 + d * 5.0 / 12.0));
            for (int i = 0; i < this.interpolatedState.length; ++i) {
                double d14 = this.yDotK[0][i];
                double d15 = this.yDotK[2][i];
                double d16 = this.yDotK[3][i];
                double d17 = this.yDotK[4][i];
                double d18 = this.yDotK[5][i];
                this.interpolatedState[i] = this.previousState[i] + d9 * d14 + d10 * d15 + d11 * d16 + d12 * d17 + d13 * d18;
                this.interpolatedDerivatives[i] = d3 * d14 + d4 * d15 + d5 * d16 + d6 * d17 + d7 * d18;
            }
        } else {
            double d19 = d * d;
            double d20 = this.h * (-0.08333333333333333 + d * (1.0 + d * (-3.75 + d * (5.333333333333333 + d * -5.0 / 2.0))));
            double d21 = this.h * (-0.84375 + d19 * (14.34375 + d * (-30.375 + d * 135.0 / 8.0)));
            double d22 = this.h * (1.3333333333333333 + d19 * (-22.0 + d * (50.666666666666664 + d * -30.0)));
            double d23 = this.h * (-1.3020833333333333 + d19 * (11.71875 + d * (-26.041666666666668 + d * 125.0 / 8.0)));
            double d24 = this.h * (-0.10416666666666667 + d19 * (-0.3125 + d * 5.0 / 12.0));
            for (int i = 0; i < this.interpolatedState.length; ++i) {
                double d25 = this.yDotK[0][i];
                double d26 = this.yDotK[2][i];
                double d27 = this.yDotK[3][i];
                double d28 = this.yDotK[4][i];
                double d29 = this.yDotK[5][i];
                this.interpolatedState[i] = this.currentState[i] + d20 * d25 + d21 * d26 + d22 * d27 + d23 * d28 + d24 * d29;
                this.interpolatedDerivatives[i] = d3 * d25 + d4 * d26 + d5 * d27 + d6 * d28 + d7 * d29;
            }
        }
    }
}

