/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.ode.nonstiff.RungeKuttaStepInterpolator;
import org.apache.commons.math3.ode.sampling.StepInterpolator;
import org.apache.commons.math3.util.FastMath;

class LutherStepInterpolator
extends RungeKuttaStepInterpolator {
    private static final long serialVersionUID = 20140416L;
    private static final double Q = FastMath.sqrt(21.0);

    public LutherStepInterpolator() {
    }

    LutherStepInterpolator(LutherStepInterpolator lutherStepInterpolator) {
        super(lutherStepInterpolator);
    }

    protected StepInterpolator doCopy() {
        return new LutherStepInterpolator(this);
    }

    protected void computeInterpolatedStateAndDerivatives(double d, double d2) {
        double d3 = 1.0 + d * (-10.8 + d * (36.0 + d * (-47.0 + d * 21.0)));
        double d4 = 0.0;
        double d5 = d * (-13.866666666666667 + d * (106.66666666666667 + d * (-202.66666666666666 + d * 112.0)));
        double d6 = d * (12.96 + d * (-97.2 + d * (194.4 + d * -567.0 / 5.0)));
        double d7 = d * ((833.0 + 343.0 * Q) / 150.0 + d * ((-637.0 - 357.0 * Q) / 30.0 + d * ((392.0 + 287.0 * Q) / 15.0 + d * (-49.0 - 49.0 * Q) / 5.0)));
        double d8 = d * ((833.0 - 343.0 * Q) / 150.0 + d * ((-637.0 + 357.0 * Q) / 30.0 + d * ((392.0 - 287.0 * Q) / 15.0 + d * (-49.0 + 49.0 * Q) / 5.0)));
        double d9 = d * (0.6 + d * (-3.0 + d * 3.0));
        if (this.previousState != null && d <= 0.5) {
            double d10 = 1.0 + d * (-5.4 + d * (12.0 + d * (-11.75 + d * 21.0 / 5.0)));
            double d11 = 0.0;
            double d12 = d * (-6.933333333333334 + d * (35.55555555555556 + d * (-50.666666666666664 + d * 112.0 / 5.0)));
            double d13 = d * (6.48 + d * (-32.4 + d * (48.6 + d * -567.0 / 25.0)));
            double d14 = d * ((833.0 + 343.0 * Q) / 300.0 + d * ((-637.0 - 357.0 * Q) / 90.0 + d * ((392.0 + 287.0 * Q) / 60.0 + d * (-49.0 - 49.0 * Q) / 25.0)));
            double d15 = d * ((833.0 - 343.0 * Q) / 300.0 + d * ((-637.0 + 357.0 * Q) / 90.0 + d * ((392.0 - 287.0 * Q) / 60.0 + d * (-49.0 + 49.0 * Q) / 25.0)));
            double d16 = d * (0.3 + d * (-1.0 + d * 0.75));
            for (int i = 0; i < this.interpolatedState.length; ++i) {
                double d17 = this.yDotK[0][i];
                double d18 = this.yDotK[1][i];
                double d19 = this.yDotK[2][i];
                double d20 = this.yDotK[3][i];
                double d21 = this.yDotK[4][i];
                double d22 = this.yDotK[5][i];
                double d23 = this.yDotK[6][i];
                this.interpolatedState[i] = this.previousState[i] + d * this.h * (d10 * d17 + 0.0 * d18 + d12 * d19 + d13 * d20 + d14 * d21 + d15 * d22 + d16 * d23);
                this.interpolatedDerivatives[i] = d3 * d17 + 0.0 * d18 + d5 * d19 + d6 * d20 + d7 * d21 + d8 * d22 + d9 * d23;
            }
        } else {
            double d24 = -0.05 + d * (0.95 + d * (-4.45 + d * (7.55 + d * -21.0 / 5.0)));
            double d25 = 0.0;
            double d26 = -0.35555555555555557 + d * (-0.35555555555555557 + d * (-7.288888888888889 + d * (28.266666666666666 + d * -112.0 / 5.0)));
            double d27 = d * (d * (6.48 + d * (-25.92 + d * 567.0 / 25.0)));
            double d28 = -0.2722222222222222 + d * (-0.2722222222222222 + d * ((2254.0 + 1029.0 * Q) / 900.0 + d * ((-1372.0 - 847.0 * Q) / 300.0 + d * (49.0 + 49.0 * Q) / 25.0)));
            double d29 = -0.2722222222222222 + d * (-0.2722222222222222 + d * ((2254.0 - 1029.0 * Q) / 900.0 + d * ((-1372.0 + 847.0 * Q) / 300.0 + d * (49.0 - 49.0 * Q) / 25.0)));
            double d30 = -0.05 + d * (-0.05 + d * (0.25 + d * -0.75));
            for (int i = 0; i < this.interpolatedState.length; ++i) {
                double d31 = this.yDotK[0][i];
                double d32 = this.yDotK[1][i];
                double d33 = this.yDotK[2][i];
                double d34 = this.yDotK[3][i];
                double d35 = this.yDotK[4][i];
                double d36 = this.yDotK[5][i];
                double d37 = this.yDotK[6][i];
                this.interpolatedState[i] = this.currentState[i] + d2 * (d24 * d31 + 0.0 * d32 + d26 * d33 + d27 * d34 + d28 * d35 + d29 * d36 + d30 * d37);
                this.interpolatedDerivatives[i] = d3 * d31 + 0.0 * d32 + d5 * d33 + d6 * d34 + d7 * d35 + d8 * d36 + d9 * d37;
            }
        }
    }
}

