/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.ode.nonstiff.RungeKuttaStepInterpolator;
import org.apache.commons.math3.ode.sampling.StepInterpolator;

class MidpointStepInterpolator
extends RungeKuttaStepInterpolator {
    private static final long serialVersionUID = 20111120L;

    public MidpointStepInterpolator() {
    }

    MidpointStepInterpolator(MidpointStepInterpolator midpointStepInterpolator) {
        super(midpointStepInterpolator);
    }

    protected StepInterpolator doCopy() {
        return new MidpointStepInterpolator(this);
    }

    protected void computeInterpolatedStateAndDerivatives(double d, double d2) {
        double d3 = 2.0 * d;
        double d4 = 1.0 - d3;
        if (this.previousState != null && d <= 0.5) {
            double d5 = d * d2;
            double d6 = d * d * this.h;
            for (int i = 0; i < this.interpolatedState.length; ++i) {
                double d7 = this.yDotK[0][i];
                double d8 = this.yDotK[1][i];
                this.interpolatedState[i] = this.previousState[i] + d5 * d7 + d6 * d8;
                this.interpolatedDerivatives[i] = d4 * d7 + d3 * d8;
            }
        } else {
            double d9 = d2 * d;
            double d10 = d2 * (1.0 + d);
            for (int i = 0; i < this.interpolatedState.length; ++i) {
                double d11 = this.yDotK[0][i];
                double d12 = this.yDotK[1][i];
                this.interpolatedState[i] = this.currentState[i] + d9 * d11 - d10 * d12;
                this.interpolatedDerivatives[i] = d4 * d11 + d3 * d12;
            }
        }
    }
}

