/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.ode.FieldEquationsMapper;
import org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import org.apache.commons.math3.ode.sampling.AbstractFieldStepInterpolator;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class RungeKuttaFieldStepInterpolator<T extends RealFieldElement<T>>
extends AbstractFieldStepInterpolator<T> {
    private final Field<T> field;
    private final T[][] yDotK;

    protected RungeKuttaFieldStepInterpolator(Field<T> field, boolean bl, T[][] TArray, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative2, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative3, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative4, FieldEquationsMapper<T> fieldEquationsMapper) {
        super(bl, fieldODEStateAndDerivative, fieldODEStateAndDerivative2, fieldODEStateAndDerivative3, fieldODEStateAndDerivative4, fieldEquationsMapper);
        this.field = field;
        this.yDotK = (RealFieldElement[][])MathArrays.buildArray(field, TArray.length, -1);
        for (int i = 0; i < TArray.length; ++i) {
            this.yDotK[i] = (RealFieldElement[])TArray[i].clone();
        }
    }

    @Override
    protected RungeKuttaFieldStepInterpolator<T> create(boolean bl, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative2, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative3, FieldODEStateAndDerivative<T> fieldODEStateAndDerivative4, FieldEquationsMapper<T> fieldEquationsMapper) {
        return this.create(this.field, bl, (RealFieldElement[][])this.yDotK, fieldODEStateAndDerivative, fieldODEStateAndDerivative2, fieldODEStateAndDerivative3, fieldODEStateAndDerivative4, fieldEquationsMapper);
    }

    protected abstract RungeKuttaFieldStepInterpolator<T> create(Field<T> var1, boolean var2, T[][] var3, FieldODEStateAndDerivative<T> var4, FieldODEStateAndDerivative<T> var5, FieldODEStateAndDerivative<T> var6, FieldODEStateAndDerivative<T> var7, FieldEquationsMapper<T> var8);

    protected final T[] previousStateLinearCombination(T ... TArray) {
        return this.combine(this.getPreviousState().getState(), (RealFieldElement[])TArray);
    }

    protected T[] currentStateLinearCombination(T ... TArray) {
        return this.combine(this.getCurrentState().getState(), (RealFieldElement[])TArray);
    }

    protected T[] derivativeLinearCombination(T ... TArray) {
        return this.combine((RealFieldElement[])MathArrays.buildArray(this.field, this.yDotK[0].length), (RealFieldElement[])TArray);
    }

    private T[] combine(T[] TArray, T ... TArray2) {
        for (int i = 0; i < TArray.length; ++i) {
            for (int j = 0; j < TArray2.length; ++j) {
                TArray[i] = (RealFieldElement)TArray[i].add(TArray2[j].multiply(this.yDotK[j][i]));
            }
        }
        return TArray;
    }
}

