/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.commons.math3.ode.AbstractIntegrator;
import org.apache.commons.math3.ode.EquationsMapper;
import org.apache.commons.math3.ode.sampling.AbstractStepInterpolator;

abstract class RungeKuttaStepInterpolator
extends AbstractStepInterpolator {
    protected double[] previousState;
    protected double[][] yDotK;
    protected AbstractIntegrator integrator;

    protected RungeKuttaStepInterpolator() {
        this.previousState = null;
        this.yDotK = null;
        this.integrator = null;
    }

    RungeKuttaStepInterpolator(RungeKuttaStepInterpolator rungeKuttaStepInterpolator) {
        super(rungeKuttaStepInterpolator);
        if (rungeKuttaStepInterpolator.currentState != null) {
            this.previousState = (double[])rungeKuttaStepInterpolator.previousState.clone();
            this.yDotK = new double[rungeKuttaStepInterpolator.yDotK.length][];
            for (int i = 0; i < rungeKuttaStepInterpolator.yDotK.length; ++i) {
                this.yDotK[i] = (double[])rungeKuttaStepInterpolator.yDotK[i].clone();
            }
        } else {
            this.previousState = null;
            this.yDotK = null;
        }
        this.integrator = null;
    }

    public void reinitialize(AbstractIntegrator abstractIntegrator, double[] dArray, double[][] dArray2, boolean bl, EquationsMapper equationsMapper, EquationsMapper[] equationsMapperArray) {
        this.reinitialize(dArray, bl, equationsMapper, equationsMapperArray);
        this.previousState = null;
        this.yDotK = dArray2;
        this.integrator = abstractIntegrator;
    }

    public void shift() {
        this.previousState = (double[])this.currentState.clone();
        super.shift();
    }

    public void writeExternal(ObjectOutput objectOutput) {
        int n;
        this.writeBaseExternal(objectOutput);
        int n2 = this.currentState == null ? -1 : this.currentState.length;
        for (n = 0; n < n2; ++n) {
            objectOutput.writeDouble(this.previousState[n]);
        }
        n = this.yDotK == null ? -1 : this.yDotK.length;
        objectOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                objectOutput.writeDouble(this.yDotK[i][j]);
            }
        }
    }

    public void readExternal(ObjectInput objectInput) {
        int n;
        int n2;
        double d = this.readBaseExternal(objectInput);
        int n3 = n2 = this.currentState == null ? -1 : this.currentState.length;
        if (n2 < 0) {
            this.previousState = null;
        } else {
            this.previousState = new double[n2];
            for (n = 0; n < n2; ++n) {
                this.previousState[n] = objectInput.readDouble();
            }
        }
        n = objectInput.readInt();
        this.yDotK = n < 0 ? (double[][])null : (double[][])new double[n][];
        for (int i = 0; i < n; ++i) {
            this.yDotK[i] = n2 < 0 ? null : new double[n2];
            for (int j = 0; j < n2; ++j) {
                this.yDotK[i][j] = objectInput.readDouble();
            }
        }
        this.integrator = null;
        if (this.currentState != null) {
            this.setInterpolatedTime(d);
        } else {
            this.interpolatedTime = d;
        }
    }
}

