/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.sampling;

import org.apache.commons.math3.ode.sampling.FixedStepHandler;
import org.apache.commons.math3.ode.sampling.StepHandler;
import org.apache.commons.math3.ode.sampling.StepInterpolator;
import org.apache.commons.math3.ode.sampling.StepNormalizerBounds;
import org.apache.commons.math3.ode.sampling.StepNormalizerMode;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

public class StepNormalizer
implements StepHandler {
    private double h;
    private final FixedStepHandler handler;
    private double firstTime;
    private double lastTime;
    private double[] lastState;
    private double[] lastDerivatives;
    private boolean forward;
    private final StepNormalizerBounds bounds;
    private final StepNormalizerMode mode;

    public StepNormalizer(double d, FixedStepHandler fixedStepHandler) {
        this(d, fixedStepHandler, StepNormalizerMode.INCREMENT, StepNormalizerBounds.FIRST);
    }

    public StepNormalizer(double d, FixedStepHandler fixedStepHandler, StepNormalizerMode stepNormalizerMode) {
        this(d, fixedStepHandler, stepNormalizerMode, StepNormalizerBounds.FIRST);
    }

    public StepNormalizer(double d, FixedStepHandler fixedStepHandler, StepNormalizerBounds stepNormalizerBounds) {
        this(d, fixedStepHandler, StepNormalizerMode.INCREMENT, stepNormalizerBounds);
    }

    public StepNormalizer(double d, FixedStepHandler fixedStepHandler, StepNormalizerMode stepNormalizerMode, StepNormalizerBounds stepNormalizerBounds) {
        this.h = FastMath.abs(d);
        this.handler = fixedStepHandler;
        this.mode = stepNormalizerMode;
        this.bounds = stepNormalizerBounds;
        this.firstTime = Double.NaN;
        this.lastTime = Double.NaN;
        this.lastState = null;
        this.lastDerivatives = null;
        this.forward = true;
    }

    public void init(double d, double[] dArray, double d2) {
        this.firstTime = Double.NaN;
        this.lastTime = Double.NaN;
        this.lastState = null;
        this.lastDerivatives = null;
        this.forward = true;
        this.handler.init(d, dArray, d2);
    }

    public void handleStep(StepInterpolator stepInterpolator, boolean bl) {
        double d;
        if (this.lastState == null) {
            this.firstTime = stepInterpolator.getPreviousTime();
            this.lastTime = stepInterpolator.getPreviousTime();
            stepInterpolator.setInterpolatedTime(this.lastTime);
            this.lastState = (double[])stepInterpolator.getInterpolatedState().clone();
            this.lastDerivatives = (double[])stepInterpolator.getInterpolatedDerivatives().clone();
            boolean bl2 = this.forward = stepInterpolator.getCurrentTime() >= this.lastTime;
            if (!this.forward) {
                this.h = -this.h;
            }
        }
        double d2 = d = this.mode == StepNormalizerMode.INCREMENT ? this.lastTime + this.h : (FastMath.floor(this.lastTime / this.h) + 1.0) * this.h;
        if (this.mode == StepNormalizerMode.MULTIPLES && Precision.equals(d, this.lastTime, 1)) {
            d += this.h;
        }
        boolean bl3 = this.isNextInStep(d, stepInterpolator);
        while (bl3) {
            this.doNormalizedStep(false);
            this.storeStep(stepInterpolator, d);
            bl3 = this.isNextInStep(d += this.h, stepInterpolator);
        }
        if (bl) {
            boolean bl4 = this.bounds.lastIncluded() && this.lastTime != stepInterpolator.getCurrentTime();
            this.doNormalizedStep(!bl4);
            if (bl4) {
                this.storeStep(stepInterpolator, stepInterpolator.getCurrentTime());
                this.doNormalizedStep(true);
            }
        }
    }

    private boolean isNextInStep(double d, StepInterpolator stepInterpolator) {
        return this.forward ? d <= stepInterpolator.getCurrentTime() : d >= stepInterpolator.getCurrentTime();
    }

    private void doNormalizedStep(boolean bl) {
        if (!this.bounds.firstIncluded() && this.firstTime == this.lastTime) {
            return;
        }
        this.handler.handleStep(this.lastTime, this.lastState, this.lastDerivatives, bl);
    }

    private void storeStep(StepInterpolator stepInterpolator, double d) {
        this.lastTime = d;
        stepInterpolator.setInterpolatedTime(this.lastTime);
        System.arraycopy(stepInterpolator.getInterpolatedState(), 0, this.lastState, 0, this.lastState.length);
        System.arraycopy(stepInterpolator.getInterpolatedDerivatives(), 0, this.lastDerivatives, 0, this.lastDerivatives.length);
    }
}

