/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim;

import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.optim.BaseMultivariateOptimizer;
import org.apache.commons.math3.optim.InitialGuess;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.random.RandomVectorGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseMultiStartMultivariateOptimizer<PAIR>
extends BaseMultivariateOptimizer<PAIR> {
    private final BaseMultivariateOptimizer<PAIR> optimizer;
    private int totalEvaluations;
    private int starts;
    private RandomVectorGenerator generator;
    private OptimizationData[] optimData;
    private int maxEvalIndex = -1;
    private int initialGuessIndex = -1;

    public BaseMultiStartMultivariateOptimizer(BaseMultivariateOptimizer<PAIR> baseMultivariateOptimizer, int n, RandomVectorGenerator randomVectorGenerator) {
        super(baseMultivariateOptimizer.getConvergenceChecker());
        if (n < 1) {
            throw new NotStrictlyPositiveException(n);
        }
        this.optimizer = baseMultivariateOptimizer;
        this.starts = n;
        this.generator = randomVectorGenerator;
    }

    @Override
    public int getEvaluations() {
        return this.totalEvaluations;
    }

    public abstract PAIR[] getOptima();

    @Override
    public PAIR optimize(OptimizationData ... optimizationDataArray) {
        this.optimData = optimizationDataArray;
        return super.optimize(optimizationDataArray);
    }

    @Override
    protected PAIR doOptimize() {
        for (int i = 0; i < this.optimData.length; ++i) {
            if (this.optimData[i] instanceof MaxEval) {
                this.optimData[i] = null;
                this.maxEvalIndex = i;
            }
            if (!(this.optimData[i] instanceof InitialGuess)) continue;
            this.optimData[i] = null;
            this.initialGuessIndex = i;
        }
        if (this.maxEvalIndex == -1) {
            throw new MathIllegalStateException();
        }
        if (this.initialGuessIndex == -1) {
            throw new MathIllegalStateException();
        }
        RuntimeException runtimeException = null;
        this.totalEvaluations = 0;
        this.clear();
        int n = this.getMaxEvaluations();
        double[] dArray = this.getLowerBound();
        double[] dArray2 = this.getUpperBound();
        double[] dArray3 = this.getStartPoint();
        for (int i = 0; i < this.starts; ++i) {
            try {
                this.optimData[this.maxEvalIndex] = new MaxEval(n - this.totalEvaluations);
                double[] dArray4 = null;
                if (i == 0) {
                    dArray4 = dArray3;
                } else {
                    int n2 = 0;
                    while (dArray4 == null) {
                        if (n2++ >= this.getMaxEvaluations()) {
                            throw new TooManyEvaluationsException(this.getMaxEvaluations());
                        }
                        dArray4 = this.generator.nextVector();
                        for (int j = 0; dArray4 != null && j < dArray4.length; ++j) {
                            if (!(dArray != null && dArray4[j] < dArray[j]) && (dArray2 == null || !(dArray4[j] > dArray2[j]))) continue;
                            dArray4 = null;
                        }
                    }
                }
                this.optimData[this.initialGuessIndex] = new InitialGuess(dArray4);
                PAIR PAIR = this.optimizer.optimize(this.optimData);
                this.store(PAIR);
            }
            catch (RuntimeException runtimeException2) {
                runtimeException = runtimeException2;
            }
            this.totalEvaluations += this.optimizer.getEvaluations();
        }
        PAIR[] PAIRArray = this.getOptima();
        if (PAIRArray.length == 0) {
            throw runtimeException;
        }
        return PAIRArray[0];
    }

    protected abstract void store(PAIR var1);

    protected abstract void clear();
}

