/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim;

import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.optim.BaseOptimizer;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.InitialGuess;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.SimpleBounds;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseMultivariateOptimizer<PAIR>
extends BaseOptimizer<PAIR> {
    private double[] start;
    private double[] lowerBound;
    private double[] upperBound;

    protected BaseMultivariateOptimizer(ConvergenceChecker<PAIR> convergenceChecker) {
        super(convergenceChecker);
    }

    @Override
    public PAIR optimize(OptimizationData ... optimizationDataArray) {
        return super.optimize(optimizationDataArray);
    }

    @Override
    protected void parseOptimizationData(OptimizationData ... optimizationDataArray) {
        super.parseOptimizationData(optimizationDataArray);
        for (OptimizationData optimizationData : optimizationDataArray) {
            if (optimizationData instanceof InitialGuess) {
                this.start = ((InitialGuess)optimizationData).getInitialGuess();
                continue;
            }
            if (!(optimizationData instanceof SimpleBounds)) continue;
            SimpleBounds simpleBounds = (SimpleBounds)optimizationData;
            this.lowerBound = simpleBounds.getLower();
            this.upperBound = simpleBounds.getUpper();
        }
        this.checkParameters();
    }

    public double[] getStartPoint() {
        return this.start == null ? null : (double[])this.start.clone();
    }

    public double[] getLowerBound() {
        return this.lowerBound == null ? null : (double[])this.lowerBound.clone();
    }

    public double[] getUpperBound() {
        return this.upperBound == null ? null : (double[])this.upperBound.clone();
    }

    private void checkParameters() {
        if (this.start != null) {
            double d;
            double d2;
            int n;
            int n2 = this.start.length;
            if (this.lowerBound != null) {
                if (this.lowerBound.length != n2) {
                    throw new DimensionMismatchException(this.lowerBound.length, n2);
                }
                for (n = 0; n < n2; ++n) {
                    d2 = this.start[n];
                    d = this.lowerBound[n];
                    if (!(d2 < d)) continue;
                    throw new NumberIsTooSmallException(d2, (Number)d, true);
                }
            }
            if (this.upperBound != null) {
                if (this.upperBound.length != n2) {
                    throw new DimensionMismatchException(this.upperBound.length, n2);
                }
                for (n = 0; n < n2; ++n) {
                    d2 = this.start[n];
                    d = this.upperBound[n];
                    if (!(d2 > d)) continue;
                    throw new NumberIsTooLargeException(d2, (Number)d, true);
                }
            }
        }
    }
}

