/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.linear;

import java.util.ArrayList;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.linear.LinearOptimizer;
import org.apache.commons.math3.optim.linear.NoFeasibleSolutionException;
import org.apache.commons.math3.optim.linear.PivotSelectionRule;
import org.apache.commons.math3.optim.linear.SimplexTableau;
import org.apache.commons.math3.optim.linear.SolutionCallback;
import org.apache.commons.math3.optim.linear.UnboundedSolutionException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

public class SimplexSolver
extends LinearOptimizer {
    static final int DEFAULT_ULPS = 10;
    static final double DEFAULT_CUT_OFF = 1.0E-10;
    private static final double DEFAULT_EPSILON = 1.0E-6;
    private final double epsilon;
    private final int maxUlps;
    private final double cutOff;
    private PivotSelectionRule pivotSelection;
    private SolutionCallback solutionCallback;

    public SimplexSolver() {
        this(1.0E-6, 10, 1.0E-10);
    }

    public SimplexSolver(double d) {
        this(d, 10, 1.0E-10);
    }

    public SimplexSolver(double d, int n) {
        this(d, n, 1.0E-10);
    }

    public SimplexSolver(double d, int n, double d2) {
        this.epsilon = d;
        this.maxUlps = n;
        this.cutOff = d2;
        this.pivotSelection = PivotSelectionRule.DANTZIG;
    }

    public PointValuePair optimize(OptimizationData ... optimizationDataArray) {
        return super.optimize(optimizationDataArray);
    }

    protected void parseOptimizationData(OptimizationData ... optimizationDataArray) {
        super.parseOptimizationData(optimizationDataArray);
        this.solutionCallback = null;
        for (OptimizationData optimizationData : optimizationDataArray) {
            if (optimizationData instanceof SolutionCallback) {
                this.solutionCallback = (SolutionCallback)optimizationData;
                continue;
            }
            if (!(optimizationData instanceof PivotSelectionRule)) continue;
            this.pivotSelection = (PivotSelectionRule)optimizationData;
        }
    }

    private Integer getPivotColumn(SimplexTableau simplexTableau) {
        double d = 0.0;
        Integer n = null;
        for (int i = simplexTableau.getNumObjectiveFunctions(); i < simplexTableau.getWidth() - 1; ++i) {
            double d2 = simplexTableau.getEntry(0, i);
            if (!(d2 < d)) continue;
            d = d2;
            n = i;
            if (this.pivotSelection == PivotSelectionRule.BLAND && this.isValidPivotColumn(simplexTableau, i)) break;
        }
        return n;
    }

    private boolean isValidPivotColumn(SimplexTableau simplexTableau, int n) {
        for (int i = simplexTableau.getNumObjectiveFunctions(); i < simplexTableau.getHeight(); ++i) {
            double d = simplexTableau.getEntry(i, n);
            if (Precision.compareTo(d, 0.0, this.cutOff) <= 0) continue;
            return true;
        }
        return false;
    }

    private Integer getPivotRow(SimplexTableau simplexTableau, int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        double d = Double.MAX_VALUE;
        for (int i = simplexTableau.getNumObjectiveFunctions(); i < simplexTableau.getHeight(); ++i) {
            double d2 = simplexTableau.getEntry(i, simplexTableau.getWidth() - 1);
            double d3 = simplexTableau.getEntry(i, n);
            if (Precision.compareTo(d3, 0.0, this.cutOff) <= 0) continue;
            double d4 = FastMath.abs(d2 / d3);
            int n2 = Double.compare(d4, d);
            if (n2 == 0) {
                arrayList.add(i);
                continue;
            }
            if (n2 >= 0) continue;
            d = d4;
            arrayList.clear();
            arrayList.add(i);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() > 1) {
            if (simplexTableau.getNumArtificialVariables() > 0) {
                for (Integer n3 : arrayList) {
                    for (int i = 0; i < simplexTableau.getNumArtificialVariables(); ++i) {
                        int n4 = i + simplexTableau.getArtificialVariableOffset();
                        double d5 = simplexTableau.getEntry(n3, n4);
                        if (!Precision.equals(d5, 1.0, this.maxUlps) || !n3.equals(simplexTableau.getBasicRow(n4))) continue;
                        return n3;
                    }
                }
            }
            Integer n5 = null;
            int n6 = simplexTableau.getWidth();
            for (Integer n7 : arrayList) {
                int n8 = simplexTableau.getBasicVariable(n7);
                if (n8 >= n6) continue;
                n6 = n8;
                n5 = n7;
            }
            return n5;
        }
        return (Integer)arrayList.get(0);
    }

    protected void doIteration(SimplexTableau simplexTableau) {
        this.incrementIterationCount();
        Integer n = this.getPivotColumn(simplexTableau);
        Integer n2 = this.getPivotRow(simplexTableau, n);
        if (n2 == null) {
            throw new UnboundedSolutionException();
        }
        simplexTableau.performRowOperations(n, n2);
    }

    protected void solvePhase1(SimplexTableau simplexTableau) {
        if (simplexTableau.getNumArtificialVariables() == 0) {
            return;
        }
        while (!simplexTableau.isOptimal()) {
            this.doIteration(simplexTableau);
        }
        if (!Precision.equals(simplexTableau.getEntry(0, simplexTableau.getRhsOffset()), 0.0, this.epsilon)) {
            throw new NoFeasibleSolutionException();
        }
    }

    public PointValuePair doOptimize() {
        if (this.solutionCallback != null) {
            this.solutionCallback.setTableau(null);
        }
        SimplexTableau simplexTableau = new SimplexTableau(this.getFunction(), this.getConstraints(), this.getGoalType(), this.isRestrictedToNonNegative(), this.epsilon, this.maxUlps);
        this.solvePhase1(simplexTableau);
        simplexTableau.dropPhase1Objective();
        if (this.solutionCallback != null) {
            this.solutionCallback.setTableau(simplexTableau);
        }
        while (!simplexTableau.isOptimal()) {
            this.doIteration(simplexTableau);
        }
        PointValuePair pointValuePair = simplexTableau.getSolution();
        if (this.isRestrictedToNonNegative()) {
            double[] dArray = pointValuePair.getPoint();
            for (int i = 0; i < dArray.length; ++i) {
                if (Precision.compareTo(dArray[i], 0.0, this.epsilon) >= 0) continue;
                throw new NoFeasibleSolutionException();
            }
        }
        return pointValuePair;
    }
}

