/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.nonlinear.scalar;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.MultivariateOptimizer;
import org.apache.commons.math3.optim.univariate.BracketFinder;
import org.apache.commons.math3.optim.univariate.BrentOptimizer;
import org.apache.commons.math3.optim.univariate.SearchInterval;
import org.apache.commons.math3.optim.univariate.SimpleUnivariateValueChecker;
import org.apache.commons.math3.optim.univariate.UnivariateObjectiveFunction;
import org.apache.commons.math3.optim.univariate.UnivariateOptimizer;
import org.apache.commons.math3.optim.univariate.UnivariatePointValuePair;

public class LineSearch {
    private static final double REL_TOL_UNUSED = 1.0E-15;
    private static final double ABS_TOL_UNUSED = Double.MIN_VALUE;
    private final UnivariateOptimizer lineOptimizer;
    private final BracketFinder bracket = new BracketFinder();
    private final double initialBracketingRange;
    private final MultivariateOptimizer mainOptimizer;

    public LineSearch(MultivariateOptimizer multivariateOptimizer, double d, double d2, double d3) {
        this.mainOptimizer = multivariateOptimizer;
        this.lineOptimizer = new BrentOptimizer(1.0E-15, Double.MIN_VALUE, new SimpleUnivariateValueChecker(d, d2));
        this.initialBracketingRange = d3;
    }

    public UnivariatePointValuePair search(final double[] dArray, final double[] dArray2) {
        final int n = dArray.length;
        UnivariateFunction univariateFunction = new UnivariateFunction(){

            public double value(double d) {
                double[] dArray3 = new double[n];
                for (int i = 0; i < n; ++i) {
                    dArray3[i] = dArray[i] + d * dArray2[i];
                }
                double d2 = LineSearch.this.mainOptimizer.computeObjectiveValue(dArray3);
                return d2;
            }
        };
        GoalType goalType = this.mainOptimizer.getGoalType();
        this.bracket.search(univariateFunction, goalType, 0.0, this.initialBracketingRange);
        return this.lineOptimizer.optimize(new MaxEval(Integer.MAX_VALUE), new UnivariateObjectiveFunction(univariateFunction), goalType, new SearchInterval(this.bracket.getLo(), this.bracket.getHi(), this.bracket.getMid()));
    }
}

