/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.nonlinear.scalar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.math3.optim.BaseMultiStartMultivariateOptimizer;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.MultivariateOptimizer;
import org.apache.commons.math3.random.RandomVectorGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiStartMultivariateOptimizer
extends BaseMultiStartMultivariateOptimizer<PointValuePair> {
    private final MultivariateOptimizer optimizer;
    private final List<PointValuePair> optima = new ArrayList<PointValuePair>();

    public MultiStartMultivariateOptimizer(MultivariateOptimizer multivariateOptimizer, int n, RandomVectorGenerator randomVectorGenerator) {
        super(multivariateOptimizer, n, randomVectorGenerator);
        this.optimizer = multivariateOptimizer;
    }

    public PointValuePair[] getOptima() {
        Collections.sort(this.optima, this.getPairComparator());
        return this.optima.toArray(new PointValuePair[0]);
    }

    @Override
    protected void store(PointValuePair pointValuePair) {
        this.optima.add(pointValuePair);
    }

    @Override
    protected void clear() {
        this.optima.clear();
    }

    private Comparator<PointValuePair> getPairComparator() {
        return new Comparator<PointValuePair>(){

            @Override
            public int compare(PointValuePair pointValuePair, PointValuePair pointValuePair2) {
                if (pointValuePair == null) {
                    return pointValuePair2 == null ? 0 : 1;
                }
                if (pointValuePair2 == null) {
                    return -1;
                }
                double d = (Double)pointValuePair.getValue();
                double d2 = (Double)pointValuePair2.getValue();
                return MultiStartMultivariateOptimizer.this.optimizer.getGoalType() == GoalType.MINIMIZE ? Double.compare(d, d2) : Double.compare(d2, d);
            }
        };
    }
}

