/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.nonlinear.scalar;

import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.function.Logit;
import org.apache.commons.math3.analysis.function.Sigmoid;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;

public class MultivariateFunctionMappingAdapter
implements MultivariateFunction {
    private final MultivariateFunction bounded;
    private final Mapper[] mappers;

    public MultivariateFunctionMappingAdapter(MultivariateFunction multivariateFunction, double[] dArray, double[] dArray2) {
        int n;
        MathUtils.checkNotNull(dArray);
        MathUtils.checkNotNull(dArray2);
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        for (n = 0; n < dArray.length; ++n) {
            if (dArray2[n] >= dArray[n]) continue;
            throw new NumberIsTooSmallException(dArray2[n], (Number)dArray[n], true);
        }
        this.bounded = multivariateFunction;
        this.mappers = new Mapper[dArray.length];
        for (n = 0; n < this.mappers.length; ++n) {
            if (Double.isInfinite(dArray[n])) {
                if (Double.isInfinite(dArray2[n])) {
                    this.mappers[n] = new NoBoundsMapper();
                    continue;
                }
                this.mappers[n] = new UpperBoundMapper(dArray2[n]);
                continue;
            }
            this.mappers[n] = Double.isInfinite(dArray2[n]) ? new LowerBoundMapper(dArray[n]) : new LowerUpperBoundMapper(dArray[n], dArray2[n]);
        }
    }

    public double[] unboundedToBounded(double[] dArray) {
        double[] dArray2 = new double[this.mappers.length];
        for (int i = 0; i < this.mappers.length; ++i) {
            dArray2[i] = this.mappers[i].unboundedToBounded(dArray[i]);
        }
        return dArray2;
    }

    public double[] boundedToUnbounded(double[] dArray) {
        double[] dArray2 = new double[this.mappers.length];
        for (int i = 0; i < this.mappers.length; ++i) {
            dArray2[i] = this.mappers[i].boundedToUnbounded(dArray[i]);
        }
        return dArray2;
    }

    public double value(double[] dArray) {
        return this.bounded.value(this.unboundedToBounded(dArray));
    }

    private static class LowerUpperBoundMapper
    implements Mapper {
        private final UnivariateFunction boundingFunction;
        private final UnivariateFunction unboundingFunction;

        LowerUpperBoundMapper(double d, double d2) {
            this.boundingFunction = new Sigmoid(d, d2);
            this.unboundingFunction = new Logit(d, d2);
        }

        public double unboundedToBounded(double d) {
            return this.boundingFunction.value(d);
        }

        public double boundedToUnbounded(double d) {
            return this.unboundingFunction.value(d);
        }
    }

    private static class UpperBoundMapper
    implements Mapper {
        private final double upper;

        UpperBoundMapper(double d) {
            this.upper = d;
        }

        public double unboundedToBounded(double d) {
            return this.upper - FastMath.exp(-d);
        }

        public double boundedToUnbounded(double d) {
            return -FastMath.log(this.upper - d);
        }
    }

    private static class LowerBoundMapper
    implements Mapper {
        private final double lower;

        LowerBoundMapper(double d) {
            this.lower = d;
        }

        public double unboundedToBounded(double d) {
            return this.lower + FastMath.exp(d);
        }

        public double boundedToUnbounded(double d) {
            return FastMath.log(d - this.lower);
        }
    }

    private static class NoBoundsMapper
    implements Mapper {
        private NoBoundsMapper() {
        }

        public double unboundedToBounded(double d) {
            return d;
        }

        public double boundedToUnbounded(double d) {
            return d;
        }
    }

    private static interface Mapper {
        public double unboundedToBounded(double var1);

        public double boundedToUnbounded(double var1);
    }
}

