/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.nonlinear.scalar.noderiv;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.ZeroException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSimplex
implements OptimizationData {
    private PointValuePair[] simplex;
    private double[][] startConfiguration;
    private final int dimension;

    protected AbstractSimplex(int n) {
        this(n, 1.0);
    }

    protected AbstractSimplex(int n, double d) {
        this(AbstractSimplex.createHypercubeSteps(n, d));
    }

    protected AbstractSimplex(double[] dArray) {
        if (dArray == null) {
            throw new NullArgumentException();
        }
        if (dArray.length == 0) {
            throw new ZeroException();
        }
        this.dimension = dArray.length;
        this.startConfiguration = new double[this.dimension][this.dimension];
        for (int i = 0; i < this.dimension; ++i) {
            double[] dArray2 = this.startConfiguration[i];
            for (int j = 0; j < i + 1; ++j) {
                if (dArray[j] == 0.0) {
                    throw new ZeroException((Localizable)LocalizedFormats.EQUAL_VERTICES_IN_SIMPLEX, new Object[0]);
                }
                System.arraycopy(dArray, 0, dArray2, 0, j + 1);
            }
        }
    }

    protected AbstractSimplex(double[][] dArray) {
        if (dArray.length <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.SIMPLEX_NEED_ONE_POINT, dArray.length);
        }
        this.dimension = dArray.length - 1;
        this.startConfiguration = new double[this.dimension][this.dimension];
        double[] dArray2 = dArray[0];
        for (int i = 0; i < dArray.length; ++i) {
            double[] dArray3 = dArray[i];
            if (dArray3.length != this.dimension) {
                throw new DimensionMismatchException(dArray3.length, this.dimension);
            }
            for (int j = 0; j < i; ++j) {
                double[] dArray4 = dArray[j];
                boolean bl = true;
                for (int k = 0; k < this.dimension; ++k) {
                    if (dArray3[k] == dArray4[k]) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                throw new MathIllegalArgumentException(LocalizedFormats.EQUAL_VERTICES_IN_SIMPLEX, i, j);
            }
            if (i <= 0) continue;
            double[] dArray5 = this.startConfiguration[i - 1];
            for (int j = 0; j < this.dimension; ++j) {
                dArray5[j] = dArray3[j] - dArray2[j];
            }
        }
    }

    public int getDimension() {
        return this.dimension;
    }

    public int getSize() {
        return this.simplex.length;
    }

    public abstract void iterate(MultivariateFunction var1, Comparator<PointValuePair> var2);

    public void build(double[] dArray) {
        if (this.dimension != dArray.length) {
            throw new DimensionMismatchException(this.dimension, dArray.length);
        }
        this.simplex = new PointValuePair[this.dimension + 1];
        this.simplex[0] = new PointValuePair(dArray, Double.NaN);
        for (int i = 0; i < this.dimension; ++i) {
            double[] dArray2 = this.startConfiguration[i];
            double[] dArray3 = new double[this.dimension];
            for (int j = 0; j < this.dimension; ++j) {
                dArray3[j] = dArray[j] + dArray2[j];
            }
            this.simplex[i + 1] = new PointValuePair(dArray3, Double.NaN);
        }
    }

    public void evaluate(MultivariateFunction multivariateFunction, Comparator<PointValuePair> comparator) {
        for (int i = 0; i < this.simplex.length; ++i) {
            PointValuePair pointValuePair = this.simplex[i];
            double[] dArray = pointValuePair.getPointRef();
            if (!Double.isNaN((Double)pointValuePair.getValue())) continue;
            this.simplex[i] = new PointValuePair(dArray, multivariateFunction.value(dArray), false);
        }
        Arrays.sort(this.simplex, comparator);
    }

    protected void replaceWorstPoint(PointValuePair pointValuePair, Comparator<PointValuePair> comparator) {
        for (int i = 0; i < this.dimension; ++i) {
            if (comparator.compare(this.simplex[i], pointValuePair) <= 0) continue;
            PointValuePair pointValuePair2 = this.simplex[i];
            this.simplex[i] = pointValuePair;
            pointValuePair = pointValuePair2;
        }
        this.simplex[this.dimension] = pointValuePair;
    }

    public PointValuePair[] getPoints() {
        PointValuePair[] pointValuePairArray = new PointValuePair[this.simplex.length];
        System.arraycopy(this.simplex, 0, pointValuePairArray, 0, this.simplex.length);
        return pointValuePairArray;
    }

    public PointValuePair getPoint(int n) {
        if (n < 0 || n >= this.simplex.length) {
            throw new OutOfRangeException(n, (Number)0, this.simplex.length - 1);
        }
        return this.simplex[n];
    }

    protected void setPoint(int n, PointValuePair pointValuePair) {
        if (n < 0 || n >= this.simplex.length) {
            throw new OutOfRangeException(n, (Number)0, this.simplex.length - 1);
        }
        this.simplex[n] = pointValuePair;
    }

    protected void setPoints(PointValuePair[] pointValuePairArray) {
        if (pointValuePairArray.length != this.simplex.length) {
            throw new DimensionMismatchException(pointValuePairArray.length, this.simplex.length);
        }
        this.simplex = pointValuePairArray;
    }

    private static double[] createHypercubeSteps(int n, double d) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = d;
        }
        return dArray;
    }
}

