/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.nonlinear.scalar.noderiv;

import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.MultivariateOptimizer;
import org.apache.commons.math3.util.FastMath;

public class BOBYQAOptimizer
extends MultivariateOptimizer {
    public static final int MINIMUM_PROBLEM_DIMENSION = 2;
    public static final double DEFAULT_INITIAL_RADIUS = 10.0;
    public static final double DEFAULT_STOPPING_RADIUS = 1.0E-8;
    private static final double ZERO = 0.0;
    private static final double ONE = 1.0;
    private static final double TWO = 2.0;
    private static final double TEN = 10.0;
    private static final double SIXTEEN = 16.0;
    private static final double TWO_HUNDRED_FIFTY = 250.0;
    private static final double MINUS_ONE = -1.0;
    private static final double HALF = 0.5;
    private static final double ONE_OVER_FOUR = 0.25;
    private static final double ONE_OVER_EIGHT = 0.125;
    private static final double ONE_OVER_TEN = 0.1;
    private static final double ONE_OVER_A_THOUSAND = 0.001;
    private final int numberOfInterpolationPoints;
    private double initialTrustRegionRadius;
    private final double stoppingTrustRegionRadius;
    private boolean isMinimize;
    private ArrayRealVector currentBest;
    private double[] boundDifference;
    private int trustRegionCenterInterpolationPointIndex;
    private Array2DRowRealMatrix bMatrix;
    private Array2DRowRealMatrix zMatrix;
    private Array2DRowRealMatrix interpolationPoints;
    private ArrayRealVector originShift;
    private ArrayRealVector fAtInterpolationPoints;
    private ArrayRealVector trustRegionCenterOffset;
    private ArrayRealVector gradientAtTrustRegionCenter;
    private ArrayRealVector lowerDifference;
    private ArrayRealVector upperDifference;
    private ArrayRealVector modelSecondDerivativesParameters;
    private ArrayRealVector newPoint;
    private ArrayRealVector alternativeNewPoint;
    private ArrayRealVector trialStepPoint;
    private ArrayRealVector lagrangeValuesAtNewPoint;
    private ArrayRealVector modelSecondDerivativesValues;

    public BOBYQAOptimizer(int n) {
        this(n, 10.0, 1.0E-8);
    }

    public BOBYQAOptimizer(int n, double d, double d2) {
        super((ConvergenceChecker<PointValuePair>)null);
        this.numberOfInterpolationPoints = n;
        this.initialTrustRegionRadius = d;
        this.stoppingTrustRegionRadius = d2;
    }

    protected PointValuePair doOptimize() {
        double[] dArray = this.getLowerBound();
        double[] dArray2 = this.getUpperBound();
        this.setup(dArray, dArray2);
        this.isMinimize = this.getGoalType() == GoalType.MINIMIZE;
        this.currentBest = new ArrayRealVector(this.getStartPoint());
        double d = this.bobyqa(dArray, dArray2);
        return new PointValuePair(this.currentBest.getDataRef(), this.isMinimize ? d : -d);
    }

    private double bobyqa(double[] dArray, double[] dArray2) {
        BOBYQAOptimizer.printMethod();
        int n = this.currentBest.getDimension();
        for (int i = 0; i < n; ++i) {
            double d;
            double d2 = this.boundDifference[i];
            this.lowerDifference.setEntry(i, dArray[i] - this.currentBest.getEntry(i));
            this.upperDifference.setEntry(i, dArray2[i] - this.currentBest.getEntry(i));
            if (this.lowerDifference.getEntry(i) >= -this.initialTrustRegionRadius) {
                if (this.lowerDifference.getEntry(i) >= 0.0) {
                    this.currentBest.setEntry(i, dArray[i]);
                    this.lowerDifference.setEntry(i, 0.0);
                    this.upperDifference.setEntry(i, d2);
                    continue;
                }
                this.currentBest.setEntry(i, dArray[i] + this.initialTrustRegionRadius);
                this.lowerDifference.setEntry(i, -this.initialTrustRegionRadius);
                d = dArray2[i] - this.currentBest.getEntry(i);
                this.upperDifference.setEntry(i, FastMath.max(d, this.initialTrustRegionRadius));
                continue;
            }
            if (!(this.upperDifference.getEntry(i) <= this.initialTrustRegionRadius)) continue;
            if (this.upperDifference.getEntry(i) <= 0.0) {
                this.currentBest.setEntry(i, dArray2[i]);
                this.lowerDifference.setEntry(i, -d2);
                this.upperDifference.setEntry(i, 0.0);
                continue;
            }
            this.currentBest.setEntry(i, dArray2[i] - this.initialTrustRegionRadius);
            d = dArray[i] - this.currentBest.getEntry(i);
            double d3 = -this.initialTrustRegionRadius;
            this.lowerDifference.setEntry(i, FastMath.min(d, d3));
            this.upperDifference.setEntry(i, this.initialTrustRegionRadius);
        }
        return this.bobyqb(dArray, dArray2);
    }

    /*
     * Unable to fully structure code
     */
    private double bobyqb(double[] var1_1, double[] var2_2) {
        BOBYQAOptimizer.printMethod();
        var3_3 = this.currentBest.getDimension();
        var4_4 = this.numberOfInterpolationPoints;
        var5_5 = var3_3 + 1;
        var6_6 = var4_4 - var5_5;
        var7_7 = var3_3 * var5_5 / 2;
        var8_8 = new ArrayRealVector(var3_3);
        var9_9 = new ArrayRealVector(var4_4);
        var10_10 = new ArrayRealVector(var4_4);
        var11_11 = NaN;
        var13_12 = NaN;
        var15_13 = NaN;
        var17_14 = NaN;
        this.trustRegionCenterInterpolationPointIndex = 0;
        this.prelim(var1_1, var2_2);
        var19_15 = 0.0;
        for (var21_16 = 0; var21_16 < var3_3; ++var21_16) {
            this.trustRegionCenterOffset.setEntry(var21_16, this.interpolationPoints.getEntry(this.trustRegionCenterInterpolationPointIndex, var21_16));
            var22_18 = this.trustRegionCenterOffset.getEntry(var21_16);
            var19_15 += var22_18 * var22_18;
        }
        var21_17 = this.fAtInterpolationPoints.getEntry(0);
        var23_19 = false;
        var24_20 = 0;
        var25_21 = 0;
        var26_22 = 0;
        var27_23 = this.getEvaluations();
        var30_25 = var28_24 = this.initialTrustRegionRadius;
        var32_26 = 0.0;
        var34_27 = 0.0;
        var36_28 = 0.0;
        var38_29 = 0.0;
        var40_30 = 0.0;
        var42_31 = 0.0;
        var44_32 = 0.0;
        var46_33 = 0.0;
        var48_34 = 0.0;
        var50_35 = 0.0;
        var52_36 = 0.0;
        var54_37 = 0.0;
        var56_38 = 20;
        block12: while (true) {
            switch (var56_38) {
                case 20: {
                    BOBYQAOptimizer.printState(20);
                    if (this.trustRegionCenterInterpolationPointIndex != 0) {
                        var57_39 = 0;
                        for (var58_50 = 0; var58_50 < var3_3; ++var58_50) {
                            for (var59_58 = 0; var59_58 <= var58_50; ++var59_58) {
                                if (var59_58 < var58_50) {
                                    this.gradientAtTrustRegionCenter.setEntry(var58_50, this.gradientAtTrustRegionCenter.getEntry(var58_50) + this.modelSecondDerivativesValues.getEntry(var57_39) * this.trustRegionCenterOffset.getEntry(var59_58));
                                }
                                this.gradientAtTrustRegionCenter.setEntry(var59_58, this.gradientAtTrustRegionCenter.getEntry(var59_58) + this.modelSecondDerivativesValues.getEntry(var57_39) * this.trustRegionCenterOffset.getEntry(var58_50));
                                ++var57_39;
                            }
                        }
                        if (this.getEvaluations() > var4_4) {
                            for (var58_50 = 0; var58_50 < var4_4; ++var58_50) {
                                var59_59 = 0.0;
                                for (var61_71 = 0; var61_71 < var3_3; ++var61_71) {
                                    var59_59 += this.interpolationPoints.getEntry(var58_50, var61_71) * this.trustRegionCenterOffset.getEntry(var61_71);
                                }
                                var59_59 *= this.modelSecondDerivativesParameters.getEntry(var58_50);
                                for (var61_71 = 0; var61_71 < var3_3; ++var61_71) {
                                    this.gradientAtTrustRegionCenter.setEntry(var61_71, this.gradientAtTrustRegionCenter.getEntry(var61_71) + var59_59 * this.interpolationPoints.getEntry(var58_50, var61_71));
                                }
                            }
                        }
                    }
                }
                case 60: {
                    BOBYQAOptimizer.printState(60);
                    var57_40 = new ArrayRealVector(var3_3);
                    var58_51 = new ArrayRealVector(var3_3);
                    var59_60 = new ArrayRealVector(var3_3);
                    var60_65 = new ArrayRealVector(var3_3);
                    var61_72 = new ArrayRealVector(var3_3);
                    var62_79 = this.trsbox(var30_25, var57_40, var58_51, var59_60, var60_65, var61_72);
                    var15_13 = var62_79[0];
                    var17_14 = var62_79[1];
                    var63_89 = var30_25;
                    var65_103 = FastMath.sqrt(var15_13);
                    var48_34 = FastMath.min(var63_89, var65_103);
                    if (var48_34 < 0.5 * var28_24) {
                        var24_20 = -1;
                        var63_89 = 10.0 * var28_24;
                        var54_37 = var63_89 * var63_89;
                        if (this.getEvaluations() <= var27_23 + 2) {
                            var56_38 = 650;
                            continue block12;
                        }
                        var63_89 = FastMath.max(var32_26, var34_27);
                        var67_112 = FastMath.max(var63_89, var36_28);
                        var69_121 = var28_24 * 0.125 * var28_24;
                        if (var17_14 > 0.0 && var67_112 > var69_121 * var17_14) {
                            var56_38 = 650;
                            continue block12;
                        }
                        var71_135 = var67_112 / var28_24;
                        for (var73_142 = 0; var73_142 < var3_3; ++var73_142) {
                            var74_145 = var71_135;
                            if (this.newPoint.getEntry(var73_142) == this.lowerDifference.getEntry(var73_142)) {
                                var74_145 = var8_8.getEntry(var73_142);
                            }
                            if (this.newPoint.getEntry(var73_142) == this.upperDifference.getEntry(var73_142)) {
                                var74_145 = -var8_8.getEntry(var73_142);
                            }
                            if (!(var74_145 < var71_135)) continue;
                            var76_148 = this.modelSecondDerivativesValues.getEntry((var73_142 + var73_142 * var73_142) / 2);
                            for (var78_149 = 0; var78_149 < var4_4; ++var78_149) {
                                var79_152 = this.interpolationPoints.getEntry(var78_149, var73_142);
                                var76_148 += this.modelSecondDerivativesParameters.getEntry(var78_149) * (var79_152 * var79_152);
                            }
                            if (!((var74_145 += 0.5 * var76_148 * var28_24) < var71_135)) continue;
                            var56_38 = 650;
                            break;
                        }
                        var56_38 = 680;
                        continue block12;
                    }
                    ++var24_20;
                }
                case 90: {
                    BOBYQAOptimizer.printState(90);
                    if (var15_13 <= var19_15 * 0.001) {
                        var57_41 = var19_15 * 0.25;
                        var59_61 = 0.0;
                        for (var61_73 = 0; var61_73 < var4_4; ++var61_73) {
                            var59_61 += this.modelSecondDerivativesParameters.getEntry(var61_73);
                            var62_80 = -0.5 * var19_15;
                            for (var64_95 = 0; var64_95 < var3_3; ++var64_95) {
                                var62_80 += this.interpolationPoints.getEntry(var61_73, var64_95) * this.trustRegionCenterOffset.getEntry(var64_95);
                            }
                            var9_9.setEntry(var61_73, var62_80);
                            var64_96 = var57_41 - 0.5 * var62_80;
                            for (var66_104 = 0; var66_104 < var3_3; ++var66_104) {
                                var8_8.setEntry(var66_104, this.bMatrix.getEntry(var61_73, var66_104));
                                this.lagrangeValuesAtNewPoint.setEntry(var66_104, var62_80 * this.interpolationPoints.getEntry(var61_73, var66_104) + var64_96 * this.trustRegionCenterOffset.getEntry(var66_104));
                                var67_113 = var4_4 + var66_104;
                                for (var68_118 = 0; var68_118 <= var66_104; ++var68_118) {
                                    this.bMatrix.setEntry(var67_113, var68_118, this.bMatrix.getEntry(var67_113, var68_118) + var8_8.getEntry(var66_104) * this.lagrangeValuesAtNewPoint.getEntry(var68_118) + this.lagrangeValuesAtNewPoint.getEntry(var66_104) * var8_8.getEntry(var68_118));
                                }
                            }
                        }
                        for (var61_73 = 0; var61_73 < var6_6; ++var61_73) {
                            var62_81 = 0.0;
                            var64_97 = 0.0;
                            for (var66_104 = 0; var66_104 < var4_4; ++var66_104) {
                                var62_81 += this.zMatrix.getEntry(var66_104, var61_73);
                                this.lagrangeValuesAtNewPoint.setEntry(var66_104, var9_9.getEntry(var66_104) * this.zMatrix.getEntry(var66_104, var61_73));
                                var64_97 += this.lagrangeValuesAtNewPoint.getEntry(var66_104);
                            }
                            for (var66_104 = 0; var66_104 < var3_3; ++var66_104) {
                                var67_114 = (var57_41 * var62_81 - 0.5 * var64_97) * this.trustRegionCenterOffset.getEntry(var66_104);
                                for (var69_122 = 0; var69_122 < var4_4; ++var69_122) {
                                    var67_114 += this.lagrangeValuesAtNewPoint.getEntry(var69_122) * this.interpolationPoints.getEntry(var69_122, var66_104);
                                }
                                var8_8.setEntry(var66_104, var67_114);
                                for (var69_122 = 0; var69_122 < var4_4; ++var69_122) {
                                    this.bMatrix.setEntry(var69_122, var66_104, this.bMatrix.getEntry(var69_122, var66_104) + var67_114 * this.zMatrix.getEntry(var69_122, var61_73));
                                }
                            }
                            for (var66_104 = 0; var66_104 < var3_3; ++var66_104) {
                                var67_115 = var66_104 + var4_4;
                                var68_119 = var8_8.getEntry(var66_104);
                                for (var70_131 = 0; var70_131 <= var66_104; ++var70_131) {
                                    this.bMatrix.setEntry(var67_115, var70_131, this.bMatrix.getEntry(var67_115, var70_131) + var68_119 * var8_8.getEntry(var70_131));
                                }
                            }
                        }
                        var61_73 = 0;
                        for (var62_82 = 0; var62_82 < var3_3; ++var62_82) {
                            var8_8.setEntry(var62_82, -0.5 * var59_61 * this.trustRegionCenterOffset.getEntry(var62_82));
                            for (var63_90 = 0; var63_90 < var4_4; ++var63_90) {
                                var8_8.setEntry(var62_82, var8_8.getEntry(var62_82) + this.modelSecondDerivativesParameters.getEntry(var63_90) * this.interpolationPoints.getEntry(var63_90, var62_82));
                                this.interpolationPoints.setEntry(var63_90, var62_82, this.interpolationPoints.getEntry(var63_90, var62_82) - this.trustRegionCenterOffset.getEntry(var62_82));
                            }
                            for (var63_90 = 0; var63_90 <= var62_82; ++var63_90) {
                                this.modelSecondDerivativesValues.setEntry(var61_73, this.modelSecondDerivativesValues.getEntry(var61_73) + var8_8.getEntry(var63_90) * this.trustRegionCenterOffset.getEntry(var62_82) + this.trustRegionCenterOffset.getEntry(var63_90) * var8_8.getEntry(var62_82));
                                this.bMatrix.setEntry(var4_4 + var63_90, var62_82, this.bMatrix.getEntry(var4_4 + var62_82, var63_90));
                                ++var61_73;
                            }
                        }
                        for (var62_82 = 0; var62_82 < var3_3; ++var62_82) {
                            this.originShift.setEntry(var62_82, this.originShift.getEntry(var62_82) + this.trustRegionCenterOffset.getEntry(var62_82));
                            this.newPoint.setEntry(var62_82, this.newPoint.getEntry(var62_82) - this.trustRegionCenterOffset.getEntry(var62_82));
                            this.lowerDifference.setEntry(var62_82, this.lowerDifference.getEntry(var62_82) - this.trustRegionCenterOffset.getEntry(var62_82));
                            this.upperDifference.setEntry(var62_82, this.upperDifference.getEntry(var62_82) - this.trustRegionCenterOffset.getEntry(var62_82));
                            this.trustRegionCenterOffset.setEntry(var62_82, 0.0);
                        }
                        var19_15 = 0.0;
                    }
                    if (var24_20 == 0) {
                        var56_38 = 210;
                        continue block12;
                    }
                    var56_38 = 230;
                    continue block12;
                }
                case 210: {
                    BOBYQAOptimizer.printState(210);
                    var57_42 = this.altmov(var26_22, var42_31);
                    var13_12 = var57_42[0];
                    var11_11 = var57_42[1];
                    for (var58_52 = 0; var58_52 < var3_3; ++var58_52) {
                        this.trialStepPoint.setEntry(var58_52, this.newPoint.getEntry(var58_52) - this.trustRegionCenterOffset.getEntry(var58_52));
                    }
                }
                case 230: {
                    BOBYQAOptimizer.printState(230);
                    for (var57_43 = 0; var57_43 < var4_4; ++var57_43) {
                        var58_53 = 0.0;
                        var60_66 = 0.0;
                        var62_83 = 0.0;
                        for (var64_98 = 0; var64_98 < var3_3; ++var64_98) {
                            var58_53 += this.interpolationPoints.getEntry(var57_43, var64_98) * this.trialStepPoint.getEntry(var64_98);
                            var60_66 += this.interpolationPoints.getEntry(var57_43, var64_98) * this.trustRegionCenterOffset.getEntry(var64_98);
                            var62_83 += this.bMatrix.getEntry(var57_43, var64_98) * this.trialStepPoint.getEntry(var64_98);
                        }
                        var10_10.setEntry(var57_43, var58_53 * (0.5 * var58_53 + var60_66));
                        this.lagrangeValuesAtNewPoint.setEntry(var57_43, var62_83);
                        var9_9.setEntry(var57_43, var58_53);
                    }
                    var40_30 = 0.0;
                    for (var57_43 = 0; var57_43 < var6_6; ++var57_43) {
                        var58_54 = 0.0;
                        for (var60_67 = 0; var60_67 < var4_4; ++var60_67) {
                            var58_54 += this.zMatrix.getEntry(var60_67, var57_43) * var10_10.getEntry(var60_67);
                        }
                        var40_30 -= var58_54 * var58_54;
                        for (var60_67 = 0; var60_67 < var4_4; ++var60_67) {
                            this.lagrangeValuesAtNewPoint.setEntry(var60_67, this.lagrangeValuesAtNewPoint.getEntry(var60_67) + var58_54 * this.zMatrix.getEntry(var60_67, var57_43));
                        }
                    }
                    var15_13 = 0.0;
                    var57_44 = 0.0;
                    var59_62 = 0.0;
                    for (var61_74 = 0; var61_74 < var3_3; ++var61_74) {
                        var62_84 = this.trialStepPoint.getEntry(var61_74);
                        var15_13 += var62_84 * var62_84;
                        var64_99 = 0.0;
                        for (var66_105 = 0; var66_105 < var4_4; ++var66_105) {
                            var64_99 += var10_10.getEntry(var66_105) * this.bMatrix.getEntry(var66_105, var61_74);
                        }
                        var57_44 += var64_99 * this.trialStepPoint.getEntry(var61_74);
                        var66_105 = var4_4 + var61_74;
                        for (var67_116 = 0; var67_116 < var3_3; ++var67_116) {
                            var64_99 += this.bMatrix.getEntry(var66_105, var67_116) * this.trialStepPoint.getEntry(var67_116);
                        }
                        this.lagrangeValuesAtNewPoint.setEntry(var66_105, var64_99);
                        var57_44 += var64_99 * this.trialStepPoint.getEntry(var61_74);
                        var59_62 += this.trialStepPoint.getEntry(var61_74) * this.trustRegionCenterOffset.getEntry(var61_74);
                    }
                    var40_30 = var59_62 * var59_62 + var15_13 * (var19_15 + var59_62 + var59_62 + 0.5 * var15_13) + var40_30 - var57_44;
                    this.lagrangeValuesAtNewPoint.setEntry(this.trustRegionCenterInterpolationPointIndex, this.lagrangeValuesAtNewPoint.getEntry(this.trustRegionCenterInterpolationPointIndex) + 1.0);
                    if (var24_20 != 0) ** GOTO lbl253
                    var61_75 = this.lagrangeValuesAtNewPoint.getEntry(var26_22);
                    var44_32 = var61_75 * var61_75 + var13_12 * var40_30;
                    if (var44_32 < var11_11 && var11_11 > 0.0) {
                        for (var63_91 = 0; var63_91 < var3_3; ++var63_91) {
                            this.newPoint.setEntry(var63_91, this.alternativeNewPoint.getEntry(var63_91));
                            this.trialStepPoint.setEntry(var63_91, this.newPoint.getEntry(var63_91) - this.trustRegionCenterOffset.getEntry(var63_91));
                        }
                        var11_11 = 0.0;
                        var56_38 = 230;
                        continue block12;
                    }
                    ** GOTO lbl280
lbl253:
                    // 1 sources

                    var61_76 = var30_25 * var30_25;
                    var50_35 = 0.0;
                    var52_36 = 0.0;
                    var26_22 = 0;
                    for (var63_92 = 0; var63_92 < var4_4; ++var63_92) {
                        if (var63_92 == this.trustRegionCenterInterpolationPointIndex) continue;
                        var64_100 = 0.0;
                        for (var66_106 = 0; var66_106 < var6_6; ++var66_106) {
                            var67_117 = this.zMatrix.getEntry(var63_92, var66_106);
                            var64_100 += var67_117 * var67_117;
                        }
                        var66_107 = this.lagrangeValuesAtNewPoint.getEntry(var63_92);
                        var68_120 = var40_30 * var64_100 + var66_107 * var66_107;
                        var54_37 = 0.0;
                        for (var70_132 = 0; var70_132 < var3_3; ++var70_132) {
                            var71_135 = this.interpolationPoints.getEntry(var63_92, var70_132) - this.trustRegionCenterOffset.getEntry(var70_132);
                            var54_37 += var71_135 * var71_135;
                        }
                        var70_133 = var54_37 / var61_76;
                        var72_141 = FastMath.max(1.0, var70_133 * var70_133);
                        if (var72_141 * var68_120 > var50_35) {
                            var50_35 = var72_141 * var68_120;
                            var26_22 = var63_92;
                            var44_32 = var68_120;
                        }
                        var74_145 = this.lagrangeValuesAtNewPoint.getEntry(var63_92);
                        var52_36 = FastMath.max(var52_36, var72_141 * (var74_145 * var74_145));
                    }
                }
lbl280:
                // 3 sources

                case 360: {
                    BOBYQAOptimizer.printState(360);
                    for (var57_45 = 0; var57_45 < var3_3; ++var57_45) {
                        var58_55 = var1_1[var57_45];
                        var60_68 = this.originShift.getEntry(var57_45) + this.newPoint.getEntry(var57_45);
                        var62_85 = FastMath.max(var58_55, var60_68);
                        var64_97 = var2_2[var57_45];
                        this.currentBest.setEntry(var57_45, FastMath.min(var62_85, var64_97));
                        if (this.newPoint.getEntry(var57_45) == this.lowerDifference.getEntry(var57_45)) {
                            this.currentBest.setEntry(var57_45, var1_1[var57_45]);
                        }
                        if (this.newPoint.getEntry(var57_45) != this.upperDifference.getEntry(var57_45)) continue;
                        this.currentBest.setEntry(var57_45, var2_2[var57_45]);
                    }
                    var38_29 = this.computeObjectiveValue(this.currentBest.toArray());
                    if (!this.isMinimize) {
                        var38_29 = -var38_29;
                    }
                    if (var24_20 == -1) {
                        var21_17 = var38_29;
                        var56_38 = 720;
                        continue block12;
                    }
                    var57_46 = this.fAtInterpolationPoints.getEntry(this.trustRegionCenterInterpolationPointIndex);
                    var59_63 = 0.0;
                    var61_77 = 0;
                    for (var62_86 = 0; var62_86 < var3_3; ++var62_86) {
                        var59_63 += this.trialStepPoint.getEntry(var62_86) * this.gradientAtTrustRegionCenter.getEntry(var62_86);
                        for (var63_93 = 0; var63_93 <= var62_86; ++var63_93) {
                            var64_101 = this.trialStepPoint.getEntry(var63_93) * this.trialStepPoint.getEntry(var62_86);
                            if (var63_93 == var62_86) {
                                var64_101 *= 0.5;
                            }
                            var59_63 += this.modelSecondDerivativesValues.getEntry(var61_77) * var64_101;
                            ++var61_77;
                        }
                    }
                    for (var62_86 = 0; var62_86 < var4_4; ++var62_86) {
                        var63_94 = var9_9.getEntry(var62_86);
                        var65_103 = var63_94 * var63_94;
                        var59_63 += 0.5 * this.modelSecondDerivativesParameters.getEntry(var62_86) * var65_103;
                    }
                    var62_87 = var38_29 - var57_46 - var59_63;
                    var36_28 = var34_27;
                    var34_27 = var32_26;
                    var32_26 = FastMath.abs(var62_87);
                    if (var48_34 > var28_24) {
                        var27_23 = this.getEvaluations();
                    }
                    if (var24_20 > 0) {
                        if (var59_63 >= 0.0) {
                            throw new MathIllegalStateException(LocalizedFormats.TRUST_REGION_STEP_FAILED, new Object[]{var59_63});
                        }
                        var46_33 = (var38_29 - var57_46) / var59_63;
                        var64_101 = 0.5 * var30_25;
                        var30_25 = var46_33 <= 0.1 ? FastMath.min(var64_101, var48_34) : (var46_33 <= 0.7 ? FastMath.max(var64_101, var48_34) : FastMath.max(var64_101, 2.0 * var48_34));
                        if (var30_25 <= var28_24 * 1.5) {
                            var30_25 = var28_24;
                        }
                        if (var38_29 < var57_46) {
                            var66_108 = var26_22;
                            var67_112 = var44_32;
                            var69_121 = var30_25 * var30_25;
                            var50_35 = 0.0;
                            var52_36 = 0.0;
                            var26_22 = 0;
                            for (var71_136 = 0; var71_136 < var4_4; ++var71_136) {
                                var72_141 = 0.0;
                                for (var74_146 = 0; var74_146 < var6_6; ++var74_146) {
                                    var75_147 = this.zMatrix.getEntry(var71_136, var74_146);
                                    var72_141 += var75_147 * var75_147;
                                }
                                var74_145 = this.lagrangeValuesAtNewPoint.getEntry(var71_136);
                                var76_148 = var40_30 * var72_141 + var74_145 * var74_145;
                                var54_37 = 0.0;
                                for (var78_150 = 0; var78_150 < var3_3; ++var78_150) {
                                    var79_152 = this.interpolationPoints.getEntry(var71_136, var78_150) - this.newPoint.getEntry(var78_150);
                                    var54_37 += var79_152 * var79_152;
                                }
                                var78_151 = var54_37 / var69_121;
                                var80_153 = FastMath.max(1.0, var78_151 * var78_151);
                                if (var80_153 * var76_148 > var50_35) {
                                    var50_35 = var80_153 * var76_148;
                                    var26_22 = var71_136;
                                    var44_32 = var76_148;
                                }
                                var82_154 = this.lagrangeValuesAtNewPoint.getEntry(var71_136);
                                var84_155 = var80_153 * (var82_154 * var82_154);
                                var52_36 = FastMath.max(var52_36, var84_155);
                            }
                            if (var50_35 <= 0.5 * var52_36) {
                                var26_22 = var66_108;
                                var44_32 = var67_112;
                            }
                        }
                    }
                    this.update(var40_30, var44_32, var26_22);
                    var61_77 = 0;
                    var64_101 = this.modelSecondDerivativesParameters.getEntry(var26_22);
                    this.modelSecondDerivativesParameters.setEntry(var26_22, 0.0);
                    for (var66_109 = 0; var66_109 < var3_3; ++var66_109) {
                        var67_112 = var64_101 * this.interpolationPoints.getEntry(var26_22, var66_109);
                        for (var69_123 = 0; var69_123 <= var66_109; ++var69_123) {
                            this.modelSecondDerivativesValues.setEntry(var61_77, this.modelSecondDerivativesValues.getEntry(var61_77) + var67_112 * this.interpolationPoints.getEntry(var26_22, var69_123));
                            ++var61_77;
                        }
                    }
                    for (var66_109 = 0; var66_109 < var6_6; ++var66_109) {
                        var67_112 = var62_87 * this.zMatrix.getEntry(var26_22, var66_109);
                        for (var69_124 = 0; var69_124 < var4_4; ++var69_124) {
                            this.modelSecondDerivativesParameters.setEntry(var69_124, this.modelSecondDerivativesParameters.getEntry(var69_124) + var67_112 * this.zMatrix.getEntry(var69_124, var66_109));
                        }
                    }
                    this.fAtInterpolationPoints.setEntry(var26_22, var38_29);
                    for (var66_109 = 0; var66_109 < var3_3; ++var66_109) {
                        this.interpolationPoints.setEntry(var26_22, var66_109, this.newPoint.getEntry(var66_109));
                        var8_8.setEntry(var66_109, this.bMatrix.getEntry(var26_22, var66_109));
                    }
                    for (var66_109 = 0; var66_109 < var4_4; ++var66_109) {
                        var67_112 = 0.0;
                        for (var69_125 = 0; var69_125 < var6_6; ++var69_125) {
                            var67_112 += this.zMatrix.getEntry(var26_22, var69_125) * this.zMatrix.getEntry(var66_109, var69_125);
                        }
                        var69_126 = 0.0;
                        for (var71_137 = 0; var71_137 < var3_3; ++var71_137) {
                            var69_126 += this.interpolationPoints.getEntry(var66_109, var71_137) * this.trustRegionCenterOffset.getEntry(var71_137);
                        }
                        var71_138 = var67_112 * var69_126;
                        for (var73_142 = 0; var73_142 < var3_3; ++var73_142) {
                            var8_8.setEntry(var73_142, var8_8.getEntry(var73_142) + var71_138 * this.interpolationPoints.getEntry(var66_109, var73_142));
                        }
                    }
                    for (var66_109 = 0; var66_109 < var3_3; ++var66_109) {
                        this.gradientAtTrustRegionCenter.setEntry(var66_109, this.gradientAtTrustRegionCenter.getEntry(var66_109) + var62_87 * var8_8.getEntry(var66_109));
                    }
                    if (var38_29 < var57_46) {
                        this.trustRegionCenterInterpolationPointIndex = var26_22;
                        var19_15 = 0.0;
                        var61_77 = 0;
                        for (var66_109 = 0; var66_109 < var3_3; ++var66_109) {
                            this.trustRegionCenterOffset.setEntry(var66_109, this.newPoint.getEntry(var66_109));
                            var67_112 = this.trustRegionCenterOffset.getEntry(var66_109);
                            var19_15 += var67_112 * var67_112;
                            for (var69_127 = 0; var69_127 <= var66_109; ++var69_127) {
                                if (var69_127 < var66_109) {
                                    this.gradientAtTrustRegionCenter.setEntry(var66_109, this.gradientAtTrustRegionCenter.getEntry(var66_109) + this.modelSecondDerivativesValues.getEntry(var61_77) * this.trialStepPoint.getEntry(var69_127));
                                }
                                this.gradientAtTrustRegionCenter.setEntry(var69_127, this.gradientAtTrustRegionCenter.getEntry(var69_127) + this.modelSecondDerivativesValues.getEntry(var61_77) * this.trialStepPoint.getEntry(var66_109));
                                ++var61_77;
                            }
                        }
                        for (var66_109 = 0; var66_109 < var4_4; ++var66_109) {
                            var67_112 = 0.0;
                            for (var69_128 = 0; var69_128 < var3_3; ++var69_128) {
                                var67_112 += this.interpolationPoints.getEntry(var66_109, var69_128) * this.trialStepPoint.getEntry(var69_128);
                            }
                            var67_112 *= this.modelSecondDerivativesParameters.getEntry(var66_109);
                            for (var69_128 = 0; var69_128 < var3_3; ++var69_128) {
                                this.gradientAtTrustRegionCenter.setEntry(var69_128, this.gradientAtTrustRegionCenter.getEntry(var69_128) + var67_112 * this.interpolationPoints.getEntry(var66_109, var69_128));
                            }
                        }
                    }
                    if (var24_20 > 0) {
                        for (var66_109 = 0; var66_109 < var4_4; ++var66_109) {
                            this.lagrangeValuesAtNewPoint.setEntry(var66_109, this.fAtInterpolationPoints.getEntry(var66_109) - this.fAtInterpolationPoints.getEntry(this.trustRegionCenterInterpolationPointIndex));
                            var10_10.setEntry(var66_109, 0.0);
                        }
                        for (var66_109 = 0; var66_109 < var6_6; ++var66_109) {
                            var67_112 = 0.0;
                            for (var69_129 = 0; var69_129 < var4_4; ++var69_129) {
                                var67_112 += this.zMatrix.getEntry(var69_129, var66_109) * this.lagrangeValuesAtNewPoint.getEntry(var69_129);
                            }
                            for (var69_129 = 0; var69_129 < var4_4; ++var69_129) {
                                var10_10.setEntry(var69_129, var10_10.getEntry(var69_129) + var67_112 * this.zMatrix.getEntry(var69_129, var66_109));
                            }
                        }
                        for (var66_109 = 0; var66_109 < var4_4; ++var66_109) {
                            var67_112 = 0.0;
                            for (var69_130 = 0; var69_130 < var3_3; ++var69_130) {
                                var67_112 += this.interpolationPoints.getEntry(var66_109, var69_130) * this.trustRegionCenterOffset.getEntry(var69_130);
                            }
                            var9_9.setEntry(var66_109, var10_10.getEntry(var66_109));
                            var10_10.setEntry(var66_109, var67_112 * var10_10.getEntry(var66_109));
                        }
                        var66_110 = 0.0;
                        var68_120 = 0.0;
                        for (var70_134 = 0; var70_134 < var3_3; ++var70_134) {
                            var71_139 = 0.0;
                            for (var73_143 = 0; var73_143 < var4_4; ++var73_143) {
                                var71_139 += this.bMatrix.getEntry(var73_143, var70_134) * this.lagrangeValuesAtNewPoint.getEntry(var73_143) + this.interpolationPoints.getEntry(var73_143, var70_134) * var10_10.getEntry(var73_143);
                            }
                            if (this.trustRegionCenterOffset.getEntry(var70_134) == this.lowerDifference.getEntry(var70_134)) {
                                var73_144 = FastMath.min(0.0, this.gradientAtTrustRegionCenter.getEntry(var70_134));
                                var66_110 += var73_144 * var73_144;
                                var75_147 = FastMath.min(0.0, var71_139);
                                var68_120 += var75_147 * var75_147;
                            } else if (this.trustRegionCenterOffset.getEntry(var70_134) == this.upperDifference.getEntry(var70_134)) {
                                var73_144 = FastMath.max(0.0, this.gradientAtTrustRegionCenter.getEntry(var70_134));
                                var66_110 += var73_144 * var73_144;
                                var75_147 = FastMath.max(0.0, var71_139);
                                var68_120 += var75_147 * var75_147;
                            } else {
                                var73_144 = this.gradientAtTrustRegionCenter.getEntry(var70_134);
                                var66_110 += var73_144 * var73_144;
                                var68_120 += var71_139 * var71_139;
                            }
                            this.lagrangeValuesAtNewPoint.setEntry(var4_4 + var70_134, var71_139);
                        }
                        ++var25_21;
                        if (var66_110 < 10.0 * var68_120) {
                            var25_21 = 0;
                        }
                        if (var25_21 >= 3) {
                            var71_140 = FastMath.max(var4_4, var7_7);
                            for (var70_134 = 0; var70_134 < var71_140; ++var70_134) {
                                if (var70_134 < var3_3) {
                                    this.gradientAtTrustRegionCenter.setEntry(var70_134, this.lagrangeValuesAtNewPoint.getEntry(var4_4 + var70_134));
                                }
                                if (var70_134 < var4_4) {
                                    this.modelSecondDerivativesParameters.setEntry(var70_134, var9_9.getEntry(var70_134));
                                }
                                if (var70_134 < var7_7) {
                                    this.modelSecondDerivativesValues.setEntry(var70_134, 0.0);
                                }
                                var25_21 = 0;
                            }
                        }
                    }
                    if (var24_20 == 0) {
                        var56_38 = 60;
                        continue block12;
                    }
                    if (var38_29 <= var57_46 + 0.1 * var59_63) {
                        var56_38 = 60;
                        continue block12;
                    }
                    var66_111 = 2.0 * var30_25;
                    var68_120 = 10.0 * var28_24;
                    var54_37 = FastMath.max(var66_111 * var66_111, var68_120 * var68_120);
                }
                case 650: {
                    BOBYQAOptimizer.printState(650);
                    var26_22 = -1;
                    for (var57_47 = 0; var57_47 < var4_4; ++var57_47) {
                        var58_56 = 0.0;
                        for (var60_69 = 0; var60_69 < var3_3; ++var60_69) {
                            var61_78 = this.interpolationPoints.getEntry(var57_47, var60_69) - this.trustRegionCenterOffset.getEntry(var60_69);
                            var58_56 += var61_78 * var61_78;
                        }
                        if (!(var58_56 > var54_37)) continue;
                        var26_22 = var57_47;
                        var54_37 = var58_56;
                    }
                    if (var26_22 >= 0) {
                        var57_48 = FastMath.sqrt(var54_37);
                        if (var24_20 == -1 && (var30_25 = FastMath.min(0.1 * var30_25, 0.5 * var57_48)) <= var28_24 * 1.5) {
                            var30_25 = var28_24;
                        }
                        var24_20 = 0;
                        var59_64 = FastMath.min(0.1 * var57_48, var30_25);
                        var42_31 = FastMath.max(var59_64, var28_24);
                        var15_13 = var42_31 * var42_31;
                        var56_38 = 90;
                        continue block12;
                    }
                    if (var24_20 == -1) {
                        var56_38 = 680;
                        continue block12;
                    }
                    if (var46_33 > 0.0) {
                        var56_38 = 60;
                        continue block12;
                    }
                    if (FastMath.max(var30_25, var48_34) > var28_24) {
                        var56_38 = 60;
                        continue block12;
                    }
                }
                case 680: {
                    BOBYQAOptimizer.printState(680);
                    if (var28_24 > this.stoppingTrustRegionRadius) {
                        var30_25 = 0.5 * var28_24;
                        var46_33 = var28_24 / this.stoppingTrustRegionRadius;
                        var28_24 = var46_33 <= 16.0 ? this.stoppingTrustRegionRadius : (var46_33 <= 250.0 ? FastMath.sqrt(var46_33) * this.stoppingTrustRegionRadius : (var28_24 *= 0.1));
                        var30_25 = FastMath.max(var30_25, var28_24);
                        var24_20 = 0;
                        var27_23 = this.getEvaluations();
                        var56_38 = 60;
                        continue block12;
                    }
                    if (var24_20 == -1) {
                        var56_38 = 360;
                        continue block12;
                    }
                }
                case 720: {
                    BOBYQAOptimizer.printState(720);
                    if (this.fAtInterpolationPoints.getEntry(this.trustRegionCenterInterpolationPointIndex) <= var21_17) {
                        for (var57_49 = 0; var57_49 < var3_3; ++var57_49) {
                            var58_57 = var1_1[var57_49];
                            var60_70 = this.originShift.getEntry(var57_49) + this.trustRegionCenterOffset.getEntry(var57_49);
                            var62_88 = FastMath.max(var58_57, var60_70);
                            var64_102 = var2_2[var57_49];
                            this.currentBest.setEntry(var57_49, FastMath.min(var62_88, var64_102));
                            if (this.trustRegionCenterOffset.getEntry(var57_49) == this.lowerDifference.getEntry(var57_49)) {
                                this.currentBest.setEntry(var57_49, var1_1[var57_49]);
                            }
                            if (this.trustRegionCenterOffset.getEntry(var57_49) != this.upperDifference.getEntry(var57_49)) continue;
                            this.currentBest.setEntry(var57_49, var2_2[var57_49]);
                        }
                        var38_29 = this.fAtInterpolationPoints.getEntry(this.trustRegionCenterInterpolationPointIndex);
                    }
                    return var38_29;
                }
            }
            break;
        }
        throw new MathIllegalStateException(LocalizedFormats.SIMPLE_MESSAGE, new Object[]{"bobyqb"});
    }

    private double[] altmov(int n, double d) {
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        int n2;
        int n3;
        double d10;
        int n4;
        BOBYQAOptimizer.printMethod();
        int n5 = this.currentBest.getDimension();
        int n6 = this.numberOfInterpolationPoints;
        ArrayRealVector arrayRealVector = new ArrayRealVector(n5);
        ArrayRealVector arrayRealVector2 = new ArrayRealVector(n6);
        ArrayRealVector arrayRealVector3 = new ArrayRealVector(n5);
        ArrayRealVector arrayRealVector4 = new ArrayRealVector(n5);
        for (n4 = 0; n4 < n6; ++n4) {
            arrayRealVector2.setEntry(n4, 0.0);
        }
        int n7 = n6 - n5 - 1;
        for (n4 = 0; n4 < n7; ++n4) {
            d10 = this.zMatrix.getEntry(n, n4);
            for (n3 = 0; n3 < n6; ++n3) {
                arrayRealVector2.setEntry(n3, arrayRealVector2.getEntry(n3) + d10 * this.zMatrix.getEntry(n3, n4));
            }
        }
        double d11 = arrayRealVector2.getEntry(n);
        d10 = 0.5 * d11;
        for (n3 = 0; n3 < n5; ++n3) {
            arrayRealVector.setEntry(n3, this.bMatrix.getEntry(n, n3));
        }
        for (n3 = 0; n3 < n6; ++n3) {
            int n8;
            double d12 = 0.0;
            for (n8 = 0; n8 < n5; ++n8) {
                d12 += this.interpolationPoints.getEntry(n3, n8) * this.trustRegionCenterOffset.getEntry(n8);
            }
            d12 *= arrayRealVector2.getEntry(n3);
            for (n8 = 0; n8 < n5; ++n8) {
                arrayRealVector.setEntry(n8, arrayRealVector.getEntry(n8) + d12 * this.interpolationPoints.getEntry(n3, n8));
            }
        }
        double d13 = 0.0;
        double d14 = Double.NaN;
        int n9 = 0;
        int n10 = 0;
        double d15 = 0.0;
        for (n2 = 0; n2 < n6; ++n2) {
            int n11;
            if (n2 == this.trustRegionCenterInterpolationPointIndex) continue;
            d9 = 0.0;
            d8 = 0.0;
            for (int i = 0; i < n5; ++i) {
                double d16 = this.interpolationPoints.getEntry(n2, i) - this.trustRegionCenterOffset.getEntry(i);
                d9 += arrayRealVector.getEntry(i) * d16;
                d8 += d16 * d16;
            }
            d7 = d / FastMath.sqrt(d8);
            d6 = -d7;
            int n12 = 0;
            int n13 = 0;
            d5 = FastMath.min(1.0, d7);
            for (n11 = 0; n11 < n5; ++n11) {
                d4 = this.interpolationPoints.getEntry(n2, n11) - this.trustRegionCenterOffset.getEntry(n11);
                if (d4 > 0.0) {
                    if (d6 * d4 < this.lowerDifference.getEntry(n11) - this.trustRegionCenterOffset.getEntry(n11)) {
                        d6 = (this.lowerDifference.getEntry(n11) - this.trustRegionCenterOffset.getEntry(n11)) / d4;
                        n12 = -n11 - 1;
                    }
                    if (!(d7 * d4 > this.upperDifference.getEntry(n11) - this.trustRegionCenterOffset.getEntry(n11))) continue;
                    d7 = FastMath.max(d5, (this.upperDifference.getEntry(n11) - this.trustRegionCenterOffset.getEntry(n11)) / d4);
                    n13 = n11 + 1;
                    continue;
                }
                if (!(d4 < 0.0)) continue;
                if (d6 * d4 > this.upperDifference.getEntry(n11) - this.trustRegionCenterOffset.getEntry(n11)) {
                    d6 = (this.upperDifference.getEntry(n11) - this.trustRegionCenterOffset.getEntry(n11)) / d4;
                    n12 = n11 + 1;
                }
                if (!(d7 * d4 < this.lowerDifference.getEntry(n11) - this.trustRegionCenterOffset.getEntry(n11))) continue;
                d7 = FastMath.max(d5, (this.lowerDifference.getEntry(n11) - this.trustRegionCenterOffset.getEntry(n11)) / d4);
                n13 = -n11 - 1;
            }
            d14 = d6;
            n11 = n12;
            d4 = Double.NaN;
            if (n2 == n) {
                double d17;
                double d18;
                double d19;
                double d20;
                d3 = d9 - 1.0;
                d4 = d6 * (d9 - d6 * d3);
                d2 = d7 * (d9 - d7 * d3);
                if (FastMath.abs(d2) > FastMath.abs(d4)) {
                    d14 = d7;
                    d4 = d2;
                    n11 = n13;
                }
                if ((d20 = (d19 = 0.5 * d9) - d3 * d6) * (d18 = d19 - d3 * d7) < 0.0 && FastMath.abs(d17 = d19 * d19 / d3) > FastMath.abs(d4)) {
                    d14 = d19 / d3;
                    d4 = d17;
                    n11 = 0;
                }
            } else {
                d4 = d6 * (1.0 - d6);
                d3 = d7 * (1.0 - d7);
                if (FastMath.abs(d3) > FastMath.abs(d4)) {
                    d14 = d7;
                    d4 = d3;
                    n11 = n13;
                }
                if (d7 > 0.5 && FastMath.abs(d4) < 0.25) {
                    d14 = 0.5;
                    d4 = 0.25;
                    n11 = 0;
                }
                d4 *= d9;
            }
            d3 = d14 * (1.0 - d14) * d8;
            d2 = d4 * d4 * (d4 * d4 + d10 * d3 * d3);
            if (!(d2 > d13)) continue;
            d13 = d2;
            n9 = n2;
            d15 = d14;
            n10 = n11;
        }
        for (n2 = 0; n2 < n5; ++n2) {
            d9 = this.trustRegionCenterOffset.getEntry(n2) + d15 * (this.interpolationPoints.getEntry(n9, n2) - this.trustRegionCenterOffset.getEntry(n2));
            this.newPoint.setEntry(n2, FastMath.max(this.lowerDifference.getEntry(n2), FastMath.min(this.upperDifference.getEntry(n2), d9)));
        }
        if (n10 < 0) {
            this.newPoint.setEntry(-n10 - 1, this.lowerDifference.getEntry(-n10 - 1));
        }
        if (n10 > 0) {
            this.newPoint.setEntry(n10 - 1, this.upperDifference.getEntry(n10 - 1));
        }
        double d21 = d + d;
        boolean bl = false;
        d8 = Double.NaN;
        d7 = 0.0;
        while (true) {
            double d22;
            int n14;
            d6 = 0.0;
            double d23 = 0.0;
            for (int i = 0; i < n5; ++i) {
                double d24 = arrayRealVector.getEntry(i);
                arrayRealVector3.setEntry(i, 0.0);
                if (!(FastMath.min(this.trustRegionCenterOffset.getEntry(i) - this.lowerDifference.getEntry(i), d24) > 0.0) && !(FastMath.max(this.trustRegionCenterOffset.getEntry(i) - this.upperDifference.getEntry(i), d24) < 0.0)) continue;
                arrayRealVector3.setEntry(i, d21);
                d23 += d24 * d24;
            }
            if (d23 == 0.0) {
                return new double[]{d11, 0.0};
            }
            d5 = d * d - d6;
            if (d5 > 0.0) {
                d14 = FastMath.sqrt(d5 / d23);
                d23 = 0.0;
                for (int i = 0; i < n5; ++i) {
                    if (arrayRealVector3.getEntry(i) != d21) continue;
                    d4 = this.trustRegionCenterOffset.getEntry(i) - d14 * arrayRealVector.getEntry(i);
                    if (d4 <= this.lowerDifference.getEntry(i)) {
                        arrayRealVector3.setEntry(i, this.lowerDifference.getEntry(i) - this.trustRegionCenterOffset.getEntry(i));
                        d3 = arrayRealVector3.getEntry(i);
                        d6 += d3 * d3;
                        continue;
                    }
                    if (d4 >= this.upperDifference.getEntry(i)) {
                        arrayRealVector3.setEntry(i, this.upperDifference.getEntry(i) - this.trustRegionCenterOffset.getEntry(i));
                        d3 = arrayRealVector3.getEntry(i);
                        d6 += d3 * d3;
                        continue;
                    }
                    d3 = arrayRealVector.getEntry(i);
                    d23 += d3 * d3;
                }
            }
            double d25 = 0.0;
            for (int i = 0; i < n5; ++i) {
                d3 = arrayRealVector.getEntry(i);
                if (arrayRealVector3.getEntry(i) == d21) {
                    arrayRealVector3.setEntry(i, -d14 * d3);
                    d2 = FastMath.min(this.upperDifference.getEntry(i), this.trustRegionCenterOffset.getEntry(i) + arrayRealVector3.getEntry(i));
                    this.alternativeNewPoint.setEntry(i, FastMath.max(this.lowerDifference.getEntry(i), d2));
                } else if (arrayRealVector3.getEntry(i) == 0.0) {
                    this.alternativeNewPoint.setEntry(i, this.trustRegionCenterOffset.getEntry(i));
                } else if (d3 > 0.0) {
                    this.alternativeNewPoint.setEntry(i, this.lowerDifference.getEntry(i));
                } else {
                    this.alternativeNewPoint.setEntry(i, this.upperDifference.getEntry(i));
                }
                d25 += d3 * arrayRealVector3.getEntry(i);
            }
            double d26 = 0.0;
            for (n14 = 0; n14 < n6; ++n14) {
                d2 = 0.0;
                for (int i = 0; i < n5; ++i) {
                    d2 += this.interpolationPoints.getEntry(n14, i) * arrayRealVector3.getEntry(i);
                }
                d26 += arrayRealVector2.getEntry(n14) * d2 * d2;
            }
            if (bl) {
                d26 = -d26;
            }
            if (d26 > -d25 && d26 < -d25 * (1.0 + FastMath.sqrt(2.0))) {
                d22 = -d25 / d26;
                for (int i = 0; i < n5; ++i) {
                    double d27 = this.trustRegionCenterOffset.getEntry(i) + d22 * arrayRealVector3.getEntry(i);
                    this.alternativeNewPoint.setEntry(i, FastMath.max(this.lowerDifference.getEntry(i), FastMath.min(this.upperDifference.getEntry(i), d27)));
                }
                double d28 = 0.5 * d25 * d22;
                d8 = d28 * d28;
            } else {
                d22 = d25 + 0.5 * d26;
                d8 = d22 * d22;
            }
            if (bl) break;
            for (n14 = 0; n14 < n5; ++n14) {
                arrayRealVector.setEntry(n14, -arrayRealVector.getEntry(n14));
                arrayRealVector4.setEntry(n14, this.alternativeNewPoint.getEntry(n14));
            }
            d7 = d8;
            bl = true;
        }
        if (d7 > d8) {
            for (int i = 0; i < n5; ++i) {
                this.alternativeNewPoint.setEntry(i, arrayRealVector4.getEntry(i));
            }
            d8 = d7;
        }
        return new double[]{d11, d8};
    }

    private void prelim(double[] dArray, double[] dArray2) {
        int n;
        int n2;
        BOBYQAOptimizer.printMethod();
        int n3 = this.currentBest.getDimension();
        int n4 = this.numberOfInterpolationPoints;
        int n5 = this.bMatrix.getRowDimension();
        double d = this.initialTrustRegionRadius * this.initialTrustRegionRadius;
        double d2 = 1.0 / d;
        int n6 = n3 + 1;
        for (n2 = 0; n2 < n3; ++n2) {
            this.originShift.setEntry(n2, this.currentBest.getEntry(n2));
            for (n = 0; n < n4; ++n) {
                this.interpolationPoints.setEntry(n, n2, 0.0);
            }
            for (n = 0; n < n5; ++n) {
                this.bMatrix.setEntry(n, n2, 0.0);
            }
        }
        n = n3 * n6 / 2;
        for (n2 = 0; n2 < n; ++n2) {
            this.modelSecondDerivativesValues.setEntry(n2, 0.0);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            this.modelSecondDerivativesParameters.setEntry(n2, 0.0);
            int n7 = n4 - n6;
            for (n = 0; n < n7; ++n) {
                this.zMatrix.setEntry(n2, n, 0.0);
            }
        }
        n2 = 0;
        n = 0;
        double d3 = Double.NaN;
        do {
            double d4;
            int n8;
            int n9 = this.getEvaluations();
            int n10 = n9 - n3;
            int n11 = n9 - 1;
            int n12 = n10 - 1;
            double d5 = 0.0;
            double d6 = 0.0;
            if (n9 <= 2 * n3) {
                if (n9 >= 1 && n9 <= n3) {
                    d5 = this.initialTrustRegionRadius;
                    if (this.upperDifference.getEntry(n11) == 0.0) {
                        d5 = -d5;
                    }
                    this.interpolationPoints.setEntry(n9, n11, d5);
                } else if (n9 > n3) {
                    d5 = this.interpolationPoints.getEntry(n10, n12);
                    d6 = -this.initialTrustRegionRadius;
                    if (this.lowerDifference.getEntry(n12) == 0.0) {
                        d6 = FastMath.min(2.0 * this.initialTrustRegionRadius, this.upperDifference.getEntry(n12));
                    }
                    if (this.upperDifference.getEntry(n12) == 0.0) {
                        d6 = FastMath.max(-2.0 * this.initialTrustRegionRadius, this.lowerDifference.getEntry(n12));
                    }
                    this.interpolationPoints.setEntry(n9, n12, d6);
                }
            } else {
                int n13;
                n8 = (n9 - n6) / n3;
                n = n9 - n8 * n3 - n3;
                n2 = n + n8;
                if (n2 > n3) {
                    n13 = n;
                    n = n2 - n3;
                    n2 = n13;
                }
                n13 = n2 - 1;
                int n14 = n - 1;
                this.interpolationPoints.setEntry(n9, n13, this.interpolationPoints.getEntry(n2, n13));
                this.interpolationPoints.setEntry(n9, n14, this.interpolationPoints.getEntry(n, n14));
            }
            for (n8 = 0; n8 < n3; ++n8) {
                this.currentBest.setEntry(n8, FastMath.min(FastMath.max(dArray[n8], this.originShift.getEntry(n8) + this.interpolationPoints.getEntry(n9, n8)), dArray2[n8]));
                if (this.interpolationPoints.getEntry(n9, n8) == this.lowerDifference.getEntry(n8)) {
                    this.currentBest.setEntry(n8, dArray[n8]);
                }
                if (this.interpolationPoints.getEntry(n9, n8) != this.upperDifference.getEntry(n8)) continue;
                this.currentBest.setEntry(n8, dArray2[n8]);
            }
            double d7 = this.computeObjectiveValue(this.currentBest.toArray());
            double d8 = this.isMinimize ? d7 : -d7;
            int n15 = this.getEvaluations();
            this.fAtInterpolationPoints.setEntry(n9, d8);
            if (n15 == 1) {
                d3 = d8;
                this.trustRegionCenterInterpolationPointIndex = 0;
            } else if (d8 < this.fAtInterpolationPoints.getEntry(this.trustRegionCenterInterpolationPointIndex)) {
                this.trustRegionCenterInterpolationPointIndex = n9;
            }
            if (n15 <= 2 * n3 + 1) {
                if (n15 >= 2 && n15 <= n3 + 1) {
                    this.gradientAtTrustRegionCenter.setEntry(n11, (d8 - d3) / d5);
                    if (n4 >= n15 + n3) continue;
                    double d9 = 1.0 / d5;
                    this.bMatrix.setEntry(0, n11, -d9);
                    this.bMatrix.setEntry(n9, n11, d9);
                    this.bMatrix.setEntry(n4 + n11, n11, -0.5 * d);
                    continue;
                }
                if (n15 < n3 + 2) continue;
                int n16 = n10 * (n10 + 1) / 2 - 1;
                d4 = (d8 - d3) / d6;
                double d10 = d6 - d5;
                this.modelSecondDerivativesValues.setEntry(n16, 2.0 * (d4 - this.gradientAtTrustRegionCenter.getEntry(n12)) / d10);
                this.gradientAtTrustRegionCenter.setEntry(n12, (this.gradientAtTrustRegionCenter.getEntry(n12) * d6 - d4 * d5) / d10);
                if (d5 * d6 < 0.0 && d8 < this.fAtInterpolationPoints.getEntry(n9 - n3)) {
                    this.fAtInterpolationPoints.setEntry(n9, this.fAtInterpolationPoints.getEntry(n9 - n3));
                    this.fAtInterpolationPoints.setEntry(n9 - n3, d8);
                    if (this.trustRegionCenterInterpolationPointIndex == n9) {
                        this.trustRegionCenterInterpolationPointIndex = n9 - n3;
                    }
                    this.interpolationPoints.setEntry(n9 - n3, n12, d6);
                    this.interpolationPoints.setEntry(n9, n12, d5);
                }
                this.bMatrix.setEntry(0, n12, -(d5 + d6) / (d5 * d6));
                this.bMatrix.setEntry(n9, n12, -0.5 / this.interpolationPoints.getEntry(n9 - n3, n12));
                this.bMatrix.setEntry(n9 - n3, n12, -this.bMatrix.getEntry(0, n12) - this.bMatrix.getEntry(n9, n12));
                this.zMatrix.setEntry(0, n12, FastMath.sqrt(2.0) / (d5 * d6));
                this.zMatrix.setEntry(n9, n12, FastMath.sqrt(0.5) / d);
                this.zMatrix.setEntry(n9 - n3, n12, -this.zMatrix.getEntry(0, n12) - this.zMatrix.getEntry(n9, n12));
                continue;
            }
            this.zMatrix.setEntry(0, n12, d2);
            this.zMatrix.setEntry(n9, n12, d2);
            this.zMatrix.setEntry(n2, n12, -d2);
            this.zMatrix.setEntry(n, n12, -d2);
            int n17 = n2 * (n2 - 1) / 2 + n - 1;
            d4 = this.interpolationPoints.getEntry(n9, n2 - 1) * this.interpolationPoints.getEntry(n9, n - 1);
            this.modelSecondDerivativesValues.setEntry(n17, (d3 - this.fAtInterpolationPoints.getEntry(n2) - this.fAtInterpolationPoints.getEntry(n) + d8) / d4);
        } while (this.getEvaluations() < n4);
    }

    private double[] trsbox(double d, ArrayRealVector arrayRealVector, ArrayRealVector arrayRealVector2, ArrayRealVector arrayRealVector3, ArrayRealVector arrayRealVector4, ArrayRealVector arrayRealVector5) {
        int n;
        BOBYQAOptimizer.printMethod();
        int n2 = this.currentBest.getDimension();
        int n3 = this.numberOfInterpolationPoints;
        double d2 = Double.NaN;
        double d3 = Double.NaN;
        double d4 = 0.0;
        int n4 = -1;
        int n5 = 0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = 0.0;
        double d19 = 0.0;
        double d20 = 0.0;
        double d21 = 0.0;
        int n6 = 0;
        double d22 = 0.0;
        double d23 = 0.0;
        double d24 = 0.0;
        double d25 = 0.0;
        int n7 = 0;
        int n8 = 0;
        n5 = 0;
        for (n = 0; n < n2; ++n) {
            arrayRealVector2.setEntry(n, 0.0);
            if (this.trustRegionCenterOffset.getEntry(n) <= this.lowerDifference.getEntry(n)) {
                if (this.gradientAtTrustRegionCenter.getEntry(n) >= 0.0) {
                    arrayRealVector2.setEntry(n, -1.0);
                }
            } else if (this.trustRegionCenterOffset.getEntry(n) >= this.upperDifference.getEntry(n) && this.gradientAtTrustRegionCenter.getEntry(n) <= 0.0) {
                arrayRealVector2.setEntry(n, 1.0);
            }
            if (arrayRealVector2.getEntry(n) != 0.0) {
                ++n5;
            }
            this.trialStepPoint.setEntry(n, 0.0);
            arrayRealVector.setEntry(n, this.gradientAtTrustRegionCenter.getEntry(n));
        }
        d13 = d * d;
        double d26 = 0.0;
        d3 = -1.0;
        n = 20;
        block12: while (true) {
            switch (n) {
                case 20: {
                    BOBYQAOptimizer.printState(20);
                    d4 = 0.0;
                }
                case 30: {
                    BOBYQAOptimizer.printState(30);
                    d25 = 0.0;
                    for (int i = 0; i < n2; ++i) {
                        if (arrayRealVector2.getEntry(i) != 0.0) {
                            arrayRealVector3.setEntry(i, 0.0);
                        } else if (d4 == 0.0) {
                            arrayRealVector3.setEntry(i, -arrayRealVector.getEntry(i));
                        } else {
                            arrayRealVector3.setEntry(i, d4 * arrayRealVector3.getEntry(i) - arrayRealVector.getEntry(i));
                        }
                        double d27 = arrayRealVector3.getEntry(i);
                        d25 += d27 * d27;
                    }
                    if (d25 == 0.0) {
                        n = 190;
                        continue block12;
                    }
                    if (d4 == 0.0) {
                        d20 = d25;
                        n7 = n8 + n2 - n5;
                    }
                    if (d20 * d13 <= d26 * 1.0E-4 * d26) {
                        n = 190;
                        continue block12;
                    }
                    n = 210;
                    continue block12;
                }
                case 50: {
                    int n9;
                    BOBYQAOptimizer.printState(50);
                    d12 = d13;
                    double d28 = 0.0;
                    double d29 = 0.0;
                    for (n9 = 0; n9 < n2; ++n9) {
                        if (arrayRealVector2.getEntry(n9) != 0.0) continue;
                        double d30 = this.trialStepPoint.getEntry(n9);
                        d12 -= d30 * d30;
                        d28 += arrayRealVector3.getEntry(n9) * this.trialStepPoint.getEntry(n9);
                        d29 += arrayRealVector3.getEntry(n9) * arrayRealVector4.getEntry(n9);
                    }
                    if (d12 <= 0.0) {
                        n = 90;
                        continue block12;
                    }
                    d6 = FastMath.sqrt(d25 * d12 + d28 * d28);
                    double d31 = d28 < 0.0 ? (d6 - d28) / d25 : d12 / (d6 + d28);
                    d24 = d31;
                    if (d29 > 0.0) {
                        d24 = FastMath.min(d31, d20 / d29);
                    }
                    n4 = -1;
                    for (n9 = 0; n9 < n2; ++n9) {
                        if (arrayRealVector3.getEntry(n9) == 0.0) continue;
                        d8 = this.trustRegionCenterOffset.getEntry(n9) + this.trialStepPoint.getEntry(n9);
                        d6 = arrayRealVector3.getEntry(n9) > 0.0 ? (this.upperDifference.getEntry(n9) - d8) / arrayRealVector3.getEntry(n9) : (this.lowerDifference.getEntry(n9) - d8) / arrayRealVector3.getEntry(n9);
                        if (!(d6 < d24)) continue;
                        d24 = d6;
                        n4 = n9;
                    }
                    double d32 = 0.0;
                    if (d24 > 0.0) {
                        ++n8;
                        d6 = d29 / d25;
                        if (n4 == -1 && d6 > 0.0 && (d3 = FastMath.min(d3, d6)) == -1.0) {
                            d3 = d6;
                        }
                        d14 = d20;
                        d20 = 0.0;
                        for (n9 = 0; n9 < n2; ++n9) {
                            arrayRealVector.setEntry(n9, arrayRealVector.getEntry(n9) + d24 * arrayRealVector4.getEntry(n9));
                            if (arrayRealVector2.getEntry(n9) == 0.0) {
                                double d33 = arrayRealVector.getEntry(n9);
                                d20 += d33 * d33;
                            }
                            this.trialStepPoint.setEntry(n9, this.trialStepPoint.getEntry(n9) + d24 * arrayRealVector3.getEntry(n9));
                        }
                        double d34 = d24 * (d14 - 0.5 * d24 * d29);
                        d32 = FastMath.max(d34, 0.0);
                        d26 += d32;
                    }
                    if (n4 >= 0) {
                        double d35;
                        ++n5;
                        arrayRealVector2.setEntry(n4, 1.0);
                        if (arrayRealVector3.getEntry(n4) < 0.0) {
                            arrayRealVector2.setEntry(n4, -1.0);
                        }
                        if ((d13 -= (d35 = this.trialStepPoint.getEntry(n4)) * d35) <= 0.0) {
                            n = 190;
                            continue block12;
                        }
                        n = 20;
                        continue block12;
                    }
                    if (d24 < d31) {
                        if (n8 == n7) {
                            n = 190;
                            continue block12;
                        }
                        if (d32 <= d26 * 0.01) {
                            n = 190;
                            continue block12;
                        }
                        d4 = d20 / d14;
                        n = 30;
                        continue block12;
                    }
                }
                case 90: {
                    BOBYQAOptimizer.printState(90);
                    d3 = 0.0;
                }
                case 100: {
                    BOBYQAOptimizer.printState(100);
                    if (n5 >= n2 - 1) {
                        n = 190;
                        continue block12;
                    }
                    d18 = 0.0;
                    d10 = 0.0;
                    d20 = 0.0;
                    for (int i = 0; i < n2; ++i) {
                        if (arrayRealVector2.getEntry(i) == 0.0) {
                            double d36 = this.trialStepPoint.getEntry(i);
                            d18 += d36 * d36;
                            d10 += this.trialStepPoint.getEntry(i) * arrayRealVector.getEntry(i);
                            d36 = arrayRealVector.getEntry(i);
                            d20 += d36 * d36;
                            arrayRealVector3.setEntry(i, this.trialStepPoint.getEntry(i));
                            continue;
                        }
                        arrayRealVector3.setEntry(i, 0.0);
                    }
                    n6 = n8;
                    n = 210;
                    continue block12;
                }
                case 120: {
                    double d37;
                    int n10;
                    BOBYQAOptimizer.printState(120);
                    ++n8;
                    d6 = d20 * d18 - d10 * d10;
                    if (d6 <= d26 * 1.0E-4 * d26) {
                        n = 190;
                        continue block12;
                    }
                    d6 = FastMath.sqrt(d6);
                    for (n10 = 0; n10 < n2; ++n10) {
                        if (arrayRealVector2.getEntry(n10) == 0.0) {
                            arrayRealVector3.setEntry(n10, (d10 * this.trialStepPoint.getEntry(n10) - d18 * arrayRealVector.getEntry(n10)) / d6);
                            continue;
                        }
                        arrayRealVector3.setEntry(n10, 0.0);
                    }
                    d11 = -d6;
                    d9 = 1.0;
                    n4 = -1;
                    for (n10 = 0; n10 < n2; ++n10) {
                        if (arrayRealVector2.getEntry(n10) != 0.0) continue;
                        d15 = this.trustRegionCenterOffset.getEntry(n10) + this.trialStepPoint.getEntry(n10) - this.lowerDifference.getEntry(n10);
                        d16 = this.upperDifference.getEntry(n10) - this.trustRegionCenterOffset.getEntry(n10) - this.trialStepPoint.getEntry(n10);
                        if (d15 <= 0.0) {
                            ++n5;
                            arrayRealVector2.setEntry(n10, -1.0);
                            n = 100;
                            break;
                        }
                        if (d16 <= 0.0) {
                            ++n5;
                            arrayRealVector2.setEntry(n10, 1.0);
                            n = 100;
                            break;
                        }
                        double d38 = this.trialStepPoint.getEntry(n10);
                        d37 = arrayRealVector3.getEntry(n10);
                        double d39 = d38 * d38 + d37 * d37;
                        d6 = d39 - (d38 = this.trustRegionCenterOffset.getEntry(n10) - this.lowerDifference.getEntry(n10)) * d38;
                        if (d6 > 0.0 && d9 * (d6 = FastMath.sqrt(d6) - arrayRealVector3.getEntry(n10)) > d15) {
                            d9 = d15 / d6;
                            n4 = n10;
                            d7 = -1.0;
                        }
                        if (!((d6 = d39 - (d38 = this.upperDifference.getEntry(n10) - this.trustRegionCenterOffset.getEntry(n10)) * d38) > 0.0) || !(d9 * (d6 = FastMath.sqrt(d6) + arrayRealVector3.getEntry(n10)) > d16)) continue;
                        d9 = d16 / d6;
                        n4 = n10;
                        d7 = 1.0;
                    }
                    n = 210;
                    continue block12;
                }
                case 150: {
                    double d40;
                    int n11;
                    BOBYQAOptimizer.printState(150);
                    double d29 = 0.0;
                    double d41 = 0.0;
                    double d42 = 0.0;
                    for (n11 = 0; n11 < n2; ++n11) {
                        if (arrayRealVector2.getEntry(n11) != 0.0) continue;
                        d29 += arrayRealVector3.getEntry(n11) * arrayRealVector4.getEntry(n11);
                        d41 += this.trialStepPoint.getEntry(n11) * arrayRealVector4.getEntry(n11);
                        d42 += this.trialStepPoint.getEntry(n11) * arrayRealVector5.getEntry(n11);
                    }
                    d17 = 0.0;
                    int n12 = -1;
                    d19 = 0.0;
                    int n13 = (int)(d9 * 17.0 + 3.1);
                    for (n11 = 0; n11 < n13; ++n11) {
                        d5 = d9 * (double)n11 / (double)n13;
                        d40 = (d5 + d5) / (1.0 + d5 * d5);
                        d6 = d29 + d5 * (d5 * d42 - d41 - d41);
                        d21 = d40 * (d5 * d10 - d11 - 0.5 * d40 * d6);
                        if (d21 > d17) {
                            d17 = d21;
                            n12 = n11;
                            d22 = d19;
                        } else if (n11 == n12 + 1) {
                            d23 = d21;
                        }
                        d19 = d21;
                    }
                    if (n12 < 0) {
                        n = 190;
                        continue block12;
                    }
                    if (n12 < n13) {
                        d6 = (d23 - d22) / (d17 + d17 - d22 - d23);
                        d5 = d9 * ((double)n12 + 0.5 * d6) / (double)n13;
                    }
                    double d43 = (1.0 - d5 * d5) / (1.0 + d5 * d5);
                    d40 = (d5 + d5) / (1.0 + d5 * d5);
                    d6 = d29 + d5 * (d5 * d42 - d41 - d41);
                    double d32 = d40 * (d5 * d10 - d11 - 0.5 * d40 * d6);
                    if (d32 <= 0.0) {
                        n = 190;
                        continue block12;
                    }
                    d10 = 0.0;
                    d20 = 0.0;
                    for (n11 = 0; n11 < n2; ++n11) {
                        arrayRealVector.setEntry(n11, arrayRealVector.getEntry(n11) + (d43 - 1.0) * arrayRealVector5.getEntry(n11) + d40 * arrayRealVector4.getEntry(n11));
                        if (arrayRealVector2.getEntry(n11) == 0.0) {
                            this.trialStepPoint.setEntry(n11, d43 * this.trialStepPoint.getEntry(n11) + d40 * arrayRealVector3.getEntry(n11));
                            d10 += this.trialStepPoint.getEntry(n11) * arrayRealVector.getEntry(n11);
                            double d44 = arrayRealVector.getEntry(n11);
                            d20 += d44 * d44;
                        }
                        arrayRealVector5.setEntry(n11, d43 * arrayRealVector5.getEntry(n11) + d40 * arrayRealVector4.getEntry(n11));
                    }
                    d26 += d32;
                    if (n4 >= 0 && n12 == n13) {
                        ++n5;
                        arrayRealVector2.setEntry(n4, d7);
                        n = 100;
                        continue block12;
                    }
                    if (d32 > d26 * 0.01) {
                        n = 120;
                        continue block12;
                    }
                }
                case 190: {
                    double d37;
                    BOBYQAOptimizer.printState(190);
                    d2 = 0.0;
                    for (int i = 0; i < n2; ++i) {
                        double d45 = FastMath.min(this.trustRegionCenterOffset.getEntry(i) + this.trialStepPoint.getEntry(i), this.upperDifference.getEntry(i));
                        this.newPoint.setEntry(i, FastMath.max(d45, this.lowerDifference.getEntry(i)));
                        if (arrayRealVector2.getEntry(i) == -1.0) {
                            this.newPoint.setEntry(i, this.lowerDifference.getEntry(i));
                        }
                        if (arrayRealVector2.getEntry(i) == 1.0) {
                            this.newPoint.setEntry(i, this.upperDifference.getEntry(i));
                        }
                        this.trialStepPoint.setEntry(i, this.newPoint.getEntry(i) - this.trustRegionCenterOffset.getEntry(i));
                        d37 = this.trialStepPoint.getEntry(i);
                        d2 += d37 * d37;
                    }
                    return new double[]{d2, d3};
                }
                case 210: {
                    int n14;
                    BOBYQAOptimizer.printState(210);
                    int n15 = 0;
                    for (int i = 0; i < n2; ++i) {
                        arrayRealVector4.setEntry(i, 0.0);
                        for (n14 = 0; n14 <= i; ++n14) {
                            if (n14 < i) {
                                arrayRealVector4.setEntry(i, arrayRealVector4.getEntry(i) + this.modelSecondDerivativesValues.getEntry(n15) * arrayRealVector3.getEntry(n14));
                            }
                            arrayRealVector4.setEntry(n14, arrayRealVector4.getEntry(n14) + this.modelSecondDerivativesValues.getEntry(n15) * arrayRealVector3.getEntry(i));
                            ++n15;
                        }
                    }
                    RealVector realVector = this.interpolationPoints.operate(arrayRealVector3).ebeMultiply(this.modelSecondDerivativesParameters);
                    for (n14 = 0; n14 < n3; ++n14) {
                        if (this.modelSecondDerivativesParameters.getEntry(n14) == 0.0) continue;
                        for (int i = 0; i < n2; ++i) {
                            arrayRealVector4.setEntry(i, arrayRealVector4.getEntry(i) + realVector.getEntry(n14) * this.interpolationPoints.getEntry(n14, i));
                        }
                    }
                    if (d3 != 0.0) {
                        n = 50;
                        continue block12;
                    }
                    if (n8 > n6) {
                        n = 150;
                        continue block12;
                    }
                    for (n14 = 0; n14 < n2; ++n14) {
                        arrayRealVector5.setEntry(n14, arrayRealVector4.getEntry(n14));
                    }
                    n = 120;
                    continue block12;
                }
            }
            break;
        }
        throw new MathIllegalStateException(LocalizedFormats.SIMPLE_MESSAGE, "trsbox");
    }

    private void update(double d, double d2, int n) {
        int n2;
        double d3;
        int n3;
        BOBYQAOptimizer.printMethod();
        int n4 = this.currentBest.getDimension();
        int n5 = this.numberOfInterpolationPoints;
        int n6 = n5 - n4 - 1;
        ArrayRealVector arrayRealVector = new ArrayRealVector(n5 + n4);
        double d4 = 0.0;
        for (n3 = 0; n3 < n5; ++n3) {
            for (int i = 0; i < n6; ++i) {
                d4 = FastMath.max(d4, FastMath.abs(this.zMatrix.getEntry(n3, i)));
            }
        }
        d4 *= 1.0E-20;
        for (n3 = 1; n3 < n6; ++n3) {
            double d5 = this.zMatrix.getEntry(n, n3);
            if (FastMath.abs(d5) > d4) {
                double d6 = this.zMatrix.getEntry(n, 0);
                double d7 = this.zMatrix.getEntry(n, n3);
                double d8 = FastMath.sqrt(d6 * d6 + d7 * d7);
                double d9 = this.zMatrix.getEntry(n, 0) / d8;
                double d10 = this.zMatrix.getEntry(n, n3) / d8;
                for (int i = 0; i < n5; ++i) {
                    d3 = d9 * this.zMatrix.getEntry(i, 0) + d10 * this.zMatrix.getEntry(i, n3);
                    this.zMatrix.setEntry(i, n3, d9 * this.zMatrix.getEntry(i, n3) - d10 * this.zMatrix.getEntry(i, 0));
                    this.zMatrix.setEntry(i, 0, d3);
                }
            }
            this.zMatrix.setEntry(n, n3, 0.0);
        }
        for (n3 = 0; n3 < n5; ++n3) {
            arrayRealVector.setEntry(n3, this.zMatrix.getEntry(n, 0) * this.zMatrix.getEntry(n3, 0));
        }
        double d11 = arrayRealVector.getEntry(n);
        double d12 = this.lagrangeValuesAtNewPoint.getEntry(n);
        this.lagrangeValuesAtNewPoint.setEntry(n, this.lagrangeValuesAtNewPoint.getEntry(n) - 1.0);
        double d13 = FastMath.sqrt(d2);
        double d14 = d12 / d13;
        double d15 = this.zMatrix.getEntry(n, 0) / d13;
        for (n2 = 0; n2 < n5; ++n2) {
            this.zMatrix.setEntry(n2, 0, d14 * this.zMatrix.getEntry(n2, 0) - d15 * this.lagrangeValuesAtNewPoint.getEntry(n2));
        }
        for (n2 = 0; n2 < n4; ++n2) {
            int n7 = n5 + n2;
            arrayRealVector.setEntry(n7, this.bMatrix.getEntry(n, n2));
            double d16 = (d11 * this.lagrangeValuesAtNewPoint.getEntry(n7) - d12 * arrayRealVector.getEntry(n7)) / d2;
            d3 = (-d * arrayRealVector.getEntry(n7) - d12 * this.lagrangeValuesAtNewPoint.getEntry(n7)) / d2;
            for (int i = 0; i <= n7; ++i) {
                this.bMatrix.setEntry(i, n2, this.bMatrix.getEntry(i, n2) + d16 * this.lagrangeValuesAtNewPoint.getEntry(i) + d3 * arrayRealVector.getEntry(i));
                if (i < n5) continue;
                this.bMatrix.setEntry(n7, i - n5, this.bMatrix.getEntry(i, n2));
            }
        }
    }

    private void setup(double[] dArray, double[] dArray2) {
        BOBYQAOptimizer.printMethod();
        double[] dArray3 = this.getStartPoint();
        int n = dArray3.length;
        if (n < 2) {
            throw new NumberIsTooSmallException(n, (Number)2, true);
        }
        int[] nArray = new int[]{n + 2, (n + 2) * (n + 1) / 2};
        if (this.numberOfInterpolationPoints < nArray[0] || this.numberOfInterpolationPoints > nArray[1]) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.NUMBER_OF_INTERPOLATION_POINTS, (Number)this.numberOfInterpolationPoints, nArray[0], nArray[1]);
        }
        this.boundDifference = new double[n];
        double d = 2.0 * this.initialTrustRegionRadius;
        double d2 = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            this.boundDifference[i] = dArray2[i] - dArray[i];
            d2 = FastMath.min(d2, this.boundDifference[i]);
        }
        if (d2 < d) {
            this.initialTrustRegionRadius = d2 / 3.0;
        }
        this.bMatrix = new Array2DRowRealMatrix(n + this.numberOfInterpolationPoints, n);
        this.zMatrix = new Array2DRowRealMatrix(this.numberOfInterpolationPoints, this.numberOfInterpolationPoints - n - 1);
        this.interpolationPoints = new Array2DRowRealMatrix(this.numberOfInterpolationPoints, n);
        this.originShift = new ArrayRealVector(n);
        this.fAtInterpolationPoints = new ArrayRealVector(this.numberOfInterpolationPoints);
        this.trustRegionCenterOffset = new ArrayRealVector(n);
        this.gradientAtTrustRegionCenter = new ArrayRealVector(n);
        this.lowerDifference = new ArrayRealVector(n);
        this.upperDifference = new ArrayRealVector(n);
        this.modelSecondDerivativesParameters = new ArrayRealVector(this.numberOfInterpolationPoints);
        this.newPoint = new ArrayRealVector(n);
        this.alternativeNewPoint = new ArrayRealVector(n);
        this.trialStepPoint = new ArrayRealVector(n);
        this.lagrangeValuesAtNewPoint = new ArrayRealVector(n + this.numberOfInterpolationPoints);
        this.modelSecondDerivativesValues = new ArrayRealVector(n * (n + 1) / 2);
    }

    private static String caller(int n) {
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        StackTraceElement stackTraceElement = stackTraceElementArray[n];
        return stackTraceElement.getMethodName() + " (at line " + stackTraceElement.getLineNumber() + ")";
    }

    private static void printState(int n) {
    }

    private static void printMethod() {
    }

    private static class PathIsExploredException
    extends RuntimeException {
        private static final long serialVersionUID = 745350979634801853L;
        private static final String PATH_IS_EXPLORED = "If this exception is thrown, just remove it from the code";

        PathIsExploredException() {
            super("If this exception is thrown, just remove it from the code " + BOBYQAOptimizer.caller(3));
        }
    }
}

