/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.nonlinear.vector.jacobian;

import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.DiagonalMatrix;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointVectorValuePair;
import org.apache.commons.math3.optim.nonlinear.vector.JacobianMultivariateVectorOptimizer;
import org.apache.commons.math3.optim.nonlinear.vector.Weight;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class AbstractLeastSquaresOptimizer
extends JacobianMultivariateVectorOptimizer {
    private RealMatrix weightMatrixSqrt;
    private double cost;

    protected AbstractLeastSquaresOptimizer(ConvergenceChecker<PointVectorValuePair> convergenceChecker) {
        super(convergenceChecker);
    }

    protected RealMatrix computeWeightedJacobian(double[] dArray) {
        return this.weightMatrixSqrt.multiply(MatrixUtils.createRealMatrix(this.computeJacobian(dArray)));
    }

    protected double computeCost(double[] dArray) {
        ArrayRealVector arrayRealVector = new ArrayRealVector(dArray);
        return FastMath.sqrt(arrayRealVector.dotProduct(this.getWeight().operate(arrayRealVector)));
    }

    public double getRMS() {
        return FastMath.sqrt(this.getChiSquare() / (double)this.getTargetSize());
    }

    public double getChiSquare() {
        return this.cost * this.cost;
    }

    public RealMatrix getWeightSquareRoot() {
        return this.weightMatrixSqrt.copy();
    }

    protected void setCost(double d) {
        this.cost = d;
    }

    public double[][] computeCovariances(double[] dArray, double d) {
        RealMatrix realMatrix = this.computeWeightedJacobian(dArray);
        RealMatrix realMatrix2 = realMatrix.transpose().multiply(realMatrix);
        DecompositionSolver decompositionSolver = new QRDecomposition(realMatrix2, d).getSolver();
        return decompositionSolver.getInverse().getData();
    }

    public double[] computeSigma(double[] dArray, double d) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        double[][] dArray3 = this.computeCovariances(dArray, d);
        for (int i = 0; i < n; ++i) {
            dArray2[i] = FastMath.sqrt(dArray3[i][i]);
        }
        return dArray2;
    }

    @Override
    public PointVectorValuePair optimize(OptimizationData ... optimizationDataArray) {
        return super.optimize(optimizationDataArray);
    }

    protected double[] computeResiduals(double[] dArray) {
        double[] dArray2 = this.getTarget();
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray2.length, dArray.length);
        }
        double[] dArray3 = new double[dArray2.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray3[i] = dArray2[i] - dArray[i];
        }
        return dArray3;
    }

    @Override
    protected void parseOptimizationData(OptimizationData ... optimizationDataArray) {
        super.parseOptimizationData(optimizationDataArray);
        for (OptimizationData optimizationData : optimizationDataArray) {
            if (!(optimizationData instanceof Weight)) continue;
            this.weightMatrixSqrt = this.squareRoot(((Weight)optimizationData).getWeight());
            break;
        }
    }

    private RealMatrix squareRoot(RealMatrix realMatrix) {
        if (realMatrix instanceof DiagonalMatrix) {
            int n = realMatrix.getRowDimension();
            DiagonalMatrix diagonalMatrix = new DiagonalMatrix(n);
            for (int i = 0; i < n; ++i) {
                diagonalMatrix.setEntry(i, i, FastMath.sqrt(realMatrix.getEntry(i, i)));
            }
            return diagonalMatrix;
        }
        EigenDecomposition eigenDecomposition = new EigenDecomposition(realMatrix);
        return eigenDecomposition.getSquareRoot();
    }
}

