/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.nonlinear.vector.jacobian;

import org.apache.commons.math3.exception.ConvergenceException;
import org.apache.commons.math3.exception.MathInternalError;
import org.apache.commons.math3.exception.MathUnsupportedOperationException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.PointVectorValuePair;
import org.apache.commons.math3.optim.nonlinear.vector.jacobian.AbstractLeastSquaresOptimizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class GaussNewtonOptimizer
extends AbstractLeastSquaresOptimizer {
    private final boolean useLU;

    public GaussNewtonOptimizer(ConvergenceChecker<PointVectorValuePair> convergenceChecker) {
        this(true, convergenceChecker);
    }

    public GaussNewtonOptimizer(boolean bl, ConvergenceChecker<PointVectorValuePair> convergenceChecker) {
        super(convergenceChecker);
        this.useLU = bl;
    }

    @Override
    public PointVectorValuePair doOptimize() {
        this.checkParameters();
        ConvergenceChecker<PointVectorValuePair> convergenceChecker = this.getConvergenceChecker();
        if (convergenceChecker == null) {
            throw new NullArgumentException();
        }
        double[] dArray = this.getTarget();
        int n = dArray.length;
        RealMatrix realMatrix = this.getWeight();
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = realMatrix.getEntry(i, i);
        }
        double[] dArray3 = this.getStartPoint();
        int n2 = dArray3.length;
        PointVectorValuePair pointVectorValuePair = null;
        boolean bl = false;
        while (!bl) {
            Object object;
            this.incrementIterationCount();
            PointVectorValuePair pointVectorValuePair2 = pointVectorValuePair;
            double[] dArray4 = this.computeObjectiveValue(dArray3);
            double[] dArray5 = this.computeResiduals(dArray4);
            RealMatrix realMatrix2 = this.computeWeightedJacobian(dArray3);
            pointVectorValuePair = new PointVectorValuePair(dArray3, dArray4);
            double[] dArray6 = new double[n2];
            double[][] dArray7 = new double[n2][n2];
            for (int i = 0; i < n; ++i) {
                int n3;
                object = realMatrix2.getRow(i);
                double d = dArray2[i];
                double d2 = dArray5[i];
                double d3 = d * d2;
                for (n3 = 0; n3 < n2; ++n3) {
                    int n4 = n3;
                    dArray6[n4] = dArray6[n4] + d3 * object[n3];
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    double[] dArray8 = dArray7[n3];
                    double d4 = d * object[n3];
                    for (int j = 0; j < n2; ++j) {
                        int n5 = j;
                        dArray8[n5] = dArray8[n5] + d4 * object[j];
                    }
                }
            }
            if (pointVectorValuePair2 != null && (bl = convergenceChecker.converged(this.getIterations(), pointVectorValuePair2, pointVectorValuePair))) {
                this.setCost(this.computeCost(dArray5));
                return pointVectorValuePair;
            }
            try {
                BlockRealMatrix blockRealMatrix = new BlockRealMatrix(dArray7);
                object = this.useLU ? new LUDecomposition(blockRealMatrix).getSolver() : new QRDecomposition(blockRealMatrix).getSolver();
                double[] dArray9 = object.solve(new ArrayRealVector(dArray6, false)).toArray();
                for (int i = 0; i < n2; ++i) {
                    int n6 = i;
                    dArray3[n6] = dArray3[n6] + dArray9[i];
                }
            }
            catch (SingularMatrixException singularMatrixException) {
                throw new ConvergenceException(LocalizedFormats.UNABLE_TO_SOLVE_SINGULAR_PROBLEM, new Object[0]);
            }
        }
        throw new MathInternalError();
    }

    private void checkParameters() {
        if (this.getLowerBound() != null || this.getUpperBound() != null) {
            throw new MathUnsupportedOperationException(LocalizedFormats.CONSTRAINT, new Object[0]);
        }
    }
}

