/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.nonlinear.vector.jacobian;

import java.util.Arrays;
import org.apache.commons.math3.exception.ConvergenceException;
import org.apache.commons.math3.exception.MathUnsupportedOperationException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.PointVectorValuePair;
import org.apache.commons.math3.optim.nonlinear.vector.jacobian.AbstractLeastSquaresOptimizer;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class LevenbergMarquardtOptimizer
extends AbstractLeastSquaresOptimizer {
    private static final double TWO_EPS = 2.0 * Precision.EPSILON;
    private int solvedCols;
    private double[] diagR;
    private double[] jacNorm;
    private double[] beta;
    private int[] permutation;
    private int rank;
    private double lmPar;
    private double[] lmDir;
    private final double initialStepBoundFactor;
    private final double costRelativeTolerance;
    private final double parRelativeTolerance;
    private final double orthoTolerance;
    private final double qrRankingThreshold;
    private double[] weightedResidual;
    private double[][] weightedJacobian;

    public LevenbergMarquardtOptimizer() {
        this(100.0, 1.0E-10, 1.0E-10, 1.0E-10, Precision.SAFE_MIN);
    }

    public LevenbergMarquardtOptimizer(ConvergenceChecker<PointVectorValuePair> convergenceChecker) {
        this(100.0, convergenceChecker, 1.0E-10, 1.0E-10, 1.0E-10, Precision.SAFE_MIN);
    }

    public LevenbergMarquardtOptimizer(double d, ConvergenceChecker<PointVectorValuePair> convergenceChecker, double d2, double d3, double d4, double d5) {
        super(convergenceChecker);
        this.initialStepBoundFactor = d;
        this.costRelativeTolerance = d2;
        this.parRelativeTolerance = d3;
        this.orthoTolerance = d4;
        this.qrRankingThreshold = d5;
    }

    public LevenbergMarquardtOptimizer(double d, double d2, double d3) {
        this(100.0, d, d2, d3, Precision.SAFE_MIN);
    }

    public LevenbergMarquardtOptimizer(double d, double d2, double d3, double d4, double d5) {
        super((ConvergenceChecker<PointVectorValuePair>)null);
        this.initialStepBoundFactor = d;
        this.costRelativeTolerance = d2;
        this.parRelativeTolerance = d3;
        this.orthoTolerance = d4;
        this.qrRankingThreshold = d5;
    }

    @Override
    protected PointVectorValuePair doOptimize() {
        this.checkParameters();
        int n = this.getTarget().length;
        double[] dArray = this.getStartPoint();
        int n2 = dArray.length;
        this.solvedCols = FastMath.min(n, n2);
        this.diagR = new double[n2];
        this.jacNorm = new double[n2];
        this.beta = new double[n2];
        this.permutation = new int[n2];
        this.lmDir = new double[n2];
        double d = 0.0;
        double d2 = 0.0;
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        double[] dArray7 = new double[n2];
        double[] dArray8 = new double[n2];
        double[] dArray9 = new double[n2];
        RealMatrix realMatrix = this.getWeightSquareRoot();
        double[] dArray10 = this.computeObjectiveValue(dArray);
        double[] dArray11 = this.computeResiduals(dArray10);
        PointVectorValuePair pointVectorValuePair = new PointVectorValuePair(dArray, dArray10);
        double d3 = this.computeCost(dArray11);
        this.lmPar = 0.0;
        boolean bl = true;
        ConvergenceChecker<PointVectorValuePair> convergenceChecker = this.getConvergenceChecker();
        block0: while (true) {
            double d4;
            int n3;
            int n4;
            this.incrementIterationCount();
            PointVectorValuePair pointVectorValuePair2 = pointVectorValuePair;
            this.qrDecomposition(this.computeWeightedJacobian(dArray));
            this.weightedResidual = realMatrix.operate(dArray11);
            for (n4 = 0; n4 < n; ++n4) {
                dArray6[n4] = this.weightedResidual[n4];
            }
            this.qTy(dArray6);
            for (n4 = 0; n4 < this.solvedCols; ++n4) {
                int n5 = this.permutation[n4];
                this.weightedJacobian[n4][n5] = this.diagR[n5];
            }
            if (bl) {
                d2 = 0.0;
                for (n4 = 0; n4 < n2; ++n4) {
                    double d5 = this.jacNorm[n4];
                    if (d5 == 0.0) {
                        d5 = 1.0;
                    }
                    double d6 = d5 * dArray[n4];
                    d2 += d6 * d6;
                    dArray2[n4] = d5;
                }
                d = (d2 = FastMath.sqrt(d2)) == 0.0 ? this.initialStepBoundFactor : this.initialStepBoundFactor * d2;
            }
            double d7 = 0.0;
            if (d3 != 0.0) {
                for (n3 = 0; n3 < this.solvedCols; ++n3) {
                    int n6 = this.permutation[n3];
                    d4 = this.jacNorm[n6];
                    if (d4 == 0.0) continue;
                    double d8 = 0.0;
                    for (int i = 0; i <= n3; ++i) {
                        d8 += this.weightedJacobian[i][n6] * dArray6[i];
                    }
                    d7 = FastMath.max(d7, FastMath.abs(d8) / (d4 * d3));
                }
            }
            if (d7 <= this.orthoTolerance) {
                this.setCost(d3);
                return pointVectorValuePair;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                dArray2[n3] = FastMath.max(dArray2[n3], this.jacNorm[n3]);
            }
            double d9 = 0.0;
            do {
                int n7;
                double d10;
                double d11;
                if (!(d9 < 1.0E-4)) continue block0;
                for (int i = 0; i < this.solvedCols; ++i) {
                    int n8 = this.permutation[i];
                    dArray3[n8] = dArray[n8];
                }
                d4 = d3;
                double[] dArray12 = this.weightedResidual;
                this.weightedResidual = dArray4;
                dArray4 = dArray12;
                dArray12 = dArray10;
                dArray10 = dArray5;
                dArray5 = dArray12;
                this.determineLMParameter(dArray6, d, dArray2, dArray7, dArray8, dArray9);
                double d12 = 0.0;
                for (int i = 0; i < this.solvedCols; ++i) {
                    int n9 = this.permutation[i];
                    this.lmDir[n9] = -this.lmDir[n9];
                    dArray[n9] = dArray3[n9] + this.lmDir[n9];
                    d11 = dArray2[n9] * this.lmDir[n9];
                    d12 += d11 * d11;
                }
                d12 = FastMath.sqrt(d12);
                if (bl) {
                    d = FastMath.min(d, d12);
                }
                dArray10 = this.computeObjectiveValue(dArray);
                dArray11 = this.computeResiduals(dArray10);
                pointVectorValuePair = new PointVectorValuePair(dArray, dArray10);
                d3 = this.computeCost(dArray11);
                double d13 = -1.0;
                if (0.1 * d3 < d4) {
                    d11 = d3 / d4;
                    d13 = 1.0 - d11 * d11;
                }
                for (int i = 0; i < this.solvedCols; ++i) {
                    int n10 = this.permutation[i];
                    d10 = this.lmDir[n10];
                    dArray7[i] = 0.0;
                    for (int j = 0; j <= i; ++j) {
                        int n11 = j;
                        dArray7[n11] = dArray7[n11] + this.weightedJacobian[j][n10] * d10;
                    }
                }
                d11 = 0.0;
                for (int i = 0; i < this.solvedCols; ++i) {
                    d11 += dArray7[i] * dArray7[i];
                }
                d10 = d4 * d4;
                double d14 = this.lmPar * d12 * d12 / d10;
                double d15 = (d11 /= d10) + 2.0 * d14;
                double d16 = -(d11 + d14);
                double d17 = d9 = d15 == 0.0 ? 0.0 : d13 / d15;
                if (d9 <= 0.25) {
                    double d18;
                    double d19 = d18 = d13 < 0.0 ? 0.5 * d16 / (d16 + 0.5 * d13) : 0.5;
                    if (0.1 * d3 >= d4 || d18 < 0.1) {
                        d18 = 0.1;
                    }
                    d = d18 * FastMath.min(d, 10.0 * d12);
                    this.lmPar /= d18;
                } else if (this.lmPar == 0.0 || d9 >= 0.75) {
                    d = 2.0 * d12;
                    this.lmPar *= 0.5;
                }
                if (d9 >= 1.0E-4) {
                    bl = false;
                    d2 = 0.0;
                    for (n7 = 0; n7 < n2; ++n7) {
                        double d20 = dArray2[n7] * dArray[n7];
                        d2 += d20 * d20;
                    }
                    d2 = FastMath.sqrt(d2);
                    if (convergenceChecker != null && convergenceChecker.converged(this.getIterations(), pointVectorValuePair2, pointVectorValuePair)) {
                        this.setCost(d3);
                        return pointVectorValuePair;
                    }
                } else {
                    d3 = d4;
                    for (n7 = 0; n7 < this.solvedCols; ++n7) {
                        int n12 = this.permutation[n7];
                        dArray[n12] = dArray3[n12];
                    }
                    dArray12 = this.weightedResidual;
                    this.weightedResidual = dArray4;
                    dArray4 = dArray12;
                    dArray12 = dArray10;
                    dArray10 = dArray5;
                    dArray5 = dArray12;
                    pointVectorValuePair = new PointVectorValuePair(dArray, dArray10);
                }
                if (FastMath.abs(d13) <= this.costRelativeTolerance && d15 <= this.costRelativeTolerance && d9 <= 2.0 || d <= this.parRelativeTolerance * d2) {
                    this.setCost(d3);
                    return pointVectorValuePair;
                }
                if (FastMath.abs(d13) <= TWO_EPS && d15 <= TWO_EPS && d9 <= 2.0) {
                    throw new ConvergenceException(LocalizedFormats.TOO_SMALL_COST_RELATIVE_TOLERANCE, this.costRelativeTolerance);
                }
                if (!(d <= TWO_EPS * d2)) continue;
                throw new ConvergenceException(LocalizedFormats.TOO_SMALL_PARAMETERS_RELATIVE_TOLERANCE, this.parRelativeTolerance);
            } while (!(d7 <= TWO_EPS));
            break;
        }
        throw new ConvergenceException(LocalizedFormats.TOO_SMALL_ORTHOGONALITY_TOLERANCE, this.orthoTolerance);
    }

    private void determineLMParameter(double[] dArray, double d, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        double d2;
        int n;
        int n2;
        int n3;
        int n4 = this.weightedJacobian[0].length;
        for (n3 = 0; n3 < this.rank; ++n3) {
            this.lmDir[this.permutation[n3]] = dArray[n3];
        }
        for (n3 = this.rank; n3 < n4; ++n3) {
            this.lmDir[this.permutation[n3]] = 0.0;
        }
        for (n3 = this.rank - 1; n3 >= 0; --n3) {
            int n5 = this.permutation[n3];
            double d3 = this.lmDir[n5] / this.diagR[n5];
            for (int i = 0; i < n3; ++i) {
                int n6 = this.permutation[i];
                this.lmDir[n6] = this.lmDir[n6] - d3 * this.weightedJacobian[i][n5];
            }
            this.lmDir[n5] = d3;
        }
        double d4 = 0.0;
        for (int i = 0; i < this.solvedCols; ++i) {
            double d5;
            int n7 = this.permutation[i];
            dArray3[n7] = d5 = dArray2[n7] * this.lmDir[n7];
            d4 += d5 * d5;
        }
        double d6 = (d4 = FastMath.sqrt(d4)) - d;
        if (d6 <= 0.1 * d) {
            this.lmPar = 0.0;
            return;
        }
        double d7 = 0.0;
        if (this.rank == this.solvedCols) {
            for (n2 = 0; n2 < this.solvedCols; ++n2) {
                int n8 = n = this.permutation[n2];
                dArray3[n8] = dArray3[n8] * (dArray2[n] / d4);
            }
            double d8 = 0.0;
            for (n2 = 0; n2 < this.solvedCols; ++n2) {
                double d9;
                n = this.permutation[n2];
                d2 = 0.0;
                for (int i = 0; i < n2; ++i) {
                    d2 += this.weightedJacobian[i][n] * dArray3[this.permutation[i]];
                }
                dArray3[n] = d9 = (dArray3[n] - d2) / this.diagR[n];
                d8 += d9 * d9;
            }
            d7 = d6 / (d * d8);
        }
        double d10 = 0.0;
        for (n2 = 0; n2 < this.solvedCols; ++n2) {
            n = this.permutation[n2];
            d2 = 0.0;
            for (int i = 0; i <= n2; ++i) {
                d2 += this.weightedJacobian[i][n] * dArray[i];
            }
            d10 += (d2 /= dArray2[n]) * d2;
        }
        double d11 = FastMath.sqrt(d10);
        d2 = d11 / d;
        if (d2 == 0.0) {
            d2 = Precision.SAFE_MIN / FastMath.min(d, 0.1);
        }
        this.lmPar = FastMath.min(d2, FastMath.max(this.lmPar, d7));
        if (this.lmPar == 0.0) {
            this.lmPar = d11 / d4;
        }
        for (int i = 10; i >= 0; --i) {
            int n9;
            int n10;
            double d12;
            int n11;
            int n12;
            if (this.lmPar == 0.0) {
                this.lmPar = FastMath.max(Precision.SAFE_MIN, 0.001 * d2);
            }
            double d13 = FastMath.sqrt(this.lmPar);
            for (n12 = 0; n12 < this.solvedCols; ++n12) {
                n11 = this.permutation[n12];
                dArray3[n11] = d13 * dArray2[n11];
            }
            this.determineLMDirection(dArray, dArray3, dArray4, dArray5);
            d4 = 0.0;
            for (n12 = 0; n12 < this.solvedCols; ++n12) {
                n11 = this.permutation[n12];
                dArray5[n11] = d12 = dArray2[n11] * this.lmDir[n11];
                d4 += d12 * d12;
            }
            d4 = FastMath.sqrt(d4);
            double d14 = d6;
            d6 = d4 - d;
            if (FastMath.abs(d6) <= 0.1 * d || d7 == 0.0 && d6 <= d14 && d14 < 0.0) {
                return;
            }
            for (n10 = 0; n10 < this.solvedCols; ++n10) {
                n9 = this.permutation[n10];
                dArray3[n9] = dArray5[n9] * dArray2[n9] / d4;
            }
            for (n10 = 0; n10 < this.solvedCols; ++n10) {
                int n13 = n9 = this.permutation[n10];
                dArray3[n13] = dArray3[n13] / dArray4[n10];
                double d15 = dArray3[n9];
                for (int j = n10 + 1; j < this.solvedCols; ++j) {
                    int n14 = this.permutation[j];
                    dArray3[n14] = dArray3[n14] - this.weightedJacobian[j][n9] * d15;
                }
            }
            d10 = 0.0;
            for (n10 = 0; n10 < this.solvedCols; ++n10) {
                double d16 = dArray3[this.permutation[n10]];
                d10 += d16 * d16;
            }
            d12 = d6 / (d * d10);
            if (d6 > 0.0) {
                d7 = FastMath.max(d7, this.lmPar);
            } else if (d6 < 0.0) {
                d2 = FastMath.min(d2, this.lmPar);
            }
            this.lmPar = FastMath.max(d7, this.lmPar + d12);
        }
    }

    private void determineLMDirection(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n;
        int n2;
        for (n2 = 0; n2 < this.solvedCols; ++n2) {
            n = this.permutation[n2];
            for (int i = n2 + 1; i < this.solvedCols; ++i) {
                this.weightedJacobian[i][n] = this.weightedJacobian[n2][this.permutation[i]];
            }
            this.lmDir[n2] = this.diagR[n];
            dArray4[n2] = dArray[n2];
        }
        for (n2 = 0; n2 < this.solvedCols; ++n2) {
            n = this.permutation[n2];
            double d = dArray2[n];
            if (d != 0.0) {
                Arrays.fill(dArray3, n2 + 1, dArray3.length, 0.0);
            }
            dArray3[n2] = d;
            double d2 = 0.0;
            for (int i = n2; i < this.solvedCols; ++i) {
                double d3;
                double d4;
                double d5;
                int n3 = this.permutation[i];
                if (dArray3[i] == 0.0) continue;
                double d6 = this.weightedJacobian[i][n3];
                if (FastMath.abs(d6) < FastMath.abs(dArray3[i])) {
                    d5 = d6 / dArray3[i];
                    d4 = 1.0 / FastMath.sqrt(1.0 + d5 * d5);
                    d3 = d4 * d5;
                } else {
                    d5 = dArray3[i] / d6;
                    d3 = 1.0 / FastMath.sqrt(1.0 + d5 * d5);
                    d4 = d3 * d5;
                }
                this.weightedJacobian[i][n3] = d3 * d6 + d4 * dArray3[i];
                d5 = d3 * dArray4[i] + d4 * d2;
                d2 = -d4 * dArray4[i] + d3 * d2;
                dArray4[i] = d5;
                for (int j = i + 1; j < this.solvedCols; ++j) {
                    double d7 = this.weightedJacobian[j][n3];
                    double d8 = d3 * d7 + d4 * dArray3[j];
                    dArray3[j] = -d4 * d7 + d3 * dArray3[j];
                    this.weightedJacobian[j][n3] = d8;
                }
            }
            dArray3[n2] = this.weightedJacobian[n2][this.permutation[n2]];
            this.weightedJacobian[n2][this.permutation[n2]] = this.lmDir[n2];
        }
        n2 = this.solvedCols;
        for (n = 0; n < this.solvedCols; ++n) {
            if (dArray3[n] == 0.0 && n2 == this.solvedCols) {
                n2 = n;
            }
            if (n2 >= this.solvedCols) continue;
            dArray4[n] = 0.0;
        }
        if (n2 > 0) {
            for (n = n2 - 1; n >= 0; --n) {
                int n4 = this.permutation[n];
                double d = 0.0;
                for (int i = n + 1; i < n2; ++i) {
                    d += this.weightedJacobian[i][n4] * dArray4[i];
                }
                dArray4[n] = (dArray4[n] - d) / dArray3[n];
            }
        }
        for (n = 0; n < this.lmDir.length; ++n) {
            this.lmDir[this.permutation[n]] = dArray4[n];
        }
    }

    private void qrDecomposition(RealMatrix realMatrix) {
        int n;
        this.weightedJacobian = realMatrix.scalarMultiply(-1.0).getData();
        int n2 = this.weightedJacobian.length;
        int n3 = this.weightedJacobian[0].length;
        for (n = 0; n < n3; ++n) {
            this.permutation[n] = n;
            double d = 0.0;
            for (int i = 0; i < n2; ++i) {
                double d2 = this.weightedJacobian[i][n];
                d += d2 * d2;
            }
            this.jacNorm[n] = FastMath.sqrt(d);
        }
        for (n = 0; n < n3; ++n) {
            double d;
            double d3;
            int n4;
            int n5 = -1;
            double d4 = Double.NEGATIVE_INFINITY;
            for (n4 = n; n4 < n3; ++n4) {
                d3 = 0.0;
                for (int i = n; i < n2; ++i) {
                    double d5 = this.weightedJacobian[i][this.permutation[n4]];
                    d3 += d5 * d5;
                }
                if (Double.isInfinite(d3) || Double.isNaN(d3)) {
                    throw new ConvergenceException(LocalizedFormats.UNABLE_TO_PERFORM_QR_DECOMPOSITION_ON_JACOBIAN, n2, n3);
                }
                if (!(d3 > d4)) continue;
                n5 = n4;
                d4 = d3;
            }
            if (d4 <= this.qrRankingThreshold) {
                this.rank = n;
                return;
            }
            n4 = this.permutation[n5];
            this.permutation[n5] = this.permutation[n];
            this.permutation[n] = n4;
            d3 = this.weightedJacobian[n][n4];
            double d6 = d3 > 0.0 ? -FastMath.sqrt(d4) : FastMath.sqrt(d4);
            this.beta[n4] = d = 1.0 / (d4 - d3 * d6);
            this.diagR[n4] = d6;
            double[] dArray = this.weightedJacobian[n];
            int n6 = n4;
            dArray[n6] = dArray[n6] - d6;
            for (int i = n3 - 1 - n; i > 0; --i) {
                int n7;
                double d7 = 0.0;
                for (n7 = n; n7 < n2; ++n7) {
                    d7 += this.weightedJacobian[n7][n4] * this.weightedJacobian[n7][this.permutation[n + i]];
                }
                d7 *= d;
                for (n7 = n; n7 < n2; ++n7) {
                    double[] dArray2 = this.weightedJacobian[n7];
                    int n8 = this.permutation[n + i];
                    dArray2[n8] = dArray2[n8] - d7 * this.weightedJacobian[n7][n4];
                }
            }
        }
        this.rank = this.solvedCols;
    }

    private void qTy(double[] dArray) {
        int n = this.weightedJacobian.length;
        int n2 = this.weightedJacobian[0].length;
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = this.permutation[i];
            double d = 0.0;
            for (n3 = i; n3 < n; ++n3) {
                d += this.weightedJacobian[n3][n4] * dArray[n3];
            }
            d *= this.beta[n4];
            for (n3 = i; n3 < n; ++n3) {
                int n5 = n3;
                dArray[n5] = dArray[n5] - d * this.weightedJacobian[n3][n4];
            }
        }
    }

    private void checkParameters() {
        if (this.getLowerBound() != null || this.getUpperBound() != null) {
            throw new MathUnsupportedOperationException(LocalizedFormats.CONSTRAINT, new Object[0]);
        }
    }
}

