/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.univariate;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.optim.BaseOptimizer;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.univariate.SearchInterval;
import org.apache.commons.math3.optim.univariate.UnivariateObjectiveFunction;
import org.apache.commons.math3.optim.univariate.UnivariatePointValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UnivariateOptimizer
extends BaseOptimizer<UnivariatePointValuePair> {
    private UnivariateFunction function;
    private GoalType goal;
    private double start;
    private double min;
    private double max;

    protected UnivariateOptimizer(ConvergenceChecker<UnivariatePointValuePair> convergenceChecker) {
        super(convergenceChecker);
    }

    @Override
    public UnivariatePointValuePair optimize(OptimizationData ... optimizationDataArray) {
        return (UnivariatePointValuePair)super.optimize(optimizationDataArray);
    }

    public GoalType getGoalType() {
        return this.goal;
    }

    @Override
    protected void parseOptimizationData(OptimizationData ... optimizationDataArray) {
        super.parseOptimizationData(optimizationDataArray);
        for (OptimizationData optimizationData : optimizationDataArray) {
            if (optimizationData instanceof SearchInterval) {
                SearchInterval searchInterval = (SearchInterval)optimizationData;
                this.min = searchInterval.getMin();
                this.max = searchInterval.getMax();
                this.start = searchInterval.getStartValue();
                continue;
            }
            if (optimizationData instanceof UnivariateObjectiveFunction) {
                this.function = ((UnivariateObjectiveFunction)optimizationData).getObjectiveFunction();
                continue;
            }
            if (!(optimizationData instanceof GoalType)) continue;
            this.goal = (GoalType)optimizationData;
        }
    }

    public double getStartValue() {
        return this.start;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    protected double computeObjectiveValue(double d) {
        super.incrementEvaluationCount();
        return this.function.value(d);
    }
}

