/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.exception.ConvergenceException;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.optimization.BaseMultivariateVectorOptimizer;
import org.apache.commons.math3.optimization.ConvergenceChecker;
import org.apache.commons.math3.optimization.PointVectorValuePair;
import org.apache.commons.math3.random.RandomVectorGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class BaseMultivariateVectorMultiStartOptimizer<FUNC extends MultivariateVectorFunction>
implements BaseMultivariateVectorOptimizer<FUNC> {
    private final BaseMultivariateVectorOptimizer<FUNC> optimizer;
    private int maxEvaluations;
    private int totalEvaluations;
    private int starts;
    private RandomVectorGenerator generator;
    private PointVectorValuePair[] optima;

    protected BaseMultivariateVectorMultiStartOptimizer(BaseMultivariateVectorOptimizer<FUNC> baseMultivariateVectorOptimizer, int n, RandomVectorGenerator randomVectorGenerator) {
        if (baseMultivariateVectorOptimizer == null || randomVectorGenerator == null) {
            throw new NullArgumentException();
        }
        if (n < 1) {
            throw new NotStrictlyPositiveException(n);
        }
        this.optimizer = baseMultivariateVectorOptimizer;
        this.starts = n;
        this.generator = randomVectorGenerator;
    }

    public PointVectorValuePair[] getOptima() {
        if (this.optima == null) {
            throw new MathIllegalStateException(LocalizedFormats.NO_OPTIMUM_COMPUTED_YET, new Object[0]);
        }
        return (PointVectorValuePair[])this.optima.clone();
    }

    @Override
    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    @Override
    public int getEvaluations() {
        return this.totalEvaluations;
    }

    @Override
    public ConvergenceChecker<PointVectorValuePair> getConvergenceChecker() {
        return this.optimizer.getConvergenceChecker();
    }

    @Override
    public PointVectorValuePair optimize(int n, FUNC FUNC, double[] dArray, double[] dArray2, double[] dArray3) {
        this.maxEvaluations = n;
        RuntimeException runtimeException = null;
        this.optima = new PointVectorValuePair[this.starts];
        this.totalEvaluations = 0;
        for (int i = 0; i < this.starts; ++i) {
            try {
                this.optima[i] = this.optimizer.optimize(n - this.totalEvaluations, FUNC, dArray, dArray2, i == 0 ? dArray3 : this.generator.nextVector());
            }
            catch (ConvergenceException convergenceException) {
                this.optima[i] = null;
            }
            catch (RuntimeException runtimeException2) {
                runtimeException = runtimeException2;
                this.optima[i] = null;
            }
            this.totalEvaluations += this.optimizer.getEvaluations();
        }
        this.sortPairs(dArray, dArray2);
        if (this.optima[0] == null) {
            throw runtimeException;
        }
        return this.optima[0];
    }

    private void sortPairs(final double[] dArray, final double[] dArray2) {
        Arrays.sort(this.optima, new Comparator<PointVectorValuePair>(){

            @Override
            public int compare(PointVectorValuePair pointVectorValuePair, PointVectorValuePair pointVectorValuePair2) {
                if (pointVectorValuePair == null) {
                    return pointVectorValuePair2 == null ? 0 : 1;
                }
                if (pointVectorValuePair2 == null) {
                    return -1;
                }
                return Double.compare(this.weightedResidual(pointVectorValuePair), this.weightedResidual(pointVectorValuePair2));
            }

            private double weightedResidual(PointVectorValuePair pointVectorValuePair) {
                double[] dArray3 = pointVectorValuePair.getValueRef();
                double d = 0.0;
                for (int i = 0; i < dArray3.length; ++i) {
                    double d2 = dArray3[i] - dArray[i];
                    d += dArray2[i] * d2 * d2;
                }
                return d;
            }
        });
    }
}

