/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.direct;

import org.apache.commons.math3.analysis.MultivariateVectorFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.optimization.BaseMultivariateVectorOptimizer;
import org.apache.commons.math3.optimization.ConvergenceChecker;
import org.apache.commons.math3.optimization.InitialGuess;
import org.apache.commons.math3.optimization.OptimizationData;
import org.apache.commons.math3.optimization.PointVectorValuePair;
import org.apache.commons.math3.optimization.SimpleVectorValueChecker;
import org.apache.commons.math3.optimization.Target;
import org.apache.commons.math3.optimization.Weight;
import org.apache.commons.math3.util.Incrementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class BaseAbstractMultivariateVectorOptimizer<FUNC extends MultivariateVectorFunction>
implements BaseMultivariateVectorOptimizer<FUNC> {
    protected final Incrementor evaluations = new Incrementor();
    private ConvergenceChecker<PointVectorValuePair> checker;
    private double[] target;
    private RealMatrix weightMatrix;
    @Deprecated
    private double[] weight;
    private double[] start;
    private FUNC function;

    @Deprecated
    protected BaseAbstractMultivariateVectorOptimizer() {
        this(new SimpleVectorValueChecker());
    }

    protected BaseAbstractMultivariateVectorOptimizer(ConvergenceChecker<PointVectorValuePair> convergenceChecker) {
        this.checker = convergenceChecker;
    }

    @Override
    public int getMaxEvaluations() {
        return this.evaluations.getMaximalCount();
    }

    @Override
    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    @Override
    public ConvergenceChecker<PointVectorValuePair> getConvergenceChecker() {
        return this.checker;
    }

    protected double[] computeObjectiveValue(double[] dArray) {
        try {
            this.evaluations.incrementCount();
        }
        catch (MaxCountExceededException maxCountExceededException) {
            throw new TooManyEvaluationsException(maxCountExceededException.getMax());
        }
        return this.function.value(dArray);
    }

    @Override
    @Deprecated
    public PointVectorValuePair optimize(int n, FUNC FUNC, double[] dArray, double[] dArray2, double[] dArray3) {
        return this.optimizeInternal(n, FUNC, dArray, dArray2, dArray3);
    }

    protected PointVectorValuePair optimize(int n, FUNC FUNC, OptimizationData ... optimizationDataArray) {
        return this.optimizeInternal(n, FUNC, optimizationDataArray);
    }

    @Deprecated
    protected PointVectorValuePair optimizeInternal(int n, FUNC FUNC, double[] dArray, double[] dArray2, double[] dArray3) {
        if (FUNC == null) {
            throw new NullArgumentException();
        }
        if (dArray == null) {
            throw new NullArgumentException();
        }
        if (dArray2 == null) {
            throw new NullArgumentException();
        }
        if (dArray3 == null) {
            throw new NullArgumentException();
        }
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        return this.optimizeInternal(n, FUNC, new Target(dArray), new Weight(dArray2), new InitialGuess(dArray3));
    }

    protected PointVectorValuePair optimizeInternal(int n, FUNC FUNC, OptimizationData ... optimizationDataArray) {
        this.evaluations.setMaximalCount(n);
        this.evaluations.resetCount();
        this.function = FUNC;
        this.parseOptimizationData(optimizationDataArray);
        this.checkParameters();
        this.setUp();
        return this.doOptimize();
    }

    public double[] getStartPoint() {
        return (double[])this.start.clone();
    }

    public RealMatrix getWeight() {
        return this.weightMatrix.copy();
    }

    public double[] getTarget() {
        return (double[])this.target.clone();
    }

    protected FUNC getObjectiveFunction() {
        return this.function;
    }

    protected abstract PointVectorValuePair doOptimize();

    @Deprecated
    protected double[] getTargetRef() {
        return this.target;
    }

    @Deprecated
    protected double[] getWeightRef() {
        return this.weight;
    }

    protected void setUp() {
        int n = this.target.length;
        this.weight = new double[n];
        for (int i = 0; i < n; ++i) {
            this.weight[i] = this.weightMatrix.getEntry(i, i);
        }
    }

    private void parseOptimizationData(OptimizationData ... optimizationDataArray) {
        for (OptimizationData optimizationData : optimizationDataArray) {
            if (optimizationData instanceof Target) {
                this.target = ((Target)optimizationData).getTarget();
                continue;
            }
            if (optimizationData instanceof Weight) {
                this.weightMatrix = ((Weight)optimizationData).getWeight();
                continue;
            }
            if (!(optimizationData instanceof InitialGuess)) continue;
            this.start = ((InitialGuess)optimizationData).getInitialGuess();
        }
    }

    private void checkParameters() {
        if (this.target.length != this.weightMatrix.getColumnDimension()) {
            throw new DimensionMismatchException(this.target.length, this.weightMatrix.getColumnDimension());
        }
    }
}

