/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.direct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.optimization.ConvergenceChecker;
import org.apache.commons.math3.optimization.GoalType;
import org.apache.commons.math3.optimization.MultivariateOptimizer;
import org.apache.commons.math3.optimization.OptimizationData;
import org.apache.commons.math3.optimization.PointValuePair;
import org.apache.commons.math3.optimization.SimpleValueChecker;
import org.apache.commons.math3.optimization.direct.BaseAbstractMultivariateSimpleBoundsOptimizer;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class CMAESOptimizer
extends BaseAbstractMultivariateSimpleBoundsOptimizer<MultivariateFunction>
implements MultivariateOptimizer {
    public static final int DEFAULT_CHECKFEASABLECOUNT = 0;
    public static final double DEFAULT_STOPFITNESS = 0.0;
    public static final boolean DEFAULT_ISACTIVECMA = true;
    public static final int DEFAULT_MAXITERATIONS = 30000;
    public static final int DEFAULT_DIAGONALONLY = 0;
    public static final RandomGenerator DEFAULT_RANDOMGENERATOR = new MersenneTwister();
    private int lambda;
    private boolean isActiveCMA;
    private int checkFeasableCount;
    private double[] inputSigma;
    private int dimension;
    private int diagonalOnly = 0;
    private boolean isMinimize = true;
    private boolean generateStatistics = false;
    private int maxIterations;
    private double stopFitness;
    private double stopTolUpX;
    private double stopTolX;
    private double stopTolFun;
    private double stopTolHistFun;
    private int mu;
    private double logMu2;
    private RealMatrix weights;
    private double mueff;
    private double sigma;
    private double cc;
    private double cs;
    private double damps;
    private double ccov1;
    private double ccovmu;
    private double chiN;
    private double ccov1Sep;
    private double ccovmuSep;
    private RealMatrix xmean;
    private RealMatrix pc;
    private RealMatrix ps;
    private double normps;
    private RealMatrix B;
    private RealMatrix D;
    private RealMatrix BD;
    private RealMatrix diagD;
    private RealMatrix C;
    private RealMatrix diagC;
    private int iterations;
    private double[] fitnessHistory;
    private int historySize;
    private RandomGenerator random;
    private List<Double> statisticsSigmaHistory = new ArrayList<Double>();
    private List<RealMatrix> statisticsMeanHistory = new ArrayList<RealMatrix>();
    private List<Double> statisticsFitnessHistory = new ArrayList<Double>();
    private List<RealMatrix> statisticsDHistory = new ArrayList<RealMatrix>();

    @Deprecated
    public CMAESOptimizer() {
        this(0);
    }

    @Deprecated
    public CMAESOptimizer(int n) {
        this(n, null, 30000, 0.0, true, 0, 0, DEFAULT_RANDOMGENERATOR, false, null);
    }

    @Deprecated
    public CMAESOptimizer(int n, double[] dArray) {
        this(n, dArray, 30000, 0.0, true, 0, 0, DEFAULT_RANDOMGENERATOR, false);
    }

    @Deprecated
    public CMAESOptimizer(int n, double[] dArray, int n2, double d, boolean bl, int n3, int n4, RandomGenerator randomGenerator, boolean bl2) {
        this(n, dArray, n2, d, bl, n3, n4, randomGenerator, bl2, new SimpleValueChecker());
    }

    @Deprecated
    public CMAESOptimizer(int n, double[] dArray, int n2, double d, boolean bl, int n3, int n4, RandomGenerator randomGenerator, boolean bl2, ConvergenceChecker<PointValuePair> convergenceChecker) {
        super(convergenceChecker);
        this.lambda = n;
        this.inputSigma = dArray == null ? null : (double[])dArray.clone();
        this.maxIterations = n2;
        this.stopFitness = d;
        this.isActiveCMA = bl;
        this.diagonalOnly = n3;
        this.checkFeasableCount = n4;
        this.random = randomGenerator;
        this.generateStatistics = bl2;
    }

    public CMAESOptimizer(int n, double d, boolean bl, int n2, int n3, RandomGenerator randomGenerator, boolean bl2, ConvergenceChecker<PointValuePair> convergenceChecker) {
        super(convergenceChecker);
        this.maxIterations = n;
        this.stopFitness = d;
        this.isActiveCMA = bl;
        this.diagonalOnly = n2;
        this.checkFeasableCount = n3;
        this.random = randomGenerator;
        this.generateStatistics = bl2;
    }

    public List<Double> getStatisticsSigmaHistory() {
        return this.statisticsSigmaHistory;
    }

    public List<RealMatrix> getStatisticsMeanHistory() {
        return this.statisticsMeanHistory;
    }

    public List<Double> getStatisticsFitnessHistory() {
        return this.statisticsFitnessHistory;
    }

    public List<RealMatrix> getStatisticsDHistory() {
        return this.statisticsDHistory;
    }

    @Override
    protected PointValuePair optimizeInternal(int n, MultivariateFunction multivariateFunction, GoalType goalType, OptimizationData ... optimizationDataArray) {
        this.parseOptimizationData(optimizationDataArray);
        return super.optimizeInternal(n, multivariateFunction, goalType, optimizationDataArray);
    }

    @Override
    protected PointValuePair doOptimize() {
        this.checkParameters();
        this.isMinimize = this.getGoalType().equals(GoalType.MINIMIZE);
        FitnessFunction fitnessFunction = new FitnessFunction();
        double[] dArray = this.getStartPoint();
        this.dimension = dArray.length;
        this.initializeCMA(dArray);
        this.iterations = 0;
        double d = fitnessFunction.value(dArray);
        CMAESOptimizer.push(this.fitnessHistory, d);
        PointValuePair pointValuePair = new PointValuePair(this.getStartPoint(), this.isMinimize ? d : -d);
        PointValuePair pointValuePair2 = null;
        this.iterations = 1;
        block2: while (this.iterations <= this.maxIterations) {
            int n;
            RealMatrix realMatrix;
            RealMatrix realMatrix2 = this.randn1(this.dimension, this.lambda);
            RealMatrix realMatrix3 = CMAESOptimizer.zeros(this.dimension, this.lambda);
            double[] dArray2 = new double[this.lambda];
            for (int i = 0; i < this.lambda; ++i) {
                realMatrix = null;
                for (int j = 0; j < this.checkFeasableCount + 1; ++j) {
                    realMatrix = this.diagonalOnly <= 0 ? this.xmean.add(this.BD.multiply(realMatrix2.getColumnMatrix(i)).scalarMultiply(this.sigma)) : this.xmean.add(CMAESOptimizer.times(this.diagD, realMatrix2.getColumnMatrix(i)).scalarMultiply(this.sigma));
                    if (j >= this.checkFeasableCount || fitnessFunction.isFeasible(realMatrix.getColumn(0))) break;
                    realMatrix2.setColumn(i, this.randn(this.dimension));
                }
                CMAESOptimizer.copyColumn(realMatrix, 0, realMatrix3, i);
                try {
                    dArray2[i] = fitnessFunction.value(realMatrix3.getColumn(i));
                    continue;
                }
                catch (TooManyEvaluationsException tooManyEvaluationsException) {
                    break block2;
                }
            }
            int[] nArray = this.sortedIndices(dArray2);
            realMatrix = this.xmean;
            RealMatrix realMatrix4 = CMAESOptimizer.selectColumns(realMatrix3, MathArrays.copyOf(nArray, this.mu));
            this.xmean = realMatrix4.multiply(this.weights);
            RealMatrix realMatrix5 = CMAESOptimizer.selectColumns(realMatrix2, MathArrays.copyOf(nArray, this.mu));
            RealMatrix realMatrix6 = realMatrix5.multiply(this.weights);
            boolean bl = this.updateEvolutionPaths(realMatrix6, realMatrix);
            if (this.diagonalOnly <= 0) {
                this.updateCovariance(bl, realMatrix4, realMatrix2, nArray, realMatrix);
            } else {
                this.updateCovarianceDiagonalOnly(bl, realMatrix5);
            }
            this.sigma *= FastMath.exp(FastMath.min(1.0, (this.normps / this.chiN - 1.0) * this.cs / this.damps));
            double d2 = dArray2[nArray[0]];
            double d3 = dArray2[nArray[nArray.length - 1]];
            if (d > d2) {
                d = d2;
                pointValuePair2 = pointValuePair;
                pointValuePair = new PointValuePair(fitnessFunction.repair(realMatrix4.getColumn(0)), this.isMinimize ? d2 : -d2);
                if (this.getConvergenceChecker() != null && pointValuePair2 != null && this.getConvergenceChecker().converged(this.iterations, pointValuePair, pointValuePair2)) break;
            }
            if (this.stopFitness != 0.0) {
                if (d2 < (this.isMinimize ? this.stopFitness : -this.stopFitness)) break;
            }
            double[] dArray3 = CMAESOptimizer.sqrt(this.diagC).getColumn(0);
            double[] dArray4 = this.pc.getColumn(0);
            for (n = 0; n < this.dimension && !(this.sigma * FastMath.max(FastMath.abs(dArray4[n]), dArray3[n]) > this.stopTolX); ++n) {
                if (n >= this.dimension - 1) break block2;
            }
            for (n = 0; n < this.dimension; ++n) {
                if (this.sigma * dArray3[n] > this.stopTolUpX) break block2;
            }
            double d4 = CMAESOptimizer.min(this.fitnessHistory);
            double d5 = CMAESOptimizer.max(this.fitnessHistory);
            if (this.iterations > 2 && FastMath.max(d5, d3) - FastMath.min(d4, d2) < this.stopTolFun || this.iterations > this.fitnessHistory.length && d5 - d4 < this.stopTolHistFun || CMAESOptimizer.max(this.diagD) / CMAESOptimizer.min(this.diagD) > 1.0E7) break;
            if (this.getConvergenceChecker() != null) {
                PointValuePair pointValuePair3 = new PointValuePair(realMatrix4.getColumn(0), this.isMinimize ? d2 : -d2);
                if (pointValuePair2 != null && this.getConvergenceChecker().converged(this.iterations, pointValuePair3, pointValuePair2)) break;
                pointValuePair2 = pointValuePair3;
            }
            if (d == dArray2[nArray[(int)(0.1 + (double)this.lambda / 4.0)]]) {
                this.sigma *= FastMath.exp(0.2 + this.cs / this.damps);
            }
            if (this.iterations > 2 && FastMath.max(d5, d2) - FastMath.min(d4, d2) == 0.0) {
                this.sigma *= FastMath.exp(0.2 + this.cs / this.damps);
            }
            CMAESOptimizer.push(this.fitnessHistory, d2);
            fitnessFunction.setValueRange(d3 - d2);
            if (this.generateStatistics) {
                this.statisticsSigmaHistory.add(this.sigma);
                this.statisticsFitnessHistory.add(d2);
                this.statisticsMeanHistory.add(this.xmean.transpose());
                this.statisticsDHistory.add(this.diagD.transpose().scalarMultiply(100000.0));
            }
            ++this.iterations;
        }
        return pointValuePair;
    }

    private void parseOptimizationData(OptimizationData ... optimizationDataArray) {
        for (OptimizationData optimizationData : optimizationDataArray) {
            if (optimizationData instanceof Sigma) {
                this.inputSigma = ((Sigma)optimizationData).getSigma();
                continue;
            }
            if (!(optimizationData instanceof PopulationSize)) continue;
            this.lambda = ((PopulationSize)optimizationData).getPopulationSize();
        }
    }

    private void checkParameters() {
        double[] dArray = this.getStartPoint();
        double[] dArray2 = this.getLowerBound();
        double[] dArray3 = this.getUpperBound();
        if (this.inputSigma != null) {
            if (this.inputSigma.length != dArray.length) {
                throw new DimensionMismatchException(this.inputSigma.length, dArray.length);
            }
            for (int i = 0; i < dArray.length; ++i) {
                if (this.inputSigma[i] < 0.0) {
                    throw new NotPositiveException(this.inputSigma[i]);
                }
                if (!(this.inputSigma[i] > dArray3[i] - dArray2[i])) continue;
                throw new OutOfRangeException(this.inputSigma[i], (Number)0, dArray3[i] - dArray2[i]);
            }
        }
    }

    private void initializeCMA(double[] dArray) {
        int n;
        if (this.lambda <= 0) {
            this.lambda = 4 + (int)(3.0 * FastMath.log(this.dimension));
        }
        double[][] dArray2 = new double[dArray.length][1];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i][0] = this.inputSigma == null ? 0.3 : this.inputSigma[i];
        }
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(dArray2, false);
        this.sigma = CMAESOptimizer.max(array2DRowRealMatrix);
        this.stopTolUpX = 1000.0 * CMAESOptimizer.max(array2DRowRealMatrix);
        this.stopTolX = 1.0E-11 * CMAESOptimizer.max(array2DRowRealMatrix);
        this.stopTolFun = 1.0E-12;
        this.stopTolHistFun = 1.0E-13;
        this.mu = this.lambda / 2;
        this.logMu2 = FastMath.log((double)this.mu + 0.5);
        this.weights = CMAESOptimizer.log(CMAESOptimizer.sequence(1.0, this.mu, 1.0)).scalarMultiply(-1.0).scalarAdd(this.logMu2);
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < this.mu; ++n) {
            double d3 = this.weights.getEntry(n, 0);
            d += d3;
            d2 += d3 * d3;
        }
        this.weights = this.weights.scalarMultiply(1.0 / d);
        this.mueff = d * d / d2;
        this.cc = (4.0 + this.mueff / (double)this.dimension) / ((double)(this.dimension + 4) + 2.0 * this.mueff / (double)this.dimension);
        this.cs = (this.mueff + 2.0) / ((double)this.dimension + this.mueff + 3.0);
        this.damps = (1.0 + 2.0 * FastMath.max(0.0, FastMath.sqrt((this.mueff - 1.0) / (double)(this.dimension + 1)) - 1.0)) * FastMath.max(0.3, 1.0 - (double)this.dimension / (1.0E-6 + (double)this.maxIterations)) + this.cs;
        this.ccov1 = 2.0 / (((double)this.dimension + 1.3) * ((double)this.dimension + 1.3) + this.mueff);
        this.ccovmu = FastMath.min(1.0 - this.ccov1, 2.0 * (this.mueff - 2.0 + 1.0 / this.mueff) / ((double)((this.dimension + 2) * (this.dimension + 2)) + this.mueff));
        this.ccov1Sep = FastMath.min(1.0, this.ccov1 * ((double)this.dimension + 1.5) / 3.0);
        this.ccovmuSep = FastMath.min(1.0 - this.ccov1, this.ccovmu * ((double)this.dimension + 1.5) / 3.0);
        this.chiN = FastMath.sqrt(this.dimension) * (1.0 - 1.0 / (4.0 * (double)this.dimension) + 1.0 / (21.0 * (double)this.dimension * (double)this.dimension));
        this.xmean = MatrixUtils.createColumnRealMatrix(dArray);
        this.diagD = array2DRowRealMatrix.scalarMultiply(1.0 / this.sigma);
        this.diagC = CMAESOptimizer.square(this.diagD);
        this.pc = CMAESOptimizer.zeros(this.dimension, 1);
        this.ps = CMAESOptimizer.zeros(this.dimension, 1);
        this.normps = this.ps.getFrobeniusNorm();
        this.B = CMAESOptimizer.eye(this.dimension, this.dimension);
        this.D = CMAESOptimizer.ones(this.dimension, 1);
        this.BD = CMAESOptimizer.times(this.B, CMAESOptimizer.repmat(this.diagD.transpose(), this.dimension, 1));
        this.C = this.B.multiply(CMAESOptimizer.diag(CMAESOptimizer.square(this.D)).multiply(this.B.transpose()));
        this.historySize = 10 + (int)((double)(30 * this.dimension) / (double)this.lambda);
        this.fitnessHistory = new double[this.historySize];
        for (n = 0; n < this.historySize; ++n) {
            this.fitnessHistory[n] = Double.MAX_VALUE;
        }
    }

    private boolean updateEvolutionPaths(RealMatrix realMatrix, RealMatrix realMatrix2) {
        this.ps = this.ps.scalarMultiply(1.0 - this.cs).add(this.B.multiply(realMatrix).scalarMultiply(FastMath.sqrt(this.cs * (2.0 - this.cs) * this.mueff)));
        this.normps = this.ps.getFrobeniusNorm();
        boolean bl = this.normps / FastMath.sqrt(1.0 - FastMath.pow(1.0 - this.cs, 2 * this.iterations)) / this.chiN < 1.4 + 2.0 / ((double)this.dimension + 1.0);
        this.pc = this.pc.scalarMultiply(1.0 - this.cc);
        if (bl) {
            this.pc = this.pc.add(this.xmean.subtract(realMatrix2).scalarMultiply(FastMath.sqrt(this.cc * (2.0 - this.cc) * this.mueff) / this.sigma));
        }
        return bl;
    }

    private void updateCovarianceDiagonalOnly(boolean bl, RealMatrix realMatrix) {
        double d = bl ? 0.0 : this.ccov1Sep * this.cc * (2.0 - this.cc);
        this.diagC = this.diagC.scalarMultiply(d += 1.0 - this.ccov1Sep - this.ccovmuSep).add(CMAESOptimizer.square(this.pc).scalarMultiply(this.ccov1Sep)).add(CMAESOptimizer.times(this.diagC, CMAESOptimizer.square(realMatrix).multiply(this.weights)).scalarMultiply(this.ccovmuSep));
        this.diagD = CMAESOptimizer.sqrt(this.diagC);
        if (this.diagonalOnly > 1 && this.iterations > this.diagonalOnly) {
            this.diagonalOnly = 0;
            this.B = CMAESOptimizer.eye(this.dimension, this.dimension);
            this.BD = CMAESOptimizer.diag(this.diagD);
            this.C = CMAESOptimizer.diag(this.diagC);
        }
    }

    private void updateCovariance(boolean bl, RealMatrix realMatrix, RealMatrix realMatrix2, int[] nArray, RealMatrix realMatrix3) {
        double d = 0.0;
        if (this.ccov1 + this.ccovmu > 0.0) {
            RealMatrix realMatrix4 = realMatrix.subtract(CMAESOptimizer.repmat(realMatrix3, 1, this.mu)).scalarMultiply(1.0 / this.sigma);
            RealMatrix realMatrix5 = this.pc.multiply(this.pc.transpose()).scalarMultiply(this.ccov1);
            double d2 = bl ? 0.0 : this.ccov1 * this.cc * (2.0 - this.cc);
            d2 += 1.0 - this.ccov1 - this.ccovmu;
            if (this.isActiveCMA) {
                int[] nArray2;
                d = (1.0 - this.ccovmu) * 0.25 * this.mueff / (FastMath.pow((double)(this.dimension + 2), 1.5) + 2.0 * this.mueff);
                double d3 = 0.66;
                double d4 = 0.5;
                int[] nArray3 = CMAESOptimizer.reverse(nArray);
                RealMatrix realMatrix6 = CMAESOptimizer.selectColumns(realMatrix2, MathArrays.copyOf(nArray3, this.mu));
                RealMatrix realMatrix7 = CMAESOptimizer.sqrt(CMAESOptimizer.sumRows(CMAESOptimizer.square(realMatrix6)));
                int[] nArray4 = this.sortedIndices(realMatrix7.getRow(0));
                RealMatrix realMatrix8 = CMAESOptimizer.selectColumns(realMatrix7, nArray4);
                int[] nArray5 = CMAESOptimizer.reverse(nArray4);
                RealMatrix realMatrix9 = CMAESOptimizer.selectColumns(realMatrix7, nArray5);
                RealMatrix realMatrix10 = CMAESOptimizer.selectColumns(realMatrix7 = CMAESOptimizer.divide(realMatrix9, realMatrix8), nArray2 = CMAESOptimizer.inverse(nArray4));
                double d5 = 0.33999999999999997 / CMAESOptimizer.square(realMatrix10).multiply(this.weights).getEntry(0, 0);
                if (d > d5) {
                    d = d5;
                }
                realMatrix6 = CMAESOptimizer.times(realMatrix6, CMAESOptimizer.repmat(realMatrix10, this.dimension, 1));
                RealMatrix realMatrix11 = this.BD.multiply(realMatrix6);
                RealMatrix realMatrix12 = realMatrix11.multiply(CMAESOptimizer.diag(this.weights)).multiply(realMatrix11.transpose());
                this.C = this.C.scalarMultiply(d2 += 0.5 * d).add(realMatrix5).add(realMatrix4.scalarMultiply(this.ccovmu + 0.5 * d).multiply(CMAESOptimizer.times(CMAESOptimizer.repmat(this.weights, 1, this.dimension), realMatrix4.transpose()))).subtract(realMatrix12.scalarMultiply(d));
            } else {
                this.C = this.C.scalarMultiply(d2).add(realMatrix5).add(realMatrix4.scalarMultiply(this.ccovmu).multiply(CMAESOptimizer.times(CMAESOptimizer.repmat(this.weights, 1, this.dimension), realMatrix4.transpose())));
            }
        }
        this.updateBD(d);
    }

    private void updateBD(double d) {
        if (this.ccov1 + this.ccovmu + d > 0.0 && (double)this.iterations % 1.0 / (this.ccov1 + this.ccovmu + d) / (double)this.dimension / 10.0 < 1.0) {
            double d2;
            this.C = CMAESOptimizer.triu(this.C, 0).add(CMAESOptimizer.triu(this.C, 1).transpose());
            EigenDecomposition eigenDecomposition = new EigenDecomposition(this.C);
            this.B = eigenDecomposition.getV();
            this.D = eigenDecomposition.getD();
            this.diagD = CMAESOptimizer.diag(this.D);
            if (CMAESOptimizer.min(this.diagD) <= 0.0) {
                for (int i = 0; i < this.dimension; ++i) {
                    if (!(this.diagD.getEntry(i, 0) < 0.0)) continue;
                    this.diagD.setEntry(i, 0, 0.0);
                }
                d2 = CMAESOptimizer.max(this.diagD) / 1.0E14;
                this.C = this.C.add(CMAESOptimizer.eye(this.dimension, this.dimension).scalarMultiply(d2));
                this.diagD = this.diagD.add(CMAESOptimizer.ones(this.dimension, 1).scalarMultiply(d2));
            }
            if (CMAESOptimizer.max(this.diagD) > 1.0E14 * CMAESOptimizer.min(this.diagD)) {
                d2 = CMAESOptimizer.max(this.diagD) / 1.0E14 - CMAESOptimizer.min(this.diagD);
                this.C = this.C.add(CMAESOptimizer.eye(this.dimension, this.dimension).scalarMultiply(d2));
                this.diagD = this.diagD.add(CMAESOptimizer.ones(this.dimension, 1).scalarMultiply(d2));
            }
            this.diagC = CMAESOptimizer.diag(this.C);
            this.diagD = CMAESOptimizer.sqrt(this.diagD);
            this.BD = CMAESOptimizer.times(this.B, CMAESOptimizer.repmat(this.diagD.transpose(), this.dimension, 1));
        }
    }

    private static void push(double[] dArray, double d) {
        for (int i = dArray.length - 1; i > 0; --i) {
            dArray[i] = dArray[i - 1];
        }
        dArray[0] = d;
    }

    private int[] sortedIndices(double[] dArray) {
        Object[] objectArray = new DoubleIndex[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            objectArray[i] = new DoubleIndex(dArray[i], i);
        }
        Arrays.sort(objectArray);
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            nArray[i] = ((DoubleIndex)objectArray[i]).index;
        }
        return nArray;
    }

    private static RealMatrix log(RealMatrix realMatrix) {
        double[][] dArray = new double[realMatrix.getRowDimension()][realMatrix.getColumnDimension()];
        for (int i = 0; i < realMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < realMatrix.getColumnDimension(); ++j) {
                dArray[i][j] = FastMath.log(realMatrix.getEntry(i, j));
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix sqrt(RealMatrix realMatrix) {
        double[][] dArray = new double[realMatrix.getRowDimension()][realMatrix.getColumnDimension()];
        for (int i = 0; i < realMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < realMatrix.getColumnDimension(); ++j) {
                dArray[i][j] = FastMath.sqrt(realMatrix.getEntry(i, j));
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix square(RealMatrix realMatrix) {
        double[][] dArray = new double[realMatrix.getRowDimension()][realMatrix.getColumnDimension()];
        for (int i = 0; i < realMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < realMatrix.getColumnDimension(); ++j) {
                double d = realMatrix.getEntry(i, j);
                dArray[i][j] = d * d;
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix times(RealMatrix realMatrix, RealMatrix realMatrix2) {
        double[][] dArray = new double[realMatrix.getRowDimension()][realMatrix.getColumnDimension()];
        for (int i = 0; i < realMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < realMatrix.getColumnDimension(); ++j) {
                dArray[i][j] = realMatrix.getEntry(i, j) * realMatrix2.getEntry(i, j);
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix divide(RealMatrix realMatrix, RealMatrix realMatrix2) {
        double[][] dArray = new double[realMatrix.getRowDimension()][realMatrix.getColumnDimension()];
        for (int i = 0; i < realMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < realMatrix.getColumnDimension(); ++j) {
                dArray[i][j] = realMatrix.getEntry(i, j) / realMatrix2.getEntry(i, j);
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix selectColumns(RealMatrix realMatrix, int[] nArray) {
        double[][] dArray = new double[realMatrix.getRowDimension()][nArray.length];
        for (int i = 0; i < realMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                dArray[i][j] = realMatrix.getEntry(i, nArray[j]);
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix triu(RealMatrix realMatrix, int n) {
        double[][] dArray = new double[realMatrix.getRowDimension()][realMatrix.getColumnDimension()];
        for (int i = 0; i < realMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < realMatrix.getColumnDimension(); ++j) {
                dArray[i][j] = i <= j - n ? realMatrix.getEntry(i, j) : 0.0;
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix sumRows(RealMatrix realMatrix) {
        double[][] dArray = new double[1][realMatrix.getColumnDimension()];
        for (int i = 0; i < realMatrix.getColumnDimension(); ++i) {
            double d = 0.0;
            for (int j = 0; j < realMatrix.getRowDimension(); ++j) {
                d += realMatrix.getEntry(j, i);
            }
            dArray[0][i] = d;
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix diag(RealMatrix realMatrix) {
        if (realMatrix.getColumnDimension() == 1) {
            double[][] dArray = new double[realMatrix.getRowDimension()][realMatrix.getRowDimension()];
            for (int i = 0; i < realMatrix.getRowDimension(); ++i) {
                dArray[i][i] = realMatrix.getEntry(i, 0);
            }
            return new Array2DRowRealMatrix(dArray, false);
        }
        double[][] dArray = new double[realMatrix.getRowDimension()][1];
        for (int i = 0; i < realMatrix.getColumnDimension(); ++i) {
            dArray[i][0] = realMatrix.getEntry(i, i);
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static void copyColumn(RealMatrix realMatrix, int n, RealMatrix realMatrix2, int n2) {
        for (int i = 0; i < realMatrix.getRowDimension(); ++i) {
            realMatrix2.setEntry(i, n2, realMatrix.getEntry(i, n));
        }
    }

    private static RealMatrix ones(int n, int n2) {
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            Arrays.fill(dArray[i], 1.0);
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix eye(int n, int n2) {
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            if (i >= n2) continue;
            dArray[i][i] = 1.0;
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix zeros(int n, int n2) {
        return new Array2DRowRealMatrix(n, n2);
    }

    private static RealMatrix repmat(RealMatrix realMatrix, int n, int n2) {
        int n3 = realMatrix.getRowDimension();
        int n4 = realMatrix.getColumnDimension();
        double[][] dArray = new double[n * n3][n2 * n4];
        for (int i = 0; i < n * n3; ++i) {
            for (int j = 0; j < n2 * n4; ++j) {
                dArray[i][j] = realMatrix.getEntry(i % n3, j % n4);
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static RealMatrix sequence(double d, double d2, double d3) {
        int n = (int)((d2 - d) / d3 + 1.0);
        double[][] dArray = new double[n][1];
        double d4 = d;
        for (int i = 0; i < n; ++i) {
            dArray[i][0] = d4;
            d4 += d3;
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private static double max(RealMatrix realMatrix) {
        double d = -1.7976931348623157E308;
        for (int i = 0; i < realMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < realMatrix.getColumnDimension(); ++j) {
                double d2 = realMatrix.getEntry(i, j);
                if (!(d < d2)) continue;
                d = d2;
            }
        }
        return d;
    }

    private static double min(RealMatrix realMatrix) {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < realMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < realMatrix.getColumnDimension(); ++j) {
                double d2 = realMatrix.getEntry(i, j);
                if (!(d > d2)) continue;
                d = d2;
            }
        }
        return d;
    }

    private static double max(double[] dArray) {
        double d = -1.7976931348623157E308;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(d < dArray[i])) continue;
            d = dArray[i];
        }
        return d;
    }

    private static double min(double[] dArray) {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < dArray.length; ++i) {
            if (!(d > dArray[i])) continue;
            d = dArray[i];
        }
        return d;
    }

    private static int[] inverse(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[nArray[i]] = i;
        }
        return nArray2;
    }

    private static int[] reverse(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[nArray.length - i - 1];
        }
        return nArray2;
    }

    private double[] randn(int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.random.nextGaussian();
        }
        return dArray;
    }

    private RealMatrix randn1(int n, int n2) {
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = this.random.nextGaussian();
            }
        }
        return new Array2DRowRealMatrix(dArray, false);
    }

    private class FitnessFunction {
        private double valueRange = 1.0;
        private final boolean isRepairMode;

        FitnessFunction() {
            this.isRepairMode = true;
        }

        public double value(double[] dArray) {
            double d;
            if (this.isRepairMode) {
                double[] dArray2 = this.repair(dArray);
                d = CMAESOptimizer.this.computeObjectiveValue(dArray2) + this.penalty(dArray, dArray2);
            } else {
                d = CMAESOptimizer.this.computeObjectiveValue(dArray);
            }
            return CMAESOptimizer.this.isMinimize ? d : -d;
        }

        public boolean isFeasible(double[] dArray) {
            double[] dArray2 = CMAESOptimizer.this.getLowerBound();
            double[] dArray3 = CMAESOptimizer.this.getUpperBound();
            for (int i = 0; i < dArray.length; ++i) {
                if (dArray[i] < dArray2[i]) {
                    return false;
                }
                if (!(dArray[i] > dArray3[i])) continue;
                return false;
            }
            return true;
        }

        public void setValueRange(double d) {
            this.valueRange = d;
        }

        private double[] repair(double[] dArray) {
            double[] dArray2 = CMAESOptimizer.this.getLowerBound();
            double[] dArray3 = CMAESOptimizer.this.getUpperBound();
            double[] dArray4 = new double[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray4[i] = dArray[i] < dArray2[i] ? dArray2[i] : (dArray[i] > dArray3[i] ? dArray3[i] : dArray[i]);
            }
            return dArray4;
        }

        private double penalty(double[] dArray, double[] dArray2) {
            double d = 0.0;
            for (int i = 0; i < dArray.length; ++i) {
                double d2 = FastMath.abs(dArray[i] - dArray2[i]);
                d += d2 * this.valueRange;
            }
            return CMAESOptimizer.this.isMinimize ? d : -d;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoubleIndex
    implements Comparable<DoubleIndex> {
        private final double value;
        private final int index;

        DoubleIndex(double d, int n) {
            this.value = d;
            this.index = n;
        }

        @Override
        public int compareTo(DoubleIndex doubleIndex) {
            return Double.compare(this.value, doubleIndex.value);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof DoubleIndex) {
                return Double.compare(this.value, ((DoubleIndex)object).value) == 0;
            }
            return false;
        }

        public int hashCode() {
            long l = Double.doubleToLongBits(this.value);
            return (int)((0x15F34EL ^ l >>> 32 ^ l) & 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public static class PopulationSize
    implements OptimizationData {
        private final int lambda;

        public PopulationSize(int n) {
            if (n <= 0) {
                throw new NotStrictlyPositiveException(n);
            }
            this.lambda = n;
        }

        public int getPopulationSize() {
            return this.lambda;
        }
    }

    public static class Sigma
    implements OptimizationData {
        private final double[] sigma;

        public Sigma(double[] dArray) {
            for (int i = 0; i < dArray.length; ++i) {
                if (!(dArray[i] < 0.0)) continue;
                throw new NotPositiveException(dArray[i]);
            }
            this.sigma = (double[])dArray.clone();
        }

        public double[] getSigma() {
            return (double[])this.sigma.clone();
        }
    }
}

