/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.fitting;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.analysis.DifferentiableMultivariateVectorFunction;
import org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import org.apache.commons.math3.analysis.ParametricUnivariateFunction;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.MultivariateDifferentiableVectorFunction;
import org.apache.commons.math3.optimization.DifferentiableMultivariateVectorOptimizer;
import org.apache.commons.math3.optimization.MultivariateDifferentiableVectorOptimizer;
import org.apache.commons.math3.optimization.PointVectorValuePair;
import org.apache.commons.math3.optimization.fitting.WeightedObservedPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class CurveFitter<T extends ParametricUnivariateFunction> {
    @Deprecated
    private final DifferentiableMultivariateVectorOptimizer oldOptimizer;
    private final MultivariateDifferentiableVectorOptimizer optimizer;
    private final List<WeightedObservedPoint> observations;

    @Deprecated
    public CurveFitter(DifferentiableMultivariateVectorOptimizer differentiableMultivariateVectorOptimizer) {
        this.oldOptimizer = differentiableMultivariateVectorOptimizer;
        this.optimizer = null;
        this.observations = new ArrayList<WeightedObservedPoint>();
    }

    public CurveFitter(MultivariateDifferentiableVectorOptimizer multivariateDifferentiableVectorOptimizer) {
        this.oldOptimizer = null;
        this.optimizer = multivariateDifferentiableVectorOptimizer;
        this.observations = new ArrayList<WeightedObservedPoint>();
    }

    public void addObservedPoint(double d, double d2) {
        this.addObservedPoint(1.0, d, d2);
    }

    public void addObservedPoint(double d, double d2, double d3) {
        this.observations.add(new WeightedObservedPoint(d, d2, d3));
    }

    public void addObservedPoint(WeightedObservedPoint weightedObservedPoint) {
        this.observations.add(weightedObservedPoint);
    }

    public WeightedObservedPoint[] getObservations() {
        return this.observations.toArray(new WeightedObservedPoint[this.observations.size()]);
    }

    public void clearObservations() {
        this.observations.clear();
    }

    public double[] fit(T t, double[] dArray) {
        return this.fit(Integer.MAX_VALUE, t, dArray);
    }

    public double[] fit(int n, T t, double[] dArray) {
        double[] dArray2 = new double[this.observations.size()];
        double[] dArray3 = new double[this.observations.size()];
        int n2 = 0;
        for (WeightedObservedPoint weightedObservedPoint : this.observations) {
            dArray2[n2] = weightedObservedPoint.getY();
            dArray3[n2] = weightedObservedPoint.getWeight();
            ++n2;
        }
        PointVectorValuePair pointVectorValuePair = this.optimizer == null ? this.oldOptimizer.optimize(n, new OldTheoreticalValuesFunction((ParametricUnivariateFunction)t), dArray2, dArray3, dArray) : this.optimizer.optimize(n, new TheoreticalValuesFunction((ParametricUnivariateFunction)t), dArray2, dArray3, dArray);
        return pointVectorValuePair.getPointRef();
    }

    private class TheoreticalValuesFunction
    implements MultivariateDifferentiableVectorFunction {
        private final ParametricUnivariateFunction f;

        TheoreticalValuesFunction(ParametricUnivariateFunction parametricUnivariateFunction) {
            this.f = parametricUnivariateFunction;
        }

        public double[] value(double[] dArray) {
            double[] dArray2 = new double[CurveFitter.this.observations.size()];
            int n = 0;
            for (WeightedObservedPoint weightedObservedPoint : CurveFitter.this.observations) {
                dArray2[n++] = this.f.value(weightedObservedPoint.getX(), dArray);
            }
            return dArray2;
        }

        public DerivativeStructure[] value(DerivativeStructure[] derivativeStructureArray) {
            double[] dArray = new double[derivativeStructureArray.length];
            for (int i = 0; i < derivativeStructureArray.length; ++i) {
                dArray[i] = derivativeStructureArray[i].getValue();
            }
            DerivativeStructure[] derivativeStructureArray2 = new DerivativeStructure[CurveFitter.this.observations.size()];
            int n = 0;
            for (WeightedObservedPoint weightedObservedPoint : CurveFitter.this.observations) {
                DerivativeStructure derivativeStructure = new DerivativeStructure(derivativeStructureArray.length, 1, this.f.value(weightedObservedPoint.getX(), dArray));
                for (int i = 0; i < derivativeStructureArray.length; ++i) {
                    derivativeStructure = derivativeStructure.add(new DerivativeStructure(derivativeStructureArray.length, 1, i, 0.0));
                }
                derivativeStructureArray2[n++] = derivativeStructure;
            }
            return derivativeStructureArray2;
        }
    }

    @Deprecated
    private class OldTheoreticalValuesFunction
    implements DifferentiableMultivariateVectorFunction {
        private final ParametricUnivariateFunction f;

        OldTheoreticalValuesFunction(ParametricUnivariateFunction parametricUnivariateFunction) {
            this.f = parametricUnivariateFunction;
        }

        public MultivariateMatrixFunction jacobian() {
            return new MultivariateMatrixFunction(){

                public double[][] value(double[] dArray) {
                    double[][] dArrayArray = new double[CurveFitter.this.observations.size()][];
                    int n = 0;
                    for (WeightedObservedPoint weightedObservedPoint : CurveFitter.this.observations) {
                        dArrayArray[n++] = OldTheoreticalValuesFunction.this.f.gradient(weightedObservedPoint.getX(), dArray);
                    }
                    return dArrayArray;
                }
            };
        }

        public double[] value(double[] dArray) {
            double[] dArray2 = new double[CurveFitter.this.observations.size()];
            int n = 0;
            for (WeightedObservedPoint weightedObservedPoint : CurveFitter.this.observations) {
                dArray2[n++] = this.f.value(weightedObservedPoint.getX(), dArray);
            }
            return dArray2;
        }
    }
}

