/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.fitting;

import org.apache.commons.math3.analysis.function.HarmonicOscillator;
import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.ZeroException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.optimization.DifferentiableMultivariateVectorOptimizer;
import org.apache.commons.math3.optimization.fitting.CurveFitter;
import org.apache.commons.math3.optimization.fitting.WeightedObservedPoint;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class HarmonicFitter
extends CurveFitter<HarmonicOscillator.Parametric> {
    public HarmonicFitter(DifferentiableMultivariateVectorOptimizer differentiableMultivariateVectorOptimizer) {
        super(differentiableMultivariateVectorOptimizer);
    }

    public double[] fit(double[] dArray) {
        return this.fit(new HarmonicOscillator.Parametric(), dArray);
    }

    public double[] fit() {
        return this.fit(new ParameterGuesser(this.getObservations()).guess());
    }

    public static class ParameterGuesser {
        private final double a;
        private final double omega;
        private final double phi;

        public ParameterGuesser(WeightedObservedPoint[] weightedObservedPointArray) {
            if (weightedObservedPointArray.length < 4) {
                throw new NumberIsTooSmallException((Localizable)LocalizedFormats.INSUFFICIENT_OBSERVED_POINTS_IN_SAMPLE, (Number)weightedObservedPointArray.length, 4, true);
            }
            WeightedObservedPoint[] weightedObservedPointArray2 = this.sortObservations(weightedObservedPointArray);
            double[] dArray = this.guessAOmega(weightedObservedPointArray2);
            this.a = dArray[0];
            this.omega = dArray[1];
            this.phi = this.guessPhi(weightedObservedPointArray2);
        }

        public double[] guess() {
            return new double[]{this.a, this.omega, this.phi};
        }

        private WeightedObservedPoint[] sortObservations(WeightedObservedPoint[] weightedObservedPointArray) {
            WeightedObservedPoint[] weightedObservedPointArray2 = (WeightedObservedPoint[])weightedObservedPointArray.clone();
            WeightedObservedPoint weightedObservedPoint = weightedObservedPointArray2[0];
            for (int i = 1; i < weightedObservedPointArray2.length; ++i) {
                WeightedObservedPoint weightedObservedPoint2 = weightedObservedPoint;
                weightedObservedPoint = weightedObservedPointArray2[i];
                if (!(weightedObservedPoint.getX() < weightedObservedPoint2.getX())) continue;
                int n = i - 1;
                WeightedObservedPoint weightedObservedPoint3 = weightedObservedPointArray2[n];
                while (n >= 0 && weightedObservedPoint.getX() < weightedObservedPoint3.getX()) {
                    weightedObservedPointArray2[n + 1] = weightedObservedPoint3;
                    if (n-- == 0) continue;
                    weightedObservedPoint3 = weightedObservedPointArray2[n];
                }
                weightedObservedPointArray2[n + 1] = weightedObservedPoint;
                weightedObservedPoint = weightedObservedPointArray2[i];
            }
            return weightedObservedPointArray2;
        }

        private double[] guessAOmega(WeightedObservedPoint[] weightedObservedPointArray) {
            double d;
            double d2;
            double d3;
            double[] dArray = new double[2];
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = weightedObservedPointArray[0].getX();
            double d10 = weightedObservedPointArray[0].getY();
            double d11 = 0.0;
            double d12 = 0.0;
            double d13 = d9;
            for (int i = 1; i < weightedObservedPointArray.length; ++i) {
                double d14 = d9;
                double d15 = d10;
                d9 = weightedObservedPointArray[i].getX();
                d10 = weightedObservedPointArray[i].getY();
                double d16 = d9 - d14;
                d3 = d10 - d15;
                d2 = d16 * (d15 * d15 + d15 * d10 + d10 * d10) / 3.0;
                d = d3 * d3 / d16;
                double d17 = d9 - d13;
                d4 += d17 * d17;
                d5 += (d11 += d2) * d11;
                d6 += d17 * d11;
                d7 += d17 * (d12 += d);
                d8 += d11 * d12;
            }
            double d18 = d5 * d7 - d6 * d8;
            double d19 = d6 * d7 - d4 * d8;
            double d20 = d4 * d5 - d6 * d6;
            if (d18 / d19 < 0.0 || d19 / d20 < 0.0) {
                int n = weightedObservedPointArray.length - 1;
                d3 = weightedObservedPointArray[n].getX() - weightedObservedPointArray[0].getX();
                if (d3 == 0.0) {
                    throw new ZeroException();
                }
                dArray[1] = Math.PI * 2 / d3;
                d2 = Double.POSITIVE_INFINITY;
                d = Double.NEGATIVE_INFINITY;
                for (int i = 1; i < weightedObservedPointArray.length; ++i) {
                    double d21 = weightedObservedPointArray[i].getY();
                    if (d21 < d2) {
                        d2 = d21;
                    }
                    if (!(d21 > d)) continue;
                    d = d21;
                }
                dArray[0] = 0.5 * (d - d2);
            } else {
                if (d19 == 0.0) {
                    throw new MathIllegalStateException(LocalizedFormats.ZERO_DENOMINATOR, new Object[0]);
                }
                dArray[0] = FastMath.sqrt(d18 / d19);
                dArray[1] = FastMath.sqrt(d19 / d20);
            }
            return dArray;
        }

        private double guessPhi(WeightedObservedPoint[] weightedObservedPointArray) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = weightedObservedPointArray[0].getX();
            double d4 = weightedObservedPointArray[0].getY();
            for (int i = 1; i < weightedObservedPointArray.length; ++i) {
                double d5 = d3;
                double d6 = d4;
                d3 = weightedObservedPointArray[i].getX();
                d4 = weightedObservedPointArray[i].getY();
                double d7 = (d4 - d6) / (d3 - d5);
                double d8 = this.omega * d3;
                double d9 = FastMath.cos(d8);
                double d10 = FastMath.sin(d8);
                d += this.omega * d4 * d9 - d7 * d10;
                d2 += this.omega * d4 * d10 + d7 * d9;
            }
            return FastMath.atan2(-d2, d);
        }
    }
}

