/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.general;

import org.apache.commons.math3.analysis.DifferentiableMultivariateVectorFunction;
import org.apache.commons.math3.analysis.FunctionUtils;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.differentiation.MultivariateDifferentiableVectorFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.DiagonalMatrix;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.optimization.ConvergenceChecker;
import org.apache.commons.math3.optimization.DifferentiableMultivariateVectorOptimizer;
import org.apache.commons.math3.optimization.InitialGuess;
import org.apache.commons.math3.optimization.OptimizationData;
import org.apache.commons.math3.optimization.PointVectorValuePair;
import org.apache.commons.math3.optimization.Target;
import org.apache.commons.math3.optimization.Weight;
import org.apache.commons.math3.optimization.direct.BaseAbstractMultivariateVectorOptimizer;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class AbstractLeastSquaresOptimizer
extends BaseAbstractMultivariateVectorOptimizer<DifferentiableMultivariateVectorFunction>
implements DifferentiableMultivariateVectorOptimizer {
    @Deprecated
    private static final double DEFAULT_SINGULARITY_THRESHOLD = 1.0E-14;
    @Deprecated
    protected double[][] weightedResidualJacobian;
    @Deprecated
    protected int cols;
    @Deprecated
    protected int rows;
    @Deprecated
    protected double[] point;
    @Deprecated
    protected double[] objective;
    @Deprecated
    protected double[] weightedResiduals;
    @Deprecated
    protected double cost;
    private MultivariateDifferentiableVectorFunction jF;
    private int jacobianEvaluations;
    private RealMatrix weightMatrixSqrt;

    @Deprecated
    protected AbstractLeastSquaresOptimizer() {
    }

    protected AbstractLeastSquaresOptimizer(ConvergenceChecker<PointVectorValuePair> convergenceChecker) {
        super(convergenceChecker);
    }

    public int getJacobianEvaluations() {
        return this.jacobianEvaluations;
    }

    @Deprecated
    protected void updateJacobian() {
        RealMatrix realMatrix = this.computeWeightedJacobian(this.point);
        this.weightedResidualJacobian = realMatrix.scalarMultiply(-1.0).getData();
    }

    protected RealMatrix computeWeightedJacobian(double[] dArray) {
        int n;
        ++this.jacobianEvaluations;
        DerivativeStructure[] derivativeStructureArray = new DerivativeStructure[dArray.length];
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            derivativeStructureArray[i] = new DerivativeStructure(n2, 1, i, dArray[i]);
        }
        DerivativeStructure[] derivativeStructureArray2 = this.jF.value(derivativeStructureArray);
        if (derivativeStructureArray2.length != (n = this.getTarget().length)) {
            throw new DimensionMismatchException(derivativeStructureArray2.length, n);
        }
        double[][] dArray2 = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            int[] nArray = new int[n2];
            for (int j = 0; j < n2; ++j) {
                nArray[j] = 1;
                dArray2[i][j] = derivativeStructureArray2[i].getPartialDerivative(nArray);
                nArray[j] = 0;
            }
        }
        return this.weightMatrixSqrt.multiply(MatrixUtils.createRealMatrix(dArray2));
    }

    @Deprecated
    protected void updateResidualsAndCost() {
        this.objective = this.computeObjectiveValue(this.point);
        double[] dArray = this.computeResiduals(this.objective);
        this.cost = this.computeCost(dArray);
        ArrayRealVector arrayRealVector = new ArrayRealVector(dArray);
        this.weightedResiduals = this.weightMatrixSqrt.operate(arrayRealVector).toArray();
    }

    protected double computeCost(double[] dArray) {
        ArrayRealVector arrayRealVector = new ArrayRealVector(dArray);
        return FastMath.sqrt(arrayRealVector.dotProduct(this.getWeight().operate(arrayRealVector)));
    }

    public double getRMS() {
        return FastMath.sqrt(this.getChiSquare() / (double)this.rows);
    }

    public double getChiSquare() {
        return this.cost * this.cost;
    }

    public RealMatrix getWeightSquareRoot() {
        return this.weightMatrixSqrt.copy();
    }

    protected void setCost(double d) {
        this.cost = d;
    }

    @Deprecated
    public double[][] getCovariances() {
        return this.getCovariances(1.0E-14);
    }

    @Deprecated
    public double[][] getCovariances(double d) {
        return this.computeCovariances(this.point, d);
    }

    public double[][] computeCovariances(double[] dArray, double d) {
        RealMatrix realMatrix = this.computeWeightedJacobian(dArray);
        RealMatrix realMatrix2 = realMatrix.transpose().multiply(realMatrix);
        DecompositionSolver decompositionSolver = new QRDecomposition(realMatrix2, d).getSolver();
        return decompositionSolver.getInverse().getData();
    }

    @Deprecated
    public double[] guessParametersErrors() {
        if (this.rows <= this.cols) {
            throw new NumberIsTooSmallException((Localizable)LocalizedFormats.NO_DEGREES_OF_FREEDOM, (Number)this.rows, this.cols, false);
        }
        double[] dArray = new double[this.cols];
        double d = FastMath.sqrt(this.getChiSquare() / (double)(this.rows - this.cols));
        double[][] dArray2 = this.computeCovariances(this.point, 1.0E-14);
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = FastMath.sqrt(dArray2[i][i]) * d;
        }
        return dArray;
    }

    public double[] computeSigma(double[] dArray, double d) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        double[][] dArray3 = this.computeCovariances(dArray, d);
        for (int i = 0; i < n; ++i) {
            dArray2[i] = FastMath.sqrt(dArray3[i][i]);
        }
        return dArray2;
    }

    @Override
    @Deprecated
    public PointVectorValuePair optimize(int n, DifferentiableMultivariateVectorFunction differentiableMultivariateVectorFunction, double[] dArray, double[] dArray2, double[] dArray3) {
        return this.optimizeInternal(n, FunctionUtils.toMultivariateDifferentiableVectorFunction(differentiableMultivariateVectorFunction), new OptimizationData[]{new Target(dArray), new Weight(dArray2), new InitialGuess(dArray3)});
    }

    @Override
    @Deprecated
    public PointVectorValuePair optimize(int n, MultivariateDifferentiableVectorFunction multivariateDifferentiableVectorFunction, double[] dArray, double[] dArray2, double[] dArray3) {
        return this.optimizeInternal(n, multivariateDifferentiableVectorFunction, new OptimizationData[]{new Target(dArray), new Weight(dArray2), new InitialGuess(dArray3)});
    }

    @Override
    @Deprecated
    protected PointVectorValuePair optimizeInternal(int n, MultivariateDifferentiableVectorFunction multivariateDifferentiableVectorFunction, OptimizationData ... optimizationDataArray) {
        return super.optimizeInternal(n, FunctionUtils.toDifferentiableMultivariateVectorFunction(multivariateDifferentiableVectorFunction), optimizationDataArray);
    }

    @Override
    protected void setUp() {
        super.setUp();
        this.jacobianEvaluations = 0;
        this.weightMatrixSqrt = this.squareRoot(this.getWeight());
        this.jF = FunctionUtils.toMultivariateDifferentiableVectorFunction((DifferentiableMultivariateVectorFunction)this.getObjectiveFunction());
        this.point = this.getStartPoint();
        this.rows = this.getTarget().length;
        this.cols = this.point.length;
    }

    protected double[] computeResiduals(double[] dArray) {
        double[] dArray2 = this.getTarget();
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray2.length, dArray.length);
        }
        double[] dArray3 = new double[dArray2.length];
        for (int i = 0; i < dArray2.length; ++i) {
            dArray3[i] = dArray2[i] - dArray[i];
        }
        return dArray3;
    }

    private RealMatrix squareRoot(RealMatrix realMatrix) {
        if (realMatrix instanceof DiagonalMatrix) {
            int n = realMatrix.getRowDimension();
            DiagonalMatrix diagonalMatrix = new DiagonalMatrix(n);
            for (int i = 0; i < n; ++i) {
                diagonalMatrix.setEntry(i, i, FastMath.sqrt(realMatrix.getEntry(i, i)));
            }
            return diagonalMatrix;
        }
        EigenDecomposition eigenDecomposition = new EigenDecomposition(realMatrix);
        return eigenDecomposition.getSquareRoot();
    }
}

