/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.linear;

import java.util.ArrayList;
import org.apache.commons.math3.optimization.PointValuePair;
import org.apache.commons.math3.optimization.linear.AbstractLinearOptimizer;
import org.apache.commons.math3.optimization.linear.NoFeasibleSolutionException;
import org.apache.commons.math3.optimization.linear.SimplexTableau;
import org.apache.commons.math3.optimization.linear.UnboundedSolutionException;
import org.apache.commons.math3.util.Precision;

@Deprecated
public class SimplexSolver
extends AbstractLinearOptimizer {
    private static final double DEFAULT_EPSILON = 1.0E-6;
    private static final int DEFAULT_ULPS = 10;
    private final double epsilon;
    private final int maxUlps;

    public SimplexSolver() {
        this(1.0E-6, 10);
    }

    public SimplexSolver(double d, int n) {
        this.epsilon = d;
        this.maxUlps = n;
    }

    private Integer getPivotColumn(SimplexTableau simplexTableau) {
        double d = 0.0;
        Integer n = null;
        for (int i = simplexTableau.getNumObjectiveFunctions(); i < simplexTableau.getWidth() - 1; ++i) {
            double d2 = simplexTableau.getEntry(0, i);
            if (!(d2 < d)) continue;
            d = d2;
            n = i;
        }
        return n;
    }

    private Integer getPivotRow(SimplexTableau simplexTableau, int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        double d = Double.MAX_VALUE;
        for (int i = simplexTableau.getNumObjectiveFunctions(); i < simplexTableau.getHeight(); ++i) {
            double d2 = simplexTableau.getEntry(i, simplexTableau.getWidth() - 1);
            double d3 = simplexTableau.getEntry(i, n);
            if (Precision.compareTo(d3, 0.0, this.maxUlps) <= 0) continue;
            double d4 = d2 / d3;
            int n2 = Double.compare(d4, d);
            if (n2 == 0) {
                arrayList.add(i);
                continue;
            }
            if (n2 >= 0) continue;
            d = d4;
            arrayList = new ArrayList();
            arrayList.add(i);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() > 1) {
            int n3;
            if (simplexTableau.getNumArtificialVariables() > 0) {
                for (Integer n4 : arrayList) {
                    for (n3 = 0; n3 < simplexTableau.getNumArtificialVariables(); ++n3) {
                        int n5 = n3 + simplexTableau.getArtificialVariableOffset();
                        double d5 = simplexTableau.getEntry(n4, n5);
                        if (!Precision.equals(d5, 1.0, this.maxUlps) || !n4.equals(simplexTableau.getBasicRow(n5))) continue;
                        return n4;
                    }
                }
            }
            if (this.getIterations() < this.getMaxIterations() / 2) {
                Integer n6 = null;
                int n7 = simplexTableau.getWidth();
                n3 = simplexTableau.getNumObjectiveFunctions();
                int n8 = simplexTableau.getWidth() - 1;
                for (Integer n9 : arrayList) {
                    for (int i = n3; i < n8 && !n9.equals(n6); ++i) {
                        Integer n10 = simplexTableau.getBasicRow(i);
                        if (n10 == null || !n10.equals(n9) || i >= n7) continue;
                        n7 = i;
                        n6 = n9;
                    }
                }
                return n6;
            }
        }
        return (Integer)arrayList.get(0);
    }

    protected void doIteration(SimplexTableau simplexTableau) {
        this.incrementIterationsCounter();
        Integer n = this.getPivotColumn(simplexTableau);
        Integer n2 = this.getPivotRow(simplexTableau, n);
        if (n2 == null) {
            throw new UnboundedSolutionException();
        }
        double d = simplexTableau.getEntry(n2, n);
        simplexTableau.divideRow(n2, d);
        for (int i = 0; i < simplexTableau.getHeight(); ++i) {
            if (i == n2) continue;
            double d2 = simplexTableau.getEntry(i, n);
            simplexTableau.subtractRow(i, n2, d2);
        }
    }

    protected void solvePhase1(SimplexTableau simplexTableau) {
        if (simplexTableau.getNumArtificialVariables() == 0) {
            return;
        }
        while (!simplexTableau.isOptimal()) {
            this.doIteration(simplexTableau);
        }
        if (!Precision.equals(simplexTableau.getEntry(0, simplexTableau.getRhsOffset()), 0.0, this.epsilon)) {
            throw new NoFeasibleSolutionException();
        }
    }

    public PointValuePair doOptimize() {
        SimplexTableau simplexTableau = new SimplexTableau(this.getFunction(), this.getConstraints(), this.getGoalType(), this.restrictToNonNegative(), this.epsilon, this.maxUlps);
        this.solvePhase1(simplexTableau);
        simplexTableau.dropPhase1Objective();
        while (!simplexTableau.isOptimal()) {
            this.doIteration(simplexTableau);
        }
        return simplexTableau.getSolution();
    }
}

