/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.linear;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.optimization.GoalType;
import org.apache.commons.math3.optimization.PointValuePair;
import org.apache.commons.math3.optimization.linear.LinearConstraint;
import org.apache.commons.math3.optimization.linear.LinearObjectiveFunction;
import org.apache.commons.math3.optimization.linear.Relationship;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
class SimplexTableau
implements Serializable {
    private static final String NEGATIVE_VAR_COLUMN_LABEL = "x-";
    private static final int DEFAULT_ULPS = 10;
    private static final double CUTOFF_THRESHOLD = 1.0E-12;
    private static final long serialVersionUID = -1369660067587938365L;
    private final LinearObjectiveFunction f;
    private final List<LinearConstraint> constraints;
    private final boolean restrictToNonNegative;
    private final List<String> columnLabels = new ArrayList<String>();
    private transient RealMatrix tableau;
    private final int numDecisionVariables;
    private final int numSlackVariables;
    private int numArtificialVariables;
    private final double epsilon;
    private final int maxUlps;

    SimplexTableau(LinearObjectiveFunction linearObjectiveFunction, Collection<LinearConstraint> collection, GoalType goalType, boolean bl, double d) {
        this(linearObjectiveFunction, collection, goalType, bl, d, 10);
    }

    SimplexTableau(LinearObjectiveFunction linearObjectiveFunction, Collection<LinearConstraint> collection, GoalType goalType, boolean bl, double d, int n) {
        this.f = linearObjectiveFunction;
        this.constraints = this.normalizeConstraints(collection);
        this.restrictToNonNegative = bl;
        this.epsilon = d;
        this.maxUlps = n;
        this.numDecisionVariables = linearObjectiveFunction.getCoefficients().getDimension() + (bl ? 0 : 1);
        this.numSlackVariables = this.getConstraintTypeCounts(Relationship.LEQ) + this.getConstraintTypeCounts(Relationship.GEQ);
        this.numArtificialVariables = this.getConstraintTypeCounts(Relationship.EQ) + this.getConstraintTypeCounts(Relationship.GEQ);
        this.tableau = this.createTableau(goalType == GoalType.MAXIMIZE);
        this.initializeColumnLabels();
    }

    protected void initializeColumnLabels() {
        int n;
        if (this.getNumObjectiveFunctions() == 2) {
            this.columnLabels.add("W");
        }
        this.columnLabels.add("Z");
        for (n = 0; n < this.getOriginalNumDecisionVariables(); ++n) {
            this.columnLabels.add("x" + n);
        }
        if (!this.restrictToNonNegative) {
            this.columnLabels.add(NEGATIVE_VAR_COLUMN_LABEL);
        }
        for (n = 0; n < this.getNumSlackVariables(); ++n) {
            this.columnLabels.add("s" + n);
        }
        for (n = 0; n < this.getNumArtificialVariables(); ++n) {
            this.columnLabels.add("a" + n);
        }
        this.columnLabels.add("RHS");
    }

    protected RealMatrix createTableau(boolean bl) {
        int n = this.numDecisionVariables + this.numSlackVariables + this.numArtificialVariables + this.getNumObjectiveFunctions() + 1;
        int n2 = this.constraints.size() + this.getNumObjectiveFunctions();
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(n2, n);
        if (this.getNumObjectiveFunctions() == 2) {
            array2DRowRealMatrix.setEntry(0, 0, -1.0);
        }
        int n3 = this.getNumObjectiveFunctions() == 1 ? 0 : 1;
        array2DRowRealMatrix.setEntry(n3, n3, bl ? 1.0 : -1.0);
        RealVector realVector = bl ? this.f.getCoefficients().mapMultiply(-1.0) : this.f.getCoefficients();
        this.copyArray(realVector.toArray(), array2DRowRealMatrix.getDataRef()[n3]);
        array2DRowRealMatrix.setEntry(n3, n - 1, bl ? this.f.getConstantTerm() : -1.0 * this.f.getConstantTerm());
        if (!this.restrictToNonNegative) {
            array2DRowRealMatrix.setEntry(n3, this.getSlackVariableOffset() - 1, SimplexTableau.getInvertedCoefficientSum(realVector));
        }
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < this.constraints.size(); ++i) {
            LinearConstraint linearConstraint = this.constraints.get(i);
            int n6 = this.getNumObjectiveFunctions() + i;
            this.copyArray(linearConstraint.getCoefficients().toArray(), array2DRowRealMatrix.getDataRef()[n6]);
            if (!this.restrictToNonNegative) {
                array2DRowRealMatrix.setEntry(n6, this.getSlackVariableOffset() - 1, SimplexTableau.getInvertedCoefficientSum(linearConstraint.getCoefficients()));
            }
            array2DRowRealMatrix.setEntry(n6, n - 1, linearConstraint.getValue());
            if (linearConstraint.getRelationship() == Relationship.LEQ) {
                array2DRowRealMatrix.setEntry(n6, this.getSlackVariableOffset() + n4++, 1.0);
            } else if (linearConstraint.getRelationship() == Relationship.GEQ) {
                array2DRowRealMatrix.setEntry(n6, this.getSlackVariableOffset() + n4++, -1.0);
            }
            if (linearConstraint.getRelationship() != Relationship.EQ && linearConstraint.getRelationship() != Relationship.GEQ) continue;
            array2DRowRealMatrix.setEntry(0, this.getArtificialVariableOffset() + n5, 1.0);
            array2DRowRealMatrix.setEntry(n6, this.getArtificialVariableOffset() + n5++, 1.0);
            array2DRowRealMatrix.setRowVector(0, array2DRowRealMatrix.getRowVector(0).subtract(array2DRowRealMatrix.getRowVector(n6)));
        }
        return array2DRowRealMatrix;
    }

    public List<LinearConstraint> normalizeConstraints(Collection<LinearConstraint> collection) {
        ArrayList<LinearConstraint> arrayList = new ArrayList<LinearConstraint>(collection.size());
        for (LinearConstraint linearConstraint : collection) {
            arrayList.add(this.normalize(linearConstraint));
        }
        return arrayList;
    }

    private LinearConstraint normalize(LinearConstraint linearConstraint) {
        if (linearConstraint.getValue() < 0.0) {
            return new LinearConstraint(linearConstraint.getCoefficients().mapMultiply(-1.0), linearConstraint.getRelationship().oppositeRelationship(), -1.0 * linearConstraint.getValue());
        }
        return new LinearConstraint(linearConstraint.getCoefficients(), linearConstraint.getRelationship(), linearConstraint.getValue());
    }

    protected final int getNumObjectiveFunctions() {
        return this.numArtificialVariables > 0 ? 2 : 1;
    }

    private int getConstraintTypeCounts(Relationship relationship) {
        int n = 0;
        for (LinearConstraint linearConstraint : this.constraints) {
            if (linearConstraint.getRelationship() != relationship) continue;
            ++n;
        }
        return n;
    }

    protected static double getInvertedCoefficientSum(RealVector realVector) {
        double d = 0.0;
        for (double d2 : realVector.toArray()) {
            d -= d2;
        }
        return d;
    }

    protected Integer getBasicRow(int n) {
        Integer n2 = null;
        for (int i = 0; i < this.getHeight(); ++i) {
            double d = this.getEntry(i, n);
            if (Precision.equals(d, 1.0, this.maxUlps) && n2 == null) {
                n2 = i;
                continue;
            }
            if (Precision.equals(d, 0.0, this.maxUlps)) continue;
            return null;
        }
        return n2;
    }

    protected void dropPhase1Objective() {
        int n;
        int n2;
        if (this.getNumObjectiveFunctions() == 1) {
            return;
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        treeSet.add(0);
        for (n2 = this.getNumObjectiveFunctions(); n2 < this.getArtificialVariableOffset(); ++n2) {
            double d = this.tableau.getEntry(0, n2);
            if (Precision.compareTo(d, 0.0, this.epsilon) <= 0) continue;
            treeSet.add(n2);
        }
        for (n2 = 0; n2 < this.getNumArtificialVariables(); ++n2) {
            int n3 = n2 + this.getArtificialVariableOffset();
            if (this.getBasicRow(n3) != null) continue;
            treeSet.add(n3);
        }
        double[][] dArray = new double[this.getHeight() - 1][this.getWidth() - treeSet.size()];
        for (int i = 1; i < this.getHeight(); ++i) {
            n = 0;
            for (int j = 0; j < this.getWidth(); ++j) {
                if (treeSet.contains(j)) continue;
                dArray[i - 1][n++] = this.tableau.getEntry(i, j);
            }
        }
        Integer[] integerArray = treeSet.toArray(new Integer[treeSet.size()]);
        for (n = integerArray.length - 1; n >= 0; --n) {
            this.columnLabels.remove(integerArray[n]);
        }
        this.tableau = new Array2DRowRealMatrix(dArray);
        this.numArtificialVariables = 0;
    }

    private void copyArray(double[] dArray, double[] dArray2) {
        System.arraycopy(dArray, 0, dArray2, this.getNumObjectiveFunctions(), dArray.length);
    }

    boolean isOptimal() {
        for (int i = this.getNumObjectiveFunctions(); i < this.getWidth() - 1; ++i) {
            double d = this.tableau.getEntry(0, i);
            if (Precision.compareTo(d, 0.0, this.epsilon) >= 0) continue;
            return false;
        }
        return true;
    }

    protected PointValuePair getSolution() {
        int n = this.columnLabels.indexOf(NEGATIVE_VAR_COLUMN_LABEL);
        Integer n2 = n > 0 ? this.getBasicRow(n) : null;
        double d = n2 == null ? 0.0 : this.getEntry(n2, this.getRhsOffset());
        HashSet<Integer> hashSet = new HashSet<Integer>();
        double[] dArray = new double[this.getOriginalNumDecisionVariables()];
        for (int i = 0; i < dArray.length; ++i) {
            int n3 = this.columnLabels.indexOf("x" + i);
            if (n3 < 0) {
                dArray[i] = 0.0;
                continue;
            }
            Integer n4 = this.getBasicRow(n3);
            if (n4 != null && n4 == 0) {
                dArray[i] = 0.0;
                continue;
            }
            if (hashSet.contains(n4)) {
                dArray[i] = 0.0 - (this.restrictToNonNegative ? 0.0 : d);
                continue;
            }
            hashSet.add(n4);
            dArray[i] = (n4 == null ? 0.0 : this.getEntry(n4, this.getRhsOffset())) - (this.restrictToNonNegative ? 0.0 : d);
        }
        return new PointValuePair(dArray, this.f.getValue(dArray));
    }

    protected void divideRow(int n, double d) {
        for (int i = 0; i < this.getWidth(); ++i) {
            this.tableau.setEntry(n, i, this.tableau.getEntry(n, i) / d);
        }
    }

    protected void subtractRow(int n, int n2, double d) {
        for (int i = 0; i < this.getWidth(); ++i) {
            double d2 = this.tableau.getEntry(n, i) - this.tableau.getEntry(n2, i) * d;
            if (FastMath.abs(d2) < 1.0E-12) {
                d2 = 0.0;
            }
            this.tableau.setEntry(n, i, d2);
        }
    }

    protected final int getWidth() {
        return this.tableau.getColumnDimension();
    }

    protected final int getHeight() {
        return this.tableau.getRowDimension();
    }

    protected final double getEntry(int n, int n2) {
        return this.tableau.getEntry(n, n2);
    }

    protected final void setEntry(int n, int n2, double d) {
        this.tableau.setEntry(n, n2, d);
    }

    protected final int getSlackVariableOffset() {
        return this.getNumObjectiveFunctions() + this.numDecisionVariables;
    }

    protected final int getArtificialVariableOffset() {
        return this.getNumObjectiveFunctions() + this.numDecisionVariables + this.numSlackVariables;
    }

    protected final int getRhsOffset() {
        return this.getWidth() - 1;
    }

    protected final int getNumDecisionVariables() {
        return this.numDecisionVariables;
    }

    protected final int getOriginalNumDecisionVariables() {
        return this.f.getCoefficients().getDimension();
    }

    protected final int getNumSlackVariables() {
        return this.numSlackVariables;
    }

    protected final int getNumArtificialVariables() {
        return this.numArtificialVariables;
    }

    protected final double[][] getData() {
        return this.tableau.getData();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SimplexTableau) {
            SimplexTableau simplexTableau = (SimplexTableau)object;
            return this.restrictToNonNegative == simplexTableau.restrictToNonNegative && this.numDecisionVariables == simplexTableau.numDecisionVariables && this.numSlackVariables == simplexTableau.numSlackVariables && this.numArtificialVariables == simplexTableau.numArtificialVariables && this.epsilon == simplexTableau.epsilon && this.maxUlps == simplexTableau.maxUlps && this.f.equals(simplexTableau.f) && this.constraints.equals(simplexTableau.constraints) && this.tableau.equals(simplexTableau.tableau);
        }
        return false;
    }

    public int hashCode() {
        return Boolean.valueOf(this.restrictToNonNegative).hashCode() ^ this.numDecisionVariables ^ this.numSlackVariables ^ this.numArtificialVariables ^ Double.valueOf(this.epsilon).hashCode() ^ this.maxUlps ^ this.f.hashCode() ^ this.constraints.hashCode() ^ this.tableau.hashCode();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        MatrixUtils.serializeRealMatrix(this.tableau, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        MatrixUtils.deserializeRealMatrix(this, "tableau", objectInputStream);
    }
}

