/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.primes;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.primes.SmallPrimes;
import org.apache.commons.math3.util.FastMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PollardRho {
    private PollardRho() {
    }

    public static List<Integer> primeFactors(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (1 == (n = SmallPrimes.smallTrialDivision(n, arrayList))) {
            return arrayList;
        }
        if (SmallPrimes.millerRabinPrimeTest(n)) {
            arrayList.add(n);
            return arrayList;
        }
        int n2 = PollardRho.rhoBrent(n);
        arrayList.add(n2);
        arrayList.add(n / n2);
        return arrayList;
    }

    static int rhoBrent(int n) {
        int n2 = 2;
        int n3 = 25;
        int n4 = SmallPrimes.PRIMES_LAST;
        int n5 = 2;
        int n6 = 1;
        while (true) {
            int n7;
            int n8 = n5;
            for (n7 = 0; n7 < n6; ++n7) {
                long l = (long)n5 * (long)n5;
                n5 = (int)((l + (long)n4) % (long)n);
            }
            n7 = 0;
            do {
                int n9;
                int n10 = FastMath.min(25, n6 - n7);
                int n11 = 1;
                for (n9 = -3; n9 < n10; ++n9) {
                    long l = (long)n5 * (long)n5;
                    long l2 = FastMath.abs(n8 - (n5 = (int)((l + (long)n4) % (long)n)));
                    if (0L == l2) {
                        n4 += SmallPrimes.PRIMES_LAST;
                        n7 = -25;
                        n5 = 2;
                        n6 = 1;
                        break;
                    }
                    long l3 = l2 * (long)n11;
                    if (0 != (n11 = (int)(l3 % (long)n))) continue;
                    return PollardRho.gcdPositive(FastMath.abs((int)l2), n);
                }
                if (1 == (n9 = PollardRho.gcdPositive(FastMath.abs(n11), n))) continue;
                return n9;
            } while ((n7 += 25) < n6);
            n6 = 2 * n6;
        }
    }

    static int gcdPositive(int n, int n2) {
        if (n == 0) {
            return n2;
        }
        if (n2 == 0) {
            return n;
        }
        int n3 = Integer.numberOfTrailingZeros(n);
        n >>= n3;
        int n4 = Integer.numberOfTrailingZeros(n2);
        n2 >>= n4;
        int n5 = FastMath.min(n3, n4);
        while (n != n2) {
            int n6 = n - n2;
            n2 = FastMath.min(n, n2);
            n = FastMath.abs(n6);
            n >>= Integer.numberOfTrailingZeros(n);
        }
        return n << n5;
    }
}

