/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.random;

import java.io.Serializable;
import org.apache.commons.math3.random.BitsStreamGenerator;
import org.apache.commons.math3.util.FastMath;

public class ISAACRandom
extends BitsStreamGenerator
implements Serializable {
    private static final long serialVersionUID = 7288197941165002400L;
    private static final int SIZE_L = 8;
    private static final int SIZE = 256;
    private static final int H_SIZE = 128;
    private static final int MASK = 1020;
    private static final int GLD_RATIO = -1640531527;
    private final int[] rsl = new int[256];
    private final int[] mem = new int[256];
    private int count;
    private int isaacA;
    private int isaacB;
    private int isaacC;
    private final int[] arr = new int[8];
    private int isaacX;
    private int isaacI;
    private int isaacJ;

    public ISAACRandom() {
        this.setSeed(System.currentTimeMillis() + (long)System.identityHashCode(this));
    }

    public ISAACRandom(long l) {
        this.setSeed(l);
    }

    public ISAACRandom(int[] nArray) {
        this.setSeed(nArray);
    }

    public void setSeed(int n) {
        this.setSeed(new int[]{n});
    }

    public void setSeed(long l) {
        this.setSeed(new int[]{(int)(l >>> 32), (int)(l & 0xFFFFFFFFL)});
    }

    public void setSeed(int[] nArray) {
        if (nArray == null) {
            this.setSeed(System.currentTimeMillis() + (long)System.identityHashCode(this));
            return;
        }
        int n = nArray.length;
        int n2 = this.rsl.length;
        System.arraycopy(nArray, 0, this.rsl, 0, FastMath.min(n, n2));
        if (n < n2) {
            for (int i = n; i < n2; ++i) {
                long l = this.rsl[i - n];
                this.rsl[i] = (int)(1812433253L * (l ^ l >> 30) + (long)i & 0xFFFFFFFFL);
            }
        }
        this.initState();
    }

    protected int next(int n) {
        if (this.count < 0) {
            this.isaac();
            this.count = 255;
        }
        return this.rsl[this.count--] >>> 32 - n;
    }

    private void isaac() {
        this.isaacI = 0;
        this.isaacJ = 128;
        this.isaacB += ++this.isaacC;
        while (this.isaacI < 128) {
            this.isaac2();
        }
        this.isaacJ = 0;
        while (this.isaacJ < 128) {
            this.isaac2();
        }
    }

    private void isaac2() {
        this.isaacX = this.mem[this.isaacI];
        this.isaacA ^= this.isaacA << 13;
        this.isaacA += this.mem[this.isaacJ++];
        this.isaac3();
        this.isaacX = this.mem[this.isaacI];
        this.isaacA ^= this.isaacA >>> 6;
        this.isaacA += this.mem[this.isaacJ++];
        this.isaac3();
        this.isaacX = this.mem[this.isaacI];
        this.isaacA ^= this.isaacA << 2;
        this.isaacA += this.mem[this.isaacJ++];
        this.isaac3();
        this.isaacX = this.mem[this.isaacI];
        this.isaacA ^= this.isaacA >>> 16;
        this.isaacA += this.mem[this.isaacJ++];
        this.isaac3();
    }

    private void isaac3() {
        this.mem[this.isaacI] = this.mem[(this.isaacX & 0x3FC) >> 2] + this.isaacA + this.isaacB;
        this.isaacB = this.mem[(this.mem[this.isaacI] >> 8 & 0x3FC) >> 2] + this.isaacX;
        this.rsl[this.isaacI++] = this.isaacB;
    }

    private void initState() {
        int n;
        this.isaacA = 0;
        this.isaacB = 0;
        this.isaacC = 0;
        for (n = 0; n < this.arr.length; ++n) {
            this.arr[n] = -1640531527;
        }
        for (n = 0; n < 4; ++n) {
            this.shuffle();
        }
        for (n = 0; n < 256; n += 8) {
            this.arr[0] = this.arr[0] + this.rsl[n];
            this.arr[1] = this.arr[1] + this.rsl[n + 1];
            this.arr[2] = this.arr[2] + this.rsl[n + 2];
            this.arr[3] = this.arr[3] + this.rsl[n + 3];
            this.arr[4] = this.arr[4] + this.rsl[n + 4];
            this.arr[5] = this.arr[5] + this.rsl[n + 5];
            this.arr[6] = this.arr[6] + this.rsl[n + 6];
            this.arr[7] = this.arr[7] + this.rsl[n + 7];
            this.shuffle();
            this.setState(n);
        }
        for (n = 0; n < 256; n += 8) {
            this.arr[0] = this.arr[0] + this.mem[n];
            this.arr[1] = this.arr[1] + this.mem[n + 1];
            this.arr[2] = this.arr[2] + this.mem[n + 2];
            this.arr[3] = this.arr[3] + this.mem[n + 3];
            this.arr[4] = this.arr[4] + this.mem[n + 4];
            this.arr[5] = this.arr[5] + this.mem[n + 5];
            this.arr[6] = this.arr[6] + this.mem[n + 6];
            this.arr[7] = this.arr[7] + this.mem[n + 7];
            this.shuffle();
            this.setState(n);
        }
        this.isaac();
        this.count = 255;
        this.clear();
    }

    private void shuffle() {
        this.arr[0] = this.arr[0] ^ this.arr[1] << 11;
        this.arr[3] = this.arr[3] + this.arr[0];
        this.arr[1] = this.arr[1] + this.arr[2];
        this.arr[1] = this.arr[1] ^ this.arr[2] >>> 2;
        this.arr[4] = this.arr[4] + this.arr[1];
        this.arr[2] = this.arr[2] + this.arr[3];
        this.arr[2] = this.arr[2] ^ this.arr[3] << 8;
        this.arr[5] = this.arr[5] + this.arr[2];
        this.arr[3] = this.arr[3] + this.arr[4];
        this.arr[3] = this.arr[3] ^ this.arr[4] >>> 16;
        this.arr[6] = this.arr[6] + this.arr[3];
        this.arr[4] = this.arr[4] + this.arr[5];
        this.arr[4] = this.arr[4] ^ this.arr[5] << 10;
        this.arr[7] = this.arr[7] + this.arr[4];
        this.arr[5] = this.arr[5] + this.arr[6];
        this.arr[5] = this.arr[5] ^ this.arr[6] >>> 4;
        this.arr[0] = this.arr[0] + this.arr[5];
        this.arr[6] = this.arr[6] + this.arr[7];
        this.arr[6] = this.arr[6] ^ this.arr[7] << 8;
        this.arr[1] = this.arr[1] + this.arr[6];
        this.arr[7] = this.arr[7] + this.arr[0];
        this.arr[7] = this.arr[7] ^ this.arr[0] >>> 9;
        this.arr[2] = this.arr[2] + this.arr[7];
        this.arr[0] = this.arr[0] + this.arr[1];
    }

    private void setState(int n) {
        this.mem[n] = this.arr[0];
        this.mem[n + 1] = this.arr[1];
        this.mem[n + 2] = this.arr[2];
        this.mem[n + 3] = this.arr[3];
        this.mem[n + 4] = this.arr[4];
        this.mem[n + 5] = this.arr[5];
        this.mem[n + 6] = this.arr[6];
        this.mem[n + 7] = this.arr[7];
    }
}

