/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.random;

import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.NormalizedRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.util.FastMath;

public class StableRandomGenerator
implements NormalizedRandomGenerator {
    private final RandomGenerator generator;
    private final double alpha;
    private final double beta;
    private final double zeta;

    public StableRandomGenerator(RandomGenerator randomGenerator, double d, double d2) {
        if (randomGenerator == null) {
            throw new NullArgumentException();
        }
        if (!(d > 0.0) || !(d <= 2.0)) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_RANGE_LEFT, (Number)d, 0, 2);
        }
        if (!(d2 >= -1.0) || !(d2 <= 1.0)) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.OUT_OF_RANGE_SIMPLE, (Number)d2, -1, 1);
        }
        this.generator = randomGenerator;
        this.alpha = d;
        this.beta = d2;
        this.zeta = d < 2.0 && d2 != 0.0 ? d2 * FastMath.tan(Math.PI * d / 2.0) : 0.0;
    }

    public double nextNormalizedDouble() {
        double d;
        double d2 = -FastMath.log(this.generator.nextDouble());
        double d3 = Math.PI * (this.generator.nextDouble() - 0.5);
        if (this.alpha == 2.0) {
            return FastMath.sqrt(2.0 * d2) * FastMath.sin(d3);
        }
        if (this.beta == 0.0) {
            d = this.alpha == 1.0 ? FastMath.tan(d3) : FastMath.pow(d2 * FastMath.cos((1.0 - this.alpha) * d3), 1.0 / this.alpha - 1.0) * FastMath.sin(this.alpha * d3) / FastMath.pow(FastMath.cos(d3), 1.0 / this.alpha);
        } else {
            double d4 = FastMath.cos(d3);
            if (FastMath.abs(this.alpha - 1.0) > 1.0E-8) {
                double d5 = this.alpha * d3;
                double d6 = d3 - d5;
                d = (FastMath.sin(d5) + this.zeta * FastMath.cos(d5)) / d4 * (FastMath.cos(d6) + this.zeta * FastMath.sin(d6)) / FastMath.pow(d2 * d4, (1.0 - this.alpha) / this.alpha);
            } else {
                double d7 = 1.5707963267948966 + this.beta * d3;
                d = 0.6366197723675814 * (d7 * FastMath.tan(d3) - this.beta * FastMath.log(1.5707963267948966 * d2 * d4 / d7));
                if (this.alpha != 1.0) {
                    d += this.beta * FastMath.tan(Math.PI * this.alpha / 2.0);
                }
            }
        }
        return d;
    }
}

