/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.special;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.exception.ConvergenceException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;

public class BesselJ
implements UnivariateFunction {
    private static final double PI2 = 0.6366197723675814;
    private static final double TOWPI1 = 6.28125;
    private static final double TWOPI2 = 0.001935307179586477;
    private static final double TWOPI = Math.PI * 2;
    private static final double ENTEN = 1.0E308;
    private static final double ENSIG = 1.0E16;
    private static final double RTNSIG = 1.0E-4;
    private static final double ENMTEN = 8.9E-308;
    private static final double X_MIN = 0.0;
    private static final double X_MAX = 10000.0;
    private static final double[] FACT = new double[]{1.0, 1.0, 2.0, 6.0, 24.0, 120.0, 720.0, 5040.0, 40320.0, 362880.0, 3628800.0, 3.99168E7, 4.790016E8, 6.2270208E9, 8.71782912E10, 1.307674368E12, 2.0922789888E13, 3.55687428096E14, 6.402373705728E15, 1.21645100408832E17, 2.43290200817664E18, 5.109094217170944E19, 1.1240007277776077E21, 2.585201673888498E22, 6.204484017332394E23};
    private final double order;

    public BesselJ(double d) {
        this.order = d;
    }

    public double value(double d) {
        return BesselJ.value(this.order, d);
    }

    public static double value(double d, double d2) {
        int n = (int)d;
        double d3 = d - (double)n;
        int n2 = n + 1;
        BesselJResult besselJResult = BesselJ.rjBesl(d2, d3, n2);
        if (besselJResult.nVals >= n2) {
            return besselJResult.vals[n];
        }
        if (besselJResult.nVals < 0) {
            throw new MathIllegalArgumentException(LocalizedFormats.BESSEL_FUNCTION_BAD_ARGUMENT, d, d2);
        }
        if (FastMath.abs(besselJResult.vals[besselJResult.nVals - 1]) < 1.0E-100) {
            return besselJResult.vals[n];
        }
        throw new ConvergenceException(LocalizedFormats.BESSEL_FUNCTION_FAILED_CONVERGENCE, d, d2);
    }

    public static BesselJResult rjBesl(double d, double d2, int n) {
        double[] dArray = new double[n];
        int n2 = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n3 = (int)d;
        if (n > 0 && d >= 0.0 && d <= 10000.0 && d2 >= 0.0 && d2 < 1.0) {
            n2 = n;
            for (int i = 0; i < n; ++i) {
                dArray[i] = 0.0;
            }
            if (d < 1.0E-4) {
                double d5 = 1.0;
                d3 = 1.0 + d2;
                double d6 = 0.0;
                if (d > 8.9E-308) {
                    d6 = 0.5 * d;
                }
                if (d2 != 0.0) {
                    d5 = FastMath.pow(d6, d2) / (d2 * Gamma.gamma(d2));
                }
                double d7 = 0.0;
                if (d + 1.0 > 1.0) {
                    d7 = -d6 * d6;
                }
                dArray[0] = d5 + d5 * d7 / d3;
                if (d != 0.0 && dArray[0] == 0.0) {
                    n2 = 0;
                }
                if (n != 1) {
                    if (d <= 0.0) {
                        for (int i = 1; i < n; ++i) {
                            dArray[i] = 0.0;
                        }
                    } else {
                        double d8 = d6;
                        double d9 = d7 != 0.0 ? 8.9E-308 / d7 : 1.78E-307 / d;
                        for (int i = 1; i < n; ++i) {
                            d5 /= d3;
                            if ((d5 *= d8) <= d9 * (d3 += 1.0)) {
                                d5 = 0.0;
                            }
                            dArray[i] = d5 + d5 * d7 / d3;
                            if (dArray[i] != 0.0 || n2 <= i) continue;
                            n2 = i;
                        }
                    }
                }
            } else if (d > 25.0 && n <= n3 + 1) {
                int n4;
                double d10 = FastMath.sqrt(0.6366197723675814 / d);
                double d11 = 0.125 / d;
                double d12 = d11 * d11;
                int n5 = 0;
                n5 = d >= 130.0 ? 4 : (d >= 35.0 ? 8 : 11);
                double d13 = 4.0 * (double)n5;
                double d14 = (int)(d / (Math.PI * 2) + 0.5);
                double d15 = d - d14 * 6.28125 - d14 * 0.001935307179586477 - (d2 + 0.5) / 0.6366197723675814;
                double d16 = FastMath.sin(d15);
                double d17 = FastMath.cos(d15);
                double d18 = 2.0 * d2;
                for (n4 = 1; n4 <= 2; ++n4) {
                    double d19 = (d13 - 1.0 - d18) * (d13 - 1.0 + d18) * d12 * 0.5;
                    d14 = (d18 - (d13 - 3.0)) * (d18 + (d13 - 3.0));
                    double d20 = d19 * d14 / FACT[2 * n5];
                    double d21 = (d18 - (d13 + 1.0)) * (d18 + (d13 + 1.0));
                    double d22 = d19 * d21 / FACT[2 * n5 + 1];
                    double d23 = d13;
                    int n6 = 2 * n5;
                    d21 = d14;
                    for (int i = 2; i <= n5; ++i) {
                        d19 = ((d23 -= 4.0) - 1.0 - d18) * (d23 - 1.0 + d18);
                        d14 = (d18 - (d23 - 3.0)) * (d18 + (d23 - 3.0));
                        d20 = (d20 + 1.0 / FACT[n6 - 2]) * d19 * d14 * d12;
                        d22 = (d22 + 1.0 / FACT[n6 - 1]) * d19 * d21 * d12;
                        n6 -= 2;
                        d21 = d14;
                    }
                    d22 = (d22 + 1.0) * (d18 * d18 - 1.0) * (0.125 / d);
                    dArray[n4 - 1] = d10 * ((d20 += 1.0) * d17 - d22 * d16);
                    if (n == 1) {
                        return new BesselJResult(MathArrays.copyOf(dArray, dArray.length), n2);
                    }
                    d14 = d16;
                    d16 = -d17;
                    d17 = d14;
                    d18 += 2.0;
                }
                if (n > 2) {
                    d18 = 2.0 * d2 + 2.0;
                    for (n4 = 2; n4 < n; ++n4) {
                        dArray[n4] = d18 * dArray[n4 - 1] / d - dArray[n4 - 2];
                        d18 += 2.0;
                    }
                }
            } else {
                int n7;
                int n8;
                double d24;
                double d25;
                int n9 = n - n3;
                int n10 = n3 + 1;
                int n11 = 0;
                int n12 = 0;
                double d26 = 2.0 * ((double)n10 + d2);
                double d27 = 1.0;
                double d28 = d26 / d;
                double d29 = 2.0E16;
                boolean bl = false;
                if (n9 >= 3) {
                    double d30 = 1.0E292;
                    n11 = n3 + 2;
                    n12 = n - 1;
                    d26 = 2.0 * ((double)(n11 - 1) + d2);
                    int n13 = n11;
                    while (n13 <= n12) {
                        n10 = n13++;
                        d27 = d28;
                        d25 = d27;
                        if (!((d28 = (d26 += 2.0) * d27 / d - d25) > d30)) continue;
                        d30 = 1.0E308;
                        double d31 = d28 /= d30;
                        double d32 = d27 /= d30;
                        n11 = n10 + 1;
                        do {
                            ++n10;
                        } while ((d28 = (d26 += 2.0) * (d27 = d28) / d - (d25 = d27)) <= 1.0);
                        d24 = d26 / d;
                        d29 = d25 * d27 * (0.5 - 0.5 / (d24 * d24));
                        d29 /= 1.0E16;
                        d28 = d27 * d30;
                        d26 -= 2.0;
                        n12 = FastMath.min(n, --n10);
                        for (n8 = n11; n8 <= n12; ++n8) {
                            d32 = d31;
                            d25 = d32;
                            if (!((d31 = d26 * d32 / d - d25) * d32 > d29)) continue;
                            n2 = n8 - 1;
                            bl = true;
                            break;
                        }
                        n2 = n12;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        n10 = n12;
                        d26 = 2.0 * ((double)n10 + d2);
                        d29 = FastMath.max(d29, FastMath.sqrt(d27 * 1.0E16) * FastMath.sqrt(2.0 * d28));
                    }
                }
                if (!bl) {
                    do {
                        ++n10;
                    } while ((d28 = (d26 += 2.0) * (d27 = d28) / d - (d25 = d27)) < d29);
                }
                d26 += 2.0;
                d24 = 0.0;
                double d33 = 1.0 / d28;
                int n14 = 2 * ++n10 - 4 * (n10 / 2);
                double d34 = 0.0;
                double d35 = n10 / 2;
                d3 = d35 - 1.0 + d2;
                d4 = 2.0 * d35 + d2;
                if (n14 != 0) {
                    d34 = d33 * d3 * d4 / d35;
                }
                n12 = n10 - n;
                n8 = 0;
                boolean bl2 = false;
                for (n7 = 1; n7 <= n12; ++n7) {
                    --n10;
                    double d36 = d24;
                    d24 = d33;
                    d33 = (d26 -= 2.0) * d24 / d - d36;
                    if ((n14 = 2 - n14) == 0) continue;
                    d4 = 2.0 * (d35 -= 1.0) + d2;
                    if (n10 == 1) break;
                    d3 = d35 - 1.0 + d2;
                    if (d3 == 0.0) {
                        d3 = 1.0;
                    }
                    d34 = (d34 + d33 * d4) * d3 / d35;
                }
                dArray[n10 - 1] = d33;
                if (n12 >= 0) {
                    if (n <= 1) {
                        d4 = d2;
                        if (d2 + 1.0 == 1.0) {
                            d4 = 1.0;
                        }
                        d34 += dArray[0] * d4;
                        n8 = 1;
                    } else {
                        dArray[--n10 - 1] = (d26 -= 2.0) * d33 / d - d24;
                        if (n10 == 1) {
                            bl2 = true;
                        } else if ((n14 = 2 - n14) != 0) {
                            d4 = 2.0 * (d35 -= 1.0) + d2;
                            d3 = d35 - 1.0 + d2;
                            if (d3 == 0.0) {
                                d3 = 1.0;
                            }
                            d34 = (d34 + dArray[n10 - 1] * d4) * d3 / d35;
                        }
                    }
                }
                if (n8 == 0 && !bl2 && (n12 = n10 - 2) != 0) {
                    for (n7 = 1; n7 <= n12; ++n7) {
                        dArray[--n10 - 1] = (d26 -= 2.0) * dArray[n10] / d - dArray[n10 + 1];
                        if ((n14 = 2 - n14) == 0) continue;
                        d4 = 2.0 * (d35 -= 1.0) + d2;
                        d3 = d35 - 1.0 + d2;
                        if (d3 == 0.0) {
                            d3 = 1.0;
                        }
                        d34 = (d34 + dArray[n10 - 1] * d4) * d3 / d35;
                    }
                }
                if (n8 == 0) {
                    if (!bl2) {
                        dArray[0] = 2.0 * (d2 + 1.0) * dArray[1] / d - dArray[2];
                    }
                    if ((d4 = 2.0 * (d35 -= 1.0) + d2) == 0.0) {
                        d4 = 1.0;
                    }
                    d34 += dArray[0] * d4;
                }
                if (FastMath.abs(d2) > 1.0E-16) {
                    d34 *= Gamma.gamma(d2) * FastMath.pow(d * 0.5, -d2);
                }
                d33 = 8.9E-308;
                if (d34 > 1.0) {
                    d33 *= d34;
                }
                n10 = 0;
                while (n10 < n) {
                    if (FastMath.abs(dArray[n10]) < d33) {
                        dArray[n10] = 0.0;
                    }
                    int n15 = n10++;
                    dArray[n15] = dArray[n15] / d34;
                }
            }
        } else {
            if (dArray.length > 0) {
                dArray[0] = 0.0;
            }
            n2 = FastMath.min(n, 0) - 1;
        }
        return new BesselJResult(MathArrays.copyOf(dArray, dArray.length), n2);
    }

    public static class BesselJResult {
        private final double[] vals;
        private final int nVals;

        public BesselJResult(double[] dArray, int n) {
            this.vals = MathArrays.copyOf(dArray, dArray.length);
            this.nVals = n;
        }

        public double[] getVals() {
            return MathArrays.copyOf(this.vals, this.vals.length);
        }

        public int getnVals() {
            return this.nVals;
        }
    }
}

